/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.controller;

import ai.grakn.GraknConfigKey;
import ai.grakn.Keyspace;
import ai.grakn.engine.GraknConfig;
import ai.grakn.engine.KeyspaceStore;
import ai.grakn.engine.ServerStatus;
import ai.grakn.engine.controller.HttpController;
import ai.grakn.engine.controller.response.Keyspaces;
import ai.grakn.engine.controller.response.Root;
import ai.grakn.engine.controller.util.Requests;
import ai.grakn.exception.GraknServerException;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.json.MetricsModule;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.dropwizard.DropwizardExports;
import io.prometheus.client.exporter.common.TextFormat;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.util.Enumeration;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import org.apache.commons.io.Charsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Request;
import spark.Response;
import spark.Service;

public class SystemController
implements HttpController {
    private static final String PROMETHEUS_CONTENT_TYPE = "text/plain; version=0.0.4";
    private static final String PROMETHEUS = "prometheus";
    private static final String JSON = "json";
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private final Logger LOG = LoggerFactory.getLogger(SystemController.class);
    private final ServerStatus serverStatus;
    private final MetricRegistry metricRegistry;
    private final ObjectMapper mapper;
    private final CollectorRegistry prometheusRegistry;
    private final KeyspaceStore keyspaceStore;
    private final GraknConfig config;

    public SystemController(GraknConfig config, KeyspaceStore keyspaceStore, ServerStatus serverStatus, MetricRegistry metricRegistry) {
        this.keyspaceStore = keyspaceStore;
        this.config = config;
        this.serverStatus = serverStatus;
        this.metricRegistry = metricRegistry;
        DropwizardExports prometheusMetricWrapper = new DropwizardExports(metricRegistry);
        this.prometheusRegistry = new CollectorRegistry();
        this.prometheusRegistry.register((Collector)prometheusMetricWrapper);
        TimeUnit rateUnit = TimeUnit.SECONDS;
        TimeUnit durationUnit = TimeUnit.SECONDS;
        boolean showSamples = false;
        MetricFilter filter = MetricFilter.ALL;
        this.mapper = new ObjectMapper().registerModule((Module)new MetricsModule(rateUnit, durationUnit, false, filter));
    }

    @Override
    public void start(Service spark) {
        spark.get("/", this::getRoot);
        spark.get("/kb", (req, res) -> this.getKeyspaces(res));
        spark.get("/kb/:keyspace", this::getKeyspace);
        spark.delete("/kb/:keyspace", this::deleteKeyspace);
        spark.get("/metrics", this::getMetrics);
        spark.get("/status", (req, res) -> this.getStatus());
        spark.get("/version", (req, res) -> this.getVersion());
    }

    @GET
    @Path(value="/")
    private String getRoot(Request request, Response response) throws JsonProcessingException {
        if (Requests.getAcceptType(request).equals("application/json")) {
            return this.getJsonRoot(response);
        }
        return this.getIndexPage();
    }

    private String getJsonRoot(Response response) throws JsonProcessingException {
        response.type("application/json");
        Root root = Root.create();
        return objectMapper.writeValueAsString((Object)root);
    }

    private String getIndexPage() {
        try {
            return new String(Files.readAllBytes(this.dashboardHtml()), Charsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private java.nio.file.Path dashboardHtml() {
        return this.config.getPath(GraknConfigKey.STATIC_FILES_PATH).resolve("dashboard.html");
    }

    @GET
    @Path(value="/version")
    private String getVersion() {
        return "1.4.0";
    }

    @GET
    @Path(value="/kb")
    private String getKeyspaces(Response response) throws JsonProcessingException {
        response.type("application/json");
        Set<ai.grakn.engine.controller.response.Keyspace> keyspaces = this.keyspaceStore.keyspaces().stream().map(ai.grakn.engine.controller.response.Keyspace::of).collect(Collectors.toSet());
        return objectMapper.writeValueAsString((Object)Keyspaces.of(keyspaces));
    }

    @GET
    @Path(value="/kb/{keyspace}")
    private String getKeyspace(Request request, Response response) throws JsonProcessingException {
        response.type("application/json");
        Keyspace keyspace = Keyspace.of((String)Requests.mandatoryPathParameter(request, "keyspace"));
        if (this.keyspaceStore.containsKeyspace(keyspace)) {
            response.status(200);
            return objectMapper.writeValueAsString((Object)ai.grakn.engine.controller.response.Keyspace.of(keyspace));
        }
        response.status(404);
        return "";
    }

    @DELETE
    @Path(value="/kb/{keyspace}")
    private boolean deleteKeyspace(Request request, Response response) {
        Keyspace keyspace = Keyspace.of((String)Requests.mandatoryPathParameter(request, "keyspace"));
        boolean deletionComplete = this.keyspaceStore.deleteKeyspace(keyspace);
        if (deletionComplete) {
            this.LOG.info("Keyspace {} deleted", (Object)keyspace);
            response.status(204);
            return true;
        }
        throw GraknServerException.couldNotDelete((Keyspace)keyspace);
    }

    @GET
    @Path(value="/status")
    private String getStatus() {
        return this.serverStatus.isReady() ? "READY" : "INITIALIZING";
    }

    @GET
    @Path(value="/metrics")
    private String getMetrics(Request request, Response response) throws IOException {
        String dFormat;
        response.header("Cache-Control", "must-revalidate,no-cache,no-store");
        response.status(200);
        Optional<String> format = Optional.ofNullable(request.queryParams("format"));
        switch (dFormat = format.orElse(JSON)) {
            case "prometheus": {
                response.type(PROMETHEUS_CONTENT_TYPE);
                StringWriter writer1 = new StringWriter();
                TextFormat.write004((Writer)writer1, (Enumeration)this.prometheusRegistry.metricFamilySamples());
                return ((Object)writer1).toString();
            }
            case "json": {
                response.type("application/json");
                ObjectWriter writer = this.mapper.writer();
                try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
                    writer.writeValue((OutputStream)output, (Object)this.metricRegistry);
                    String string = new String(output.toByteArray(), "UTF-8");
                    return string;
                }
            }
        }
        throw GraknServerException.requestInvalidParameter((String)"format", (String)dFormat);
    }
}

