/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.controller.response;

import ai.grakn.concept.SchemaConcept;
import ai.grakn.concept.Thing;
import ai.grakn.concept.Type;
import ai.grakn.engine.Jacksonisable;
import ai.grakn.engine.controller.response.AutoValue_Link;
import ai.grakn.kb.internal.concept.SchemaConceptImpl;
import ai.grakn.util.REST;
import ai.grakn.util.Schema;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.collect.ImmutableMap;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

public abstract class Link
implements Jacksonisable {
    @JsonValue
    public abstract String id();

    @JsonCreator
    public static Link create(String id) {
        return new AutoValue_Link(id);
    }

    public static Link create(Link link, Map<String, Object> params) {
        String id = link.id() + "?" + params.entrySet().stream().map(Link::paramString).collect(Collectors.joining("&"));
        return new AutoValue_Link(id);
    }

    private static String paramString(Map.Entry<String, Object> e) {
        return e.getKey() + "=" + e.getValue();
    }

    public static Link create(Thing thing) {
        String id = REST.resolveTemplate((String)"/kb/:keyspace/:base-type/:id", (String[])new String[]{thing.keyspace().getValue(), Schema.BaseType.CONCEPT.name().toLowerCase(Locale.getDefault()), thing.id().getValue()});
        return Link.create(id);
    }

    public static Link create(SchemaConcept schemaConcept) {
        String type = schemaConcept.isType() ? Schema.BaseType.TYPE.name().toLowerCase(Locale.getDefault()) : SchemaConceptImpl.from((SchemaConcept)schemaConcept).baseType().name().toLowerCase(Locale.getDefault());
        String id = REST.resolveTemplate((String)"/kb/:keyspace/:base-type/:id", (String[])new String[]{schemaConcept.keyspace().getValue(), type, schemaConcept.label().getValue()});
        return Link.create(id);
    }

    public static Link createAttributesLink(Thing thing) {
        return Link.create(REST.resolveTemplate((String)"/kb/:keyspace/concept/:id/attributes", (String[])new String[]{thing.keyspace().getValue(), thing.id().getValue()}));
    }

    public static Link createKeysLink(Thing thing) {
        return Link.create(REST.resolveTemplate((String)"/kb/:keyspace/concept/:id/keys", (String[])new String[]{thing.keyspace().getValue(), thing.id().getValue()}));
    }

    public static Link createRelationshipsLink(Thing thing) {
        return Link.create(REST.resolveTemplate((String)"/kb/:keyspace/concept/:id/relationships", (String[])new String[]{thing.keyspace().getValue(), thing.id().getValue()}));
    }

    public static Link createInstanceLink(Type type) {
        String id = REST.resolveTemplate((String)"/kb/:keyspace/type/:label/instances", (String[])new String[]{type.keyspace().getValue(), type.label().getValue()});
        return Link.create(id);
    }

    public static Link createInstanceLink(Type type, int offset, int limit) {
        ImmutableMap params = ImmutableMap.of((Object)"offset", (Object)offset, (Object)"limit", (Object)limit);
        return Link.create(Link.createInstanceLink(type), (Map<String, Object>)params);
    }

    public static Link createSubsLink(SchemaConcept schemaConcept) {
        String keyspace = schemaConcept.keyspace().getValue();
        String label = schemaConcept.label().getValue();
        if (schemaConcept.isType()) {
            return Link.create(REST.resolveTemplate((String)"/kb/:keyspace/type/:label/subs", (String[])new String[]{keyspace, label}));
        }
        if (schemaConcept.isRole()) {
            return Link.create(REST.resolveTemplate((String)"/kb/:keyspace/role/:label/subs", (String[])new String[]{keyspace, label}));
        }
        return Link.create(REST.resolveTemplate((String)"/kb/:keyspace/rule/:label/subs", (String[])new String[]{keyspace, label}));
    }

    public static Link createPlaysLink(Type type) {
        return Link.create(REST.resolveTemplate((String)"/kb/:keyspace/type/:label/plays", (String[])new String[]{type.keyspace().getValue(), type.label().getValue()}));
    }

    public static Link createAttributesLink(Type type) {
        return Link.create(REST.resolveTemplate((String)"/kb/:keyspace/type/:label/attributes", (String[])new String[]{type.keyspace().getValue(), type.label().getValue()}));
    }

    public static Link createKeysLink(Type type) {
        return Link.create(REST.resolveTemplate((String)"/kb/:keyspace/type/:label/keys", (String[])new String[]{type.keyspace().getValue(), type.label().getValue()}));
    }

    public static Link createInstancesLink(Type type) {
        return Link.create(REST.resolveTemplate((String)"/kb/:keyspace/type/:label/instances", (String[])new String[]{type.keyspace().getValue(), type.label().getValue()}));
    }
}

