/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.controller.response;

import ai.grakn.engine.controller.response.AutoValue_ListResource;
import ai.grakn.engine.controller.response.Link;
import ai.grakn.util.CommonUtil;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializable;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@JsonDeserialize(using=Deserializer.class)
public abstract class ListResource<T>
extends JsonSerializable.Base {
    public abstract Link selfLink();

    public abstract String key();

    public abstract List<T> items();

    public static <T> ListResource<T> create(Link selfLink, String key, List<T> items) {
        return new AutoValue_ListResource(selfLink, key, ImmutableList.copyOf(items));
    }

    public void serialize(JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        gen.writeObjectField("@id", (Object)this.selfLink());
        gen.writeObjectField(this.key(), this.items());
        gen.writeEndObject();
    }

    public void serializeWithType(JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        this.serialize(gen, serializers);
    }

    static class Deserializer<T>
    extends JsonDeserializer<ListResource<T>> {
        private static final ImmutableSet<String> RECOGNISED_KEYS = ImmutableSet.of((Object)"@id");

        Deserializer() {
        }

        public ListResource<T> deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)parser.getCodec().readTree(parser);
            Optional<Map.Entry> field = CommonUtil.stream((Iterator)node.fields()).filter(f -> !RECOGNISED_KEYS.contains(f.getKey())).filter(f -> ((JsonNode)f.getValue()).isArray()).sorted().findFirst();
            if (!field.isPresent()) {
                throw InvalidFormatException.from((JsonParser)parser, ListResource.class, (String)"Expected a field containing a list");
            }
            String key = (String)field.get().getKey();
            JsonNode value = (JsonNode)field.get().getValue();
            List items = (List)value.traverse().readValueAs(new TypeReference<List<T>>(){});
            Link selfLink = (Link)node.get("@id").traverse().readValueAs(Link.class);
            return ListResource.create(selfLink, key, items);
        }
    }
}

