/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.controller.util;

import ai.grakn.engine.controller.response.Link;
import ai.grakn.exception.GraknServerException;
import java.util.Arrays;
import java.util.function.Function;
import mjson.Json;
import spark.Request;

public class Requests {
    public static String mandatoryQueryParameter(Request request, String parameter) {
        return Requests.mandatoryQueryParameter((String p) -> Requests.queryParameter(request, p), parameter);
    }

    public static String mandatoryQueryParameter(Function<String, String> extractParameterFunction, String parameter) {
        String result = extractParameterFunction.apply(parameter);
        if (result == null) {
            throw GraknServerException.requestMissingParameters((String)parameter);
        }
        return result;
    }

    public static String queryParameter(Request request, String parameter) {
        return request.queryParams(parameter);
    }

    public static String mandatoryBody(Request request) {
        if (request.body() == null || request.body().isEmpty()) {
            throw GraknServerException.requestMissingBody();
        }
        return request.body();
    }

    public static Link selfLink(Request request) {
        return Link.create(request.pathInfo());
    }

    public static String mandatoryPathParameter(Request request, String parameter) {
        String parameterValue = request.params(parameter);
        if (parameterValue == null) {
            throw GraknServerException.requestMissingParameters((String)parameter);
        }
        return parameterValue;
    }

    public static Json extractJsonField(Json json, String ... fieldPath) {
        Json currentField = json;
        for (String field : fieldPath) {
            Json tmp = currentField.at(field);
            if (tmp == null) {
                throw GraknServerException.requestMissingBodyParameters((String)field);
            }
            currentField = tmp;
        }
        return currentField;
    }

    public static void validateRequest(Request request, String ... contentTypes) {
        String acceptType = Requests.getAcceptType(request);
        if (!Arrays.asList(contentTypes).contains(acceptType)) {
            throw GraknServerException.unsupportedContentType((String)acceptType);
        }
    }

    public static String getAcceptType(Request request) {
        String header = request.headers("Accept");
        return header == null ? "" : request.headers("Accept").split(",")[0];
    }
}

