/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.data;

import ai.grakn.engine.data.QueueSanityCheck;
import ai.grakn.engine.data.RedisWrapper;
import ai.grakn.util.ErrorMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;

public class RedisSanityCheck
implements QueueSanityCheck {
    private static final Logger LOG = LoggerFactory.getLogger(RedisSanityCheck.class);
    private static final String REDIS_VERSION_KEY = "info:version";
    private RedisWrapper redisWrapper;

    public RedisSanityCheck(RedisWrapper redisWrapper) {
        this.redisWrapper = redisWrapper;
    }

    @Override
    public void testConnection() {
        this.redisWrapper.testConnection();
    }

    @Override
    public void checkVersion() {
        Jedis jedis = (Jedis)this.redisWrapper.getJedisPool().getResource();
        String storedVersion = jedis.get(REDIS_VERSION_KEY);
        if (storedVersion == null) {
            jedis.set(REDIS_VERSION_KEY, "1.4.0");
        } else if (!storedVersion.equals("1.4.0")) {
            LOG.warn(ErrorMessage.VERSION_MISMATCH.getMessage(new Object[]{"1.4.0", storedVersion}));
        }
    }

    @Override
    public void close() {
        this.redisWrapper.close();
    }
}

