/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.factory;

import ai.grakn.GraknTxType;
import ai.grakn.Keyspace;
import ai.grakn.engine.GraknConfig;
import ai.grakn.engine.KeyspaceStore;
import ai.grakn.engine.lock.LockProvider;
import ai.grakn.factory.EmbeddedGraknSession;
import ai.grakn.factory.GraknTxFactoryBuilder;
import ai.grakn.factory.TxFactoryBuilder;
import ai.grakn.kb.internal.EmbeddedGraknTx;
import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;

public class EngineGraknTxFactory {
    private final GraknConfig engineConfig;
    private final KeyspaceStore keyspaceStore;
    private final Map<Keyspace, EmbeddedGraknSession> openedSessions = new HashMap<Keyspace, EmbeddedGraknSession>();
    private final LockProvider lockProvider;

    public static EngineGraknTxFactory create(LockProvider lockProvider, GraknConfig engineConfig, KeyspaceStore keyspaceStore) {
        return new EngineGraknTxFactory(engineConfig, lockProvider, keyspaceStore);
    }

    private EngineGraknTxFactory(GraknConfig engineConfig, LockProvider lockProvider, KeyspaceStore keyspaceStore) {
        this.engineConfig = engineConfig;
        this.lockProvider = lockProvider;
        this.keyspaceStore = keyspaceStore;
    }

    @VisibleForTesting
    public synchronized void refreshConnections() {
        GraknTxFactoryBuilder.refresh();
    }

    public EmbeddedGraknTx<?> tx(Keyspace keyspace, GraknTxType type) {
        if (!this.keyspaceStore.containsKeyspace(keyspace)) {
            this.initialiseNewKeyspace(keyspace);
        }
        return this.session(keyspace).transaction(type);
    }

    private EmbeddedGraknSession session(Keyspace keyspace) {
        if (!this.openedSessions.containsKey(keyspace)) {
            this.openedSessions.put(keyspace, EmbeddedGraknSession.createEngineSession((Keyspace)keyspace, (GraknConfig)this.engineConfig, (TxFactoryBuilder)GraknTxFactoryBuilder.getInstance()));
        }
        return this.openedSessions.get(keyspace);
    }

    private void initialiseNewKeyspace(Keyspace keyspace) {
        Lock lock = this.lockProvider.getLock(EngineGraknTxFactory.getLockingKey(keyspace));
        lock.lock();
        try {
            this.session(keyspace).transaction(GraknTxType.WRITE).close();
            this.keyspaceStore.addKeyspace(keyspace);
        }
        finally {
            lock.unlock();
        }
    }

    private static String getLockingKey(Keyspace keyspace) {
        return "/creating-new-keyspace-lock/" + keyspace.getValue();
    }

    public GraknConfig config() {
        return this.engineConfig;
    }

    public KeyspaceStore keyspaceStore() {
        return this.keyspaceStore;
    }
}

