/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.printer;

import ai.grakn.concept.Concept;
import ai.grakn.engine.controller.response.Answer;
import ai.grakn.engine.controller.response.ConceptBuilder;
import ai.grakn.graql.answer.AnswerGroup;
import ai.grakn.graql.answer.ConceptMap;
import ai.grakn.graql.answer.ConceptSetMeasure;
import ai.grakn.graql.internal.printer.Printer;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class JacksonPrinter
extends Printer<Object> {
    private static ObjectMapper mapper = new ObjectMapper();

    public static JacksonPrinter create() {
        return new JacksonPrinter();
    }

    protected String complete(Object object) {
        try {
            return mapper.writeValueAsString(object);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Error during serialising {%s}", object), e);
        }
    }

    protected Object concept(Concept concept) {
        return ConceptBuilder.build(concept);
    }

    protected Object answerGroup(AnswerGroup<?> answer) {
        return new AbstractMap.SimpleEntry<Concept, Object>(answer.owner(), this.build(answer.answers()));
    }

    protected Object conceptMap(ConceptMap answer) {
        return Answer.create(answer);
    }

    protected Object conceptSetMeasure(ConceptSetMeasure answer) {
        return new AbstractMap.SimpleEntry<Number, Set>(answer.measurement(), answer.set());
    }

    protected Object bool(boolean bool) {
        return bool;
    }

    protected Object object(Object object) {
        return object;
    }

    protected Object map(Map map) {
        Stream entries = map.entrySet().stream();
        return entries.collect(Collectors.toMap(entry -> this.build(entry.getKey()), entry -> this.build(entry.getValue())));
    }

    protected Object collection(Collection collection) {
        return collection.stream().map((? super T object) -> this.build(object)).collect(Collectors.toList());
    }
}

