/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.rpc;

import ai.grakn.concept.Attribute;
import ai.grakn.concept.AttributeType;
import ai.grakn.concept.Concept;
import ai.grakn.concept.ConceptId;
import ai.grakn.concept.Entity;
import ai.grakn.concept.Label;
import ai.grakn.concept.Relationship;
import ai.grakn.concept.Role;
import ai.grakn.concept.SchemaConcept;
import ai.grakn.concept.Thing;
import ai.grakn.concept.Type;
import ai.grakn.engine.rpc.ResponseBuilder;
import ai.grakn.engine.rpc.SessionService;
import ai.grakn.exception.GraqlQueryException;
import ai.grakn.graql.Pattern;
import ai.grakn.kb.internal.EmbeddedGraknTx;
import ai.grakn.rpc.proto.ConceptProto;
import ai.grakn.rpc.proto.SessionProto;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

public class ConceptMethod {
    public static SessionProto.Transaction.Res run(Concept concept, ConceptProto.Method.Req req, SessionService.Iterators iterators, EmbeddedGraknTx tx) {
        ConceptHolder con = new ConceptHolder(concept, tx, iterators);
        switch (req.getReqCase()) {
            case CONCEPT_DELETE_REQ: {
                return con.asConcept().delete();
            }
            case SCHEMACONCEPT_ISIMPLICIT_REQ: {
                return con.asSchemaConcept().isImplicit();
            }
            case SCHEMACONCEPT_GETLABEL_REQ: {
                return con.asSchemaConcept().label();
            }
            case SCHEMACONCEPT_SETLABEL_REQ: {
                return con.asSchemaConcept().label(req.getSchemaConceptSetLabelReq().getLabel());
            }
            case SCHEMACONCEPT_GETSUP_REQ: {
                return con.asSchemaConcept().sup();
            }
            case SCHEMACONCEPT_SETSUP_REQ: {
                return con.asSchemaConcept().sup(req.getSchemaConceptSetSupReq().getSchemaConcept());
            }
            case SCHEMACONCEPT_SUPS_REQ: {
                return con.asSchemaConcept().sups();
            }
            case SCHEMACONCEPT_SUBS_REQ: {
                return con.asSchemaConcept().subs();
            }
            case RULE_WHEN_REQ: {
                return con.asRule().when();
            }
            case RULE_THEN_REQ: {
                return con.asRule().then();
            }
            case ROLE_RELATIONS_REQ: {
                return con.asRole().relations();
            }
            case ROLE_PLAYERS_REQ: {
                return con.asRole().players();
            }
            case TYPE_INSTANCES_REQ: {
                return con.asType().instances();
            }
            case TYPE_ISABSTRACT_REQ: {
                return con.asType().isAbstract();
            }
            case TYPE_SETABSTRACT_REQ: {
                return con.asType().isAbstract(req.getTypeSetAbstractReq().getAbstract());
            }
            case TYPE_KEYS_REQ: {
                return con.asType().keys();
            }
            case TYPE_ATTRIBUTES_REQ: {
                return con.asType().attributes();
            }
            case TYPE_PLAYING_REQ: {
                return con.asType().playing();
            }
            case TYPE_KEY_REQ: {
                return con.asType().key(req.getTypeKeyReq().getAttributeType());
            }
            case TYPE_HAS_REQ: {
                return con.asType().has(req.getTypeHasReq().getAttributeType());
            }
            case TYPE_PLAYS_REQ: {
                return con.asType().plays(req.getTypePlaysReq().getRole());
            }
            case TYPE_UNKEY_REQ: {
                return con.asType().unkey(req.getTypeUnkeyReq().getAttributeType());
            }
            case TYPE_UNHAS_REQ: {
                return con.asType().unhas(req.getTypeUnhasReq().getAttributeType());
            }
            case TYPE_UNPLAY_REQ: {
                return con.asType().unplay(req.getTypeUnplayReq().getRole());
            }
            case ENTITYTYPE_CREATE_REQ: {
                return con.asEntityType().create();
            }
            case RELATIONTYPE_CREATE_REQ: {
                return con.asRelationshipType().create();
            }
            case RELATIONTYPE_ROLES_REQ: {
                return con.asRelationshipType().roles();
            }
            case RELATIONTYPE_RELATES_REQ: {
                return con.asRelationshipType().relates(req.getRelationTypeRelatesReq().getRole());
            }
            case RELATIONTYPE_UNRELATE_REQ: {
                return con.asRelationshipType().unrelate(req.getRelationTypeUnrelateReq().getRole());
            }
            case ATTRIBUTETYPE_CREATE_REQ: {
                return con.asAttributeType().create(req.getAttributeTypeCreateReq().getValue());
            }
            case ATTRIBUTETYPE_ATTRIBUTE_REQ: {
                return con.asAttributeType().attribute(req.getAttributeTypeAttributeReq().getValue());
            }
            case ATTRIBUTETYPE_DATATYPE_REQ: {
                return con.asAttributeType().dataType();
            }
            case ATTRIBUTETYPE_GETREGEX_REQ: {
                return con.asAttributeType().regex();
            }
            case ATTRIBUTETYPE_SETREGEX_REQ: {
                return con.asAttributeType().regex(req.getAttributeTypeSetRegexReq().getRegex());
            }
            case THING_ISINFERRED_REQ: {
                return con.asThing().isInferred();
            }
            case THING_TYPE_REQ: {
                return con.asThing().type();
            }
            case THING_KEYS_REQ: {
                return con.asThing().keys(req.getThingKeysReq().getAttributeTypesList());
            }
            case THING_ATTRIBUTES_REQ: {
                return con.asThing().attributes(req.getThingAttributesReq().getAttributeTypesList());
            }
            case THING_RELATIONS_REQ: {
                return con.asThing().relations(req.getThingRelationsReq().getRolesList());
            }
            case THING_ROLES_REQ: {
                return con.asThing().roles();
            }
            case THING_RELHAS_REQ: {
                return con.asThing().relhas(req.getThingRelhasReq().getAttribute());
            }
            case THING_UNHAS_REQ: {
                return con.asThing().unhas(req.getThingUnhasReq().getAttribute());
            }
            case RELATION_ROLEPLAYERSMAP_REQ: {
                return con.asRelationship().rolePlayersMap();
            }
            case RELATION_ROLEPLAYERS_REQ: {
                return con.asRelationship().rolePlayers(req.getRelationRolePlayersReq().getRolesList());
            }
            case RELATION_ASSIGN_REQ: {
                return con.asRelationship().assign(req.getRelationAssignReq());
            }
            case RELATION_UNASSIGN_REQ: {
                return con.asRelationship().unassign(req.getRelationUnassignReq());
            }
            case ATTRIBUTE_VALUE_REQ: {
                return con.asAttribute().value();
            }
            case ATTRIBUTE_OWNERS_REQ: {
                return con.asAttribute().owners();
            }
        }
        throw new IllegalArgumentException("Unrecognised " + req);
    }

    public static class ConceptHolder {
        private ai.grakn.concept.Concept concept;
        private EmbeddedGraknTx tx;
        private SessionService.Iterators iterators;

        ConceptHolder(ai.grakn.concept.Concept concept, EmbeddedGraknTx tx, SessionService.Iterators iterators) {
            this.concept = concept;
            this.tx = tx;
            this.iterators = iterators;
        }

        private ai.grakn.concept.Concept convert(ConceptProto.Concept protoConcept) {
            return this.tx.getConcept(ConceptId.of((String)protoConcept.getId()));
        }

        Concept asConcept() {
            return new Concept();
        }

        SchemaConcept asSchemaConcept() {
            return new SchemaConcept();
        }

        Rule asRule() {
            return new Rule();
        }

        Role asRole() {
            return new Role();
        }

        Type asType() {
            return new Type();
        }

        EntityType asEntityType() {
            return new EntityType();
        }

        RelationshipType asRelationshipType() {
            return new RelationshipType();
        }

        AttributeType asAttributeType() {
            return new AttributeType();
        }

        Thing asThing() {
            return new Thing();
        }

        Relationship asRelationship() {
            return new Relationship();
        }

        Attribute asAttribute() {
            return new Attribute();
        }

        private static SessionProto.Transaction.Res transactionRes(ConceptProto.Method.Res response) {
            return SessionProto.Transaction.Res.newBuilder().setConceptMethodRes(SessionProto.Transaction.ConceptMethod.Res.newBuilder().setResponse(response)).build();
        }

        private class Attribute {
            private Attribute() {
            }

            private SessionProto.Transaction.Res value() {
                Object value = ConceptHolder.this.concept.asAttribute().value();
                ConceptProto.Method.Res response = ConceptProto.Method.Res.newBuilder().setAttributeValueRes(ConceptProto.Attribute.Value.Res.newBuilder().setValue(ResponseBuilder.Concept.attributeValue(value))).build();
                return ConceptHolder.transactionRes(response);
            }

            private SessionProto.Transaction.Res owners() {
                Stream concepts = ConceptHolder.this.concept.asAttribute().owners();
                Stream<SessionProto.Transaction.Res> responses = concepts.map(con -> {
                    ConceptProto.Method.Iter.Res res = ConceptProto.Method.Iter.Res.newBuilder().setAttributeOwnersIterRes(ConceptProto.Attribute.Owners.Iter.Res.newBuilder().setThing(ResponseBuilder.Concept.concept((ai.grakn.concept.Concept)con))).build();
                    return ResponseBuilder.Transaction.Iter.conceptMethod(res);
                });
                int iteratorId = ConceptHolder.this.iterators.add(responses.iterator());
                ConceptProto.Method.Res response = ConceptProto.Method.Res.newBuilder().setAttributeOwnersIter(ConceptProto.Attribute.Owners.Iter.newBuilder().setId(iteratorId)).build();
                return ConceptHolder.transactionRes(response);
            }
        }

        private class Relationship {
            private Relationship() {
            }

            private SessionProto.Transaction.Res rolePlayersMap() {
                Map rolePlayersMap = ConceptHolder.this.concept.asRelationship().rolePlayersMap();
                Stream.Builder<SessionProto.Transaction.Res> responses = Stream.builder();
                for (Map.Entry rolePlayers : rolePlayersMap.entrySet()) {
                    for (ai.grakn.concept.Thing player : (Set)rolePlayers.getValue()) {
                        ConceptProto.Method.Iter.Res res = ConceptProto.Method.Iter.Res.newBuilder().setRelationRolePlayersMapIterRes(ConceptProto.Relation.RolePlayersMap.Iter.Res.newBuilder().setRole(ResponseBuilder.Concept.concept((ai.grakn.concept.Concept)rolePlayers.getKey())).setPlayer(ResponseBuilder.Concept.concept((ai.grakn.concept.Concept)player))).build();
                        responses.add(ResponseBuilder.Transaction.Iter.conceptMethod(res));
                    }
                }
                int iteratorId = ConceptHolder.this.iterators.add(responses.build().iterator());
                ConceptProto.Method.Res response = ConceptProto.Method.Res.newBuilder().setRelationRolePlayersMapIter(ConceptProto.Relation.RolePlayersMap.Iter.newBuilder().setId(iteratorId)).build();
                return ConceptHolder.transactionRes(response);
            }

            private SessionProto.Transaction.Res rolePlayers(List<ConceptProto.Concept> protoRoles) {
                ai.grakn.concept.Role[] roles = (ai.grakn.concept.Role[])protoRoles.stream().map(rpcConcept -> ConceptHolder.this.convert(rpcConcept)).toArray(ai.grakn.concept.Role[]::new);
                Stream concepts = ConceptHolder.this.concept.asRelationship().rolePlayers(roles);
                Stream<SessionProto.Transaction.Res> responses = concepts.map(con -> {
                    ConceptProto.Method.Iter.Res res = ConceptProto.Method.Iter.Res.newBuilder().setRelationRolePlayersIterRes(ConceptProto.Relation.RolePlayers.Iter.Res.newBuilder().setThing(ResponseBuilder.Concept.concept((ai.grakn.concept.Concept)con))).build();
                    return ResponseBuilder.Transaction.Iter.conceptMethod(res);
                });
                int iteratorId = ConceptHolder.this.iterators.add(responses.iterator());
                ConceptProto.Method.Res response = ConceptProto.Method.Res.newBuilder().setRelationRolePlayersIter(ConceptProto.Relation.RolePlayers.Iter.newBuilder().setId(iteratorId)).build();
                return ConceptHolder.transactionRes(response);
            }

            private SessionProto.Transaction.Res assign(ConceptProto.Relation.Assign.Req request) {
                ai.grakn.concept.Role role = ConceptHolder.this.convert(request.getRole()).asRole();
                ai.grakn.concept.Thing player = ConceptHolder.this.convert(request.getPlayer()).asThing();
                ConceptHolder.this.concept.asRelationship().assign(role, player);
                return null;
            }

            private SessionProto.Transaction.Res unassign(ConceptProto.Relation.Unassign.Req request) {
                ai.grakn.concept.Role role = ConceptHolder.this.convert(request.getRole()).asRole();
                ai.grakn.concept.Thing player = ConceptHolder.this.convert(request.getPlayer()).asThing();
                ConceptHolder.this.concept.asRelationship().unassign(role, player);
                return null;
            }
        }

        private class Thing {
            private Thing() {
            }

            private SessionProto.Transaction.Res isInferred() {
                Boolean inferred = ConceptHolder.this.concept.asThing().isInferred();
                ConceptProto.Method.Res response = ConceptProto.Method.Res.newBuilder().setThingIsInferredRes(ConceptProto.Thing.IsInferred.Res.newBuilder().setInferred(inferred)).build();
                return ConceptHolder.transactionRes(response);
            }

            private SessionProto.Transaction.Res type() {
                ai.grakn.concept.Type type = ConceptHolder.this.concept.asThing().type();
                ConceptProto.Method.Res response = ConceptProto.Method.Res.newBuilder().setThingTypeRes(ConceptProto.Thing.Type.Res.newBuilder().setType(ResponseBuilder.Concept.concept((ai.grakn.concept.Concept)type))).build();
                return ConceptHolder.transactionRes(response);
            }

            private SessionProto.Transaction.Res keys(List<ConceptProto.Concept> protoTypes) {
                ai.grakn.concept.AttributeType[] keyTypes = (ai.grakn.concept.AttributeType[])protoTypes.stream().map(rpcConcept -> ConceptHolder.this.convert(rpcConcept)).toArray(ai.grakn.concept.AttributeType[]::new);
                Stream concepts = ConceptHolder.this.concept.asThing().keys(keyTypes);
                Stream<SessionProto.Transaction.Res> responses = concepts.map(con -> {
                    ConceptProto.Method.Iter.Res res = ConceptProto.Method.Iter.Res.newBuilder().setThingKeysIterRes(ConceptProto.Thing.Keys.Iter.Res.newBuilder().setAttribute(ResponseBuilder.Concept.concept((ai.grakn.concept.Concept)con))).build();
                    return ResponseBuilder.Transaction.Iter.conceptMethod(res);
                });
                int iteratorId = ConceptHolder.this.iterators.add(responses.iterator());
                ConceptProto.Method.Res response = ConceptProto.Method.Res.newBuilder().setThingKeysIter(ConceptProto.Thing.Keys.Iter.newBuilder().setId(iteratorId)).build();
                return ConceptHolder.transactionRes(response);
            }

            private SessionProto.Transaction.Res attributes(List<ConceptProto.Concept> protoTypes) {
                ai.grakn.concept.AttributeType[] attributeTypes = (ai.grakn.concept.AttributeType[])protoTypes.stream().map(rpcConcept -> ConceptHolder.this.convert(rpcConcept)).toArray(ai.grakn.concept.AttributeType[]::new);
                Stream concepts = ConceptHolder.this.concept.asThing().attributes(attributeTypes);
                Stream<SessionProto.Transaction.Res> responses = concepts.map(con -> {
                    ConceptProto.Method.Iter.Res res = ConceptProto.Method.Iter.Res.newBuilder().setThingAttributesIterRes(ConceptProto.Thing.Attributes.Iter.Res.newBuilder().setAttribute(ResponseBuilder.Concept.concept((ai.grakn.concept.Concept)con))).build();
                    return ResponseBuilder.Transaction.Iter.conceptMethod(res);
                });
                int iteratorId = ConceptHolder.this.iterators.add(responses.iterator());
                ConceptProto.Method.Res response = ConceptProto.Method.Res.newBuilder().setThingAttributesIter(ConceptProto.Thing.Attributes.Iter.newBuilder().setId(iteratorId)).build();
                return ConceptHolder.transactionRes(response);
            }

            private SessionProto.Transaction.Res relations(List<ConceptProto.Concept> protoRoles) {
                ai.grakn.concept.Role[] roles = (ai.grakn.concept.Role[])protoRoles.stream().map(rpcConcept -> ConceptHolder.this.convert(rpcConcept)).toArray(ai.grakn.concept.Role[]::new);
                Stream concepts = ConceptHolder.this.concept.asThing().relationships(roles);
                Stream<SessionProto.Transaction.Res> responses = concepts.map(con -> {
                    ConceptProto.Method.Iter.Res res = ConceptProto.Method.Iter.Res.newBuilder().setThingRelationsIterRes(ConceptProto.Thing.Relations.Iter.Res.newBuilder().setRelation(ResponseBuilder.Concept.concept((ai.grakn.concept.Concept)con))).build();
                    return ResponseBuilder.Transaction.Iter.conceptMethod(res);
                });
                int iteratorId = ConceptHolder.this.iterators.add(responses.iterator());
                ConceptProto.Method.Res response = ConceptProto.Method.Res.newBuilder().setThingRelationsIter(ConceptProto.Thing.Relations.Iter.newBuilder().setId(iteratorId)).build();
                return ConceptHolder.transactionRes(response);
            }

            private SessionProto.Transaction.Res roles() {
                Stream concepts = ConceptHolder.this.concept.asThing().roles();
                Stream<SessionProto.Transaction.Res> responses = concepts.map(con -> {
                    ConceptProto.Method.Iter.Res res = ConceptProto.Method.Iter.Res.newBuilder().setThingRolesIterRes(ConceptProto.Thing.Roles.Iter.Res.newBuilder().setRole(ResponseBuilder.Concept.concept((ai.grakn.concept.Concept)con))).build();
                    return ResponseBuilder.Transaction.Iter.conceptMethod(res);
                });
                int iteratorId = ConceptHolder.this.iterators.add(responses.iterator());
                ConceptProto.Method.Res response = ConceptProto.Method.Res.newBuilder().setThingRolesIter(ConceptProto.Thing.Roles.Iter.newBuilder().setId(iteratorId)).build();
                return ConceptHolder.transactionRes(response);
            }

            private SessionProto.Transaction.Res relhas(ConceptProto.Concept protoAttribute) {
                ai.grakn.concept.Attribute attribute = ConceptHolder.this.convert(protoAttribute).asAttribute();
                ai.grakn.concept.Relationship relationship = ConceptHolder.this.concept.asThing().relhas(attribute);
                ConceptProto.Method.Res response = ConceptProto.Method.Res.newBuilder().setThingRelhasRes(ConceptProto.Thing.Relhas.Res.newBuilder().setRelation(ResponseBuilder.Concept.concept((ai.grakn.concept.Concept)relationship))).build();
                return ConceptHolder.transactionRes(response);
            }

            private SessionProto.Transaction.Res unhas(ConceptProto.Concept protoAttribute) {
                ai.grakn.concept.Attribute attribute = ConceptHolder.this.convert(protoAttribute).asAttribute();
                ConceptHolder.this.concept.asThing().unhas(attribute);
                return null;
            }
        }

        private class AttributeType {
            private AttributeType() {
            }

            private SessionProto.Transaction.Res create(ConceptProto.ValueObject protoValue) {
                Object value = protoValue.getAllFields().values().iterator().next();
                ai.grakn.concept.Attribute attribute = ConceptHolder.this.concept.asAttributeType().create(value);
                ConceptProto.Method.Res response = ConceptProto.Method.Res.newBuilder().setAttributeTypeCreateRes(ConceptProto.AttributeType.Create.Res.newBuilder().setAttribute(ResponseBuilder.Concept.concept((ai.grakn.concept.Concept)attribute))).build();
                return ConceptHolder.transactionRes(response);
            }

            private SessionProto.Transaction.Res attribute(ConceptProto.ValueObject protoValue) {
                Object value = protoValue.getAllFields().values().iterator().next();
                ai.grakn.concept.Attribute attribute = ConceptHolder.this.concept.asAttributeType().attribute(value);
                ConceptProto.AttributeType.Attribute.Res.Builder methodResponse = ConceptProto.AttributeType.Attribute.Res.newBuilder();
                if (attribute == null) {
                    methodResponse.setNull(ConceptProto.Null.getDefaultInstance()).build();
                } else {
                    methodResponse.setAttribute(ResponseBuilder.Concept.concept((ai.grakn.concept.Concept)attribute)).build();
                }
                ConceptProto.Method.Res response = ConceptProto.Method.Res.newBuilder().setAttributeTypeAttributeRes(methodResponse).build();
                return ConceptHolder.transactionRes(response);
            }

            private SessionProto.Transaction.Res dataType() {
                AttributeType.DataType dataType = ConceptHolder.this.concept.asAttributeType().dataType();
                ConceptProto.AttributeType.DataType.Res.Builder methodResponse = ConceptProto.AttributeType.DataType.Res.newBuilder();
                if (dataType == null) {
                    methodResponse.setNull(ConceptProto.Null.getDefaultInstance()).build();
                } else {
                    methodResponse.setDataType(ResponseBuilder.Concept.DATA_TYPE(dataType)).build();
                }
                ConceptProto.Method.Res response = ConceptProto.Method.Res.newBuilder().setAttributeTypeDataTypeRes(methodResponse).build();
                return ConceptHolder.transactionRes(response);
            }

            private SessionProto.Transaction.Res regex() {
                String regex = ConceptHolder.this.concept.asAttributeType().regex();
                ConceptProto.Method.Res response = ConceptProto.Method.Res.newBuilder().setAttributeTypeGetRegexRes(ConceptProto.AttributeType.GetRegex.Res.newBuilder().setRegex(regex != null ? regex : "")).build();
                return ConceptHolder.transactionRes(response);
            }

            private SessionProto.Transaction.Res regex(String regex) {
                if (regex.isEmpty()) {
                    ConceptHolder.this.concept.asAttributeType().regex(null);
                } else {
                    ConceptHolder.this.concept.asAttributeType().regex(regex);
                }
                return null;
            }
        }

        private class RelationshipType {
            private RelationshipType() {
            }

            private SessionProto.Transaction.Res create() {
                ai.grakn.concept.Relationship relationship = ConceptHolder.this.concept.asRelationshipType().create();
                ConceptProto.Method.Res response = ConceptProto.Method.Res.newBuilder().setRelationTypeCreateRes(ConceptProto.RelationType.Create.Res.newBuilder().setRelation(ResponseBuilder.Concept.concept((ai.grakn.concept.Concept)relationship))).build();
                return ConceptHolder.transactionRes(response);
            }

            private SessionProto.Transaction.Res roles() {
                Stream roles = ConceptHolder.this.concept.asRelationshipType().roles();
                Stream<SessionProto.Transaction.Res> responses = roles.map(con -> {
                    ConceptProto.Method.Iter.Res res = ConceptProto.Method.Iter.Res.newBuilder().setRelationTypeRolesIterRes(ConceptProto.RelationType.Roles.Iter.Res.newBuilder().setRole(ResponseBuilder.Concept.concept((ai.grakn.concept.Concept)con))).build();
                    return ResponseBuilder.Transaction.Iter.conceptMethod(res);
                });
                int iteratorId = ConceptHolder.this.iterators.add(responses.iterator());
                ConceptProto.Method.Res response = ConceptProto.Method.Res.newBuilder().setRelationTypeRolesIter(ConceptProto.RelationType.Roles.Iter.newBuilder().setId(iteratorId)).build();
                return ConceptHolder.transactionRes(response);
            }

            private SessionProto.Transaction.Res relates(ConceptProto.Concept protoRole) {
                ai.grakn.concept.Role role = ConceptHolder.this.convert(protoRole).asRole();
                ConceptHolder.this.concept.asRelationshipType().relates(role);
                return null;
            }

            private SessionProto.Transaction.Res unrelate(ConceptProto.Concept protoRole) {
                ai.grakn.concept.Role role = ConceptHolder.this.convert(protoRole).asRole();
                ConceptHolder.this.concept.asRelationshipType().unrelate(role);
                return null;
            }
        }

        private class EntityType {
            private EntityType() {
            }

            private SessionProto.Transaction.Res create() {
                Entity entity = ConceptHolder.this.concept.asEntityType().create();
                ConceptProto.Method.Res response = ConceptProto.Method.Res.newBuilder().setEntityTypeCreateRes(ConceptProto.EntityType.Create.Res.newBuilder().setEntity(ResponseBuilder.Concept.concept((ai.grakn.concept.Concept)entity))).build();
                return ConceptHolder.transactionRes(response);
            }
        }

        private class Type {
            private Type() {
            }

            private SessionProto.Transaction.Res instances() {
                Stream concepts = ConceptHolder.this.concept.asType().instances();
                Stream<SessionProto.Transaction.Res> responses = concepts.map(con -> {
                    ConceptProto.Method.Iter.Res res = ConceptProto.Method.Iter.Res.newBuilder().setTypeInstancesIterRes(ConceptProto.Type.Instances.Iter.Res.newBuilder().setThing(ResponseBuilder.Concept.concept((ai.grakn.concept.Concept)con))).build();
                    return ResponseBuilder.Transaction.Iter.conceptMethod(res);
                });
                int iteratorId = ConceptHolder.this.iterators.add(responses.iterator());
                ConceptProto.Method.Res response = ConceptProto.Method.Res.newBuilder().setTypeInstancesIter(ConceptProto.Type.Instances.Iter.newBuilder().setId(iteratorId)).build();
                return ConceptHolder.transactionRes(response);
            }

            private SessionProto.Transaction.Res isAbstract() {
                Boolean isAbstract = ConceptHolder.this.concept.asType().isAbstract();
                ConceptProto.Method.Res response = ConceptProto.Method.Res.newBuilder().setTypeIsAbstractRes(ConceptProto.Type.IsAbstract.Res.newBuilder().setAbstract(isAbstract)).build();
                return ConceptHolder.transactionRes(response);
            }

            private SessionProto.Transaction.Res isAbstract(boolean isAbstract) {
                ConceptHolder.this.concept.asType().isAbstract(Boolean.valueOf(isAbstract));
                return null;
            }

            private SessionProto.Transaction.Res keys() {
                Stream concepts = ConceptHolder.this.concept.asType().keys();
                Stream<SessionProto.Transaction.Res> responses = concepts.map(con -> {
                    ConceptProto.Method.Iter.Res res = ConceptProto.Method.Iter.Res.newBuilder().setTypeKeysIterRes(ConceptProto.Type.Keys.Iter.Res.newBuilder().setAttributeType(ResponseBuilder.Concept.concept((ai.grakn.concept.Concept)con))).build();
                    return ResponseBuilder.Transaction.Iter.conceptMethod(res);
                });
                int iteratorId = ConceptHolder.this.iterators.add(responses.iterator());
                ConceptProto.Method.Res response = ConceptProto.Method.Res.newBuilder().setTypeKeysIter(ConceptProto.Type.Keys.Iter.newBuilder().setId(iteratorId)).build();
                return ConceptHolder.transactionRes(response);
            }

            private SessionProto.Transaction.Res attributes() {
                Stream concepts = ConceptHolder.this.concept.asType().attributes();
                Stream<SessionProto.Transaction.Res> responses = concepts.map(con -> {
                    ConceptProto.Method.Iter.Res res = ConceptProto.Method.Iter.Res.newBuilder().setTypeAttributesIterRes(ConceptProto.Type.Attributes.Iter.Res.newBuilder().setAttributeType(ResponseBuilder.Concept.concept((ai.grakn.concept.Concept)con))).build();
                    return ResponseBuilder.Transaction.Iter.conceptMethod(res);
                });
                int iteratorId = ConceptHolder.this.iterators.add(responses.iterator());
                ConceptProto.Method.Res response = ConceptProto.Method.Res.newBuilder().setTypeAttributesIter(ConceptProto.Type.Attributes.Iter.newBuilder().setId(iteratorId)).build();
                return ConceptHolder.transactionRes(response);
            }

            private SessionProto.Transaction.Res playing() {
                Stream concepts = ConceptHolder.this.concept.asType().playing();
                Stream<SessionProto.Transaction.Res> responses = concepts.map(con -> {
                    ConceptProto.Method.Iter.Res res = ConceptProto.Method.Iter.Res.newBuilder().setTypePlayingIterRes(ConceptProto.Type.Playing.Iter.Res.newBuilder().setRole(ResponseBuilder.Concept.concept((ai.grakn.concept.Concept)con))).build();
                    return ResponseBuilder.Transaction.Iter.conceptMethod(res);
                });
                int iteratorId = ConceptHolder.this.iterators.add(responses.iterator());
                ConceptProto.Method.Res response = ConceptProto.Method.Res.newBuilder().setTypePlayingIter(ConceptProto.Type.Playing.Iter.newBuilder().setId(iteratorId)).build();
                return ConceptHolder.transactionRes(response);
            }

            private SessionProto.Transaction.Res key(ConceptProto.Concept protoKey) {
                ai.grakn.concept.AttributeType attributeType = ConceptHolder.this.convert(protoKey).asAttributeType();
                ConceptHolder.this.concept.asType().key(attributeType);
                return null;
            }

            private SessionProto.Transaction.Res has(ConceptProto.Concept protoAttribute) {
                ai.grakn.concept.AttributeType attributeType = ConceptHolder.this.convert(protoAttribute).asAttributeType();
                ConceptHolder.this.concept.asType().has(attributeType);
                return null;
            }

            private SessionProto.Transaction.Res plays(ConceptProto.Concept protoRole) {
                ai.grakn.concept.Role role = ConceptHolder.this.convert(protoRole).asRole();
                ConceptHolder.this.concept.asType().plays(role);
                return null;
            }

            private SessionProto.Transaction.Res unkey(ConceptProto.Concept protoKey) {
                ai.grakn.concept.AttributeType attributeType = ConceptHolder.this.convert(protoKey).asAttributeType();
                ConceptHolder.this.concept.asType().unkey(attributeType);
                return null;
            }

            private SessionProto.Transaction.Res unhas(ConceptProto.Concept protoAttribute) {
                ai.grakn.concept.AttributeType attributeType = ConceptHolder.this.convert(protoAttribute).asAttributeType();
                ConceptHolder.this.concept.asType().unhas(attributeType);
                return null;
            }

            private SessionProto.Transaction.Res unplay(ConceptProto.Concept protoRole) {
                ai.grakn.concept.Role role = ConceptHolder.this.convert(protoRole).asRole();
                ConceptHolder.this.concept.asType().unplay(role);
                return null;
            }
        }

        private class Role {
            private Role() {
            }

            private SessionProto.Transaction.Res relations() {
                Stream concepts = ConceptHolder.this.concept.asRole().relationships();
                Stream<SessionProto.Transaction.Res> responses = concepts.map(con -> {
                    ConceptProto.Method.Iter.Res res = ConceptProto.Method.Iter.Res.newBuilder().setRoleRelationsIterRes(ConceptProto.Role.Relations.Iter.Res.newBuilder().setRelationType(ResponseBuilder.Concept.concept((ai.grakn.concept.Concept)con))).build();
                    return ResponseBuilder.Transaction.Iter.conceptMethod(res);
                });
                int iteratorId = ConceptHolder.this.iterators.add(responses.iterator());
                ConceptProto.Method.Res response = ConceptProto.Method.Res.newBuilder().setRoleRelationsIter(ConceptProto.Role.Relations.Iter.newBuilder().setId(iteratorId)).build();
                return ConceptHolder.transactionRes(response);
            }

            private SessionProto.Transaction.Res players() {
                Stream concepts = ConceptHolder.this.concept.asRole().players();
                Stream<SessionProto.Transaction.Res> responses = concepts.map(con -> {
                    ConceptProto.Method.Iter.Res res = ConceptProto.Method.Iter.Res.newBuilder().setRolePlayersIterRes(ConceptProto.Role.Players.Iter.Res.newBuilder().setType(ResponseBuilder.Concept.concept((ai.grakn.concept.Concept)con))).build();
                    return ResponseBuilder.Transaction.Iter.conceptMethod(res);
                });
                int iteratorId = ConceptHolder.this.iterators.add(responses.iterator());
                ConceptProto.Method.Res response = ConceptProto.Method.Res.newBuilder().setRolePlayersIter(ConceptProto.Role.Players.Iter.newBuilder().setId(iteratorId)).build();
                return ConceptHolder.transactionRes(response);
            }
        }

        private class Rule {
            private Rule() {
            }

            private SessionProto.Transaction.Res when() {
                Pattern pattern = ConceptHolder.this.concept.asRule().when();
                ConceptProto.Rule.When.Res.Builder whenRes = ConceptProto.Rule.When.Res.newBuilder();
                if (pattern == null) {
                    whenRes.setNull(ConceptProto.Null.getDefaultInstance());
                } else {
                    whenRes.setPattern(pattern.toString());
                }
                ConceptProto.Method.Res response = ConceptProto.Method.Res.newBuilder().setRuleWhenRes(whenRes).build();
                return ConceptHolder.transactionRes(response);
            }

            private SessionProto.Transaction.Res then() {
                Pattern pattern = ConceptHolder.this.concept.asRule().then();
                ConceptProto.Rule.Then.Res.Builder thenRes = ConceptProto.Rule.Then.Res.newBuilder();
                if (pattern == null) {
                    thenRes.setNull(ConceptProto.Null.getDefaultInstance());
                } else {
                    thenRes.setPattern(pattern.toString());
                }
                ConceptProto.Method.Res response = ConceptProto.Method.Res.newBuilder().setRuleThenRes(thenRes).build();
                return ConceptHolder.transactionRes(response);
            }
        }

        private class SchemaConcept {
            private SchemaConcept() {
            }

            private SessionProto.Transaction.Res isImplicit() {
                Boolean implicit = ConceptHolder.this.concept.asSchemaConcept().isImplicit();
                ConceptProto.Method.Res response = ConceptProto.Method.Res.newBuilder().setSchemaConceptIsImplicitRes(ConceptProto.SchemaConcept.IsImplicit.Res.newBuilder().setImplicit(implicit)).build();
                return ConceptHolder.transactionRes(response);
            }

            private SessionProto.Transaction.Res label() {
                Label label = ConceptHolder.this.concept.asSchemaConcept().label();
                ConceptProto.Method.Res response = ConceptProto.Method.Res.newBuilder().setSchemaConceptGetLabelRes(ConceptProto.SchemaConcept.GetLabel.Res.newBuilder().setLabel(label.getValue())).build();
                return ConceptHolder.transactionRes(response);
            }

            private SessionProto.Transaction.Res label(String label) {
                ConceptHolder.this.concept.asSchemaConcept().label(Label.of((String)label));
                return null;
            }

            private SessionProto.Transaction.Res sup() {
                ai.grakn.concept.SchemaConcept superConcept = ConceptHolder.this.concept.asSchemaConcept().sup();
                ConceptProto.SchemaConcept.GetSup.Res.Builder responseConcept = ConceptProto.SchemaConcept.GetSup.Res.newBuilder();
                if (superConcept == null) {
                    responseConcept.setNull(ConceptProto.Null.getDefaultInstance());
                } else {
                    responseConcept.setSchemaConcept(ResponseBuilder.Concept.concept((ai.grakn.concept.Concept)superConcept));
                }
                ConceptProto.Method.Res response = ConceptProto.Method.Res.newBuilder().setSchemaConceptGetSupRes(responseConcept).build();
                return ConceptHolder.transactionRes(response);
            }

            private SessionProto.Transaction.Res sup(ConceptProto.Concept superConcept) {
                ai.grakn.concept.SchemaConcept sup = ConceptHolder.this.convert(superConcept).asSchemaConcept();
                ai.grakn.concept.SchemaConcept sub = ConceptHolder.this.concept.asSchemaConcept();
                if (sup.isEntityType()) {
                    sub.asEntityType().sup(sup.asEntityType());
                } else if (sup.isRelationshipType()) {
                    sub.asRelationshipType().sup(sup.asRelationshipType());
                } else if (sup.isRole()) {
                    sub.asRole().sup(sup.asRole());
                } else if (sup.isAttributeType()) {
                    sub.asAttributeType().sup(sup.asAttributeType());
                } else if (sup.isRule()) {
                    sub.asRule().sup(sup.asRule());
                } else {
                    throw GraqlQueryException.insertMetaType((Label)sub.label(), (ai.grakn.concept.SchemaConcept)sup);
                }
                return null;
            }

            private SessionProto.Transaction.Res sups() {
                Stream concepts = ConceptHolder.this.concept.asSchemaConcept().sups();
                Stream<SessionProto.Transaction.Res> responses = concepts.map(con -> {
                    ConceptProto.Method.Iter.Res res = ConceptProto.Method.Iter.Res.newBuilder().setSchemaConceptSupsIterRes(ConceptProto.SchemaConcept.Sups.Iter.Res.newBuilder().setSchemaConcept(ResponseBuilder.Concept.concept((ai.grakn.concept.Concept)con))).build();
                    return ResponseBuilder.Transaction.Iter.conceptMethod(res);
                });
                int iteratorId = ConceptHolder.this.iterators.add(responses.iterator());
                ConceptProto.Method.Res response = ConceptProto.Method.Res.newBuilder().setSchemaConceptSupsIter(ConceptProto.SchemaConcept.Sups.Iter.newBuilder().setId(iteratorId)).build();
                return ConceptHolder.transactionRes(response);
            }

            private SessionProto.Transaction.Res subs() {
                Stream concepts = ConceptHolder.this.concept.asSchemaConcept().subs();
                Stream<SessionProto.Transaction.Res> responses = concepts.map(con -> {
                    ConceptProto.Method.Iter.Res res = ConceptProto.Method.Iter.Res.newBuilder().setSchemaConceptSubsIterRes(ConceptProto.SchemaConcept.Subs.Iter.Res.newBuilder().setSchemaConcept(ResponseBuilder.Concept.concept((ai.grakn.concept.Concept)con))).build();
                    return ResponseBuilder.Transaction.Iter.conceptMethod(res);
                });
                int iteratorId = ConceptHolder.this.iterators.add(responses.iterator());
                ConceptProto.Method.Res response = ConceptProto.Method.Res.newBuilder().setSchemaConceptSubsIter(ConceptProto.SchemaConcept.Subs.Iter.newBuilder().setId(iteratorId)).build();
                return ConceptHolder.transactionRes(response);
            }
        }

        private class Concept {
            private Concept() {
            }

            private SessionProto.Transaction.Res delete() {
                ConceptHolder.this.concept.delete();
                return null;
            }
        }
    }
}

