/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.rpc;

import ai.grakn.GraknTxType;
import ai.grakn.Keyspace;
import ai.grakn.engine.KeyspaceStore;
import ai.grakn.engine.rpc.ResponseBuilder;
import ai.grakn.engine.rpc.ServerOpenRequest;
import ai.grakn.rpc.proto.KeyspaceProto;
import ai.grakn.rpc.proto.KeyspaceServiceGrpc;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.util.stream.Collectors;

public class KeyspaceService
extends KeyspaceServiceGrpc.KeyspaceServiceImplBase {
    private final KeyspaceStore keyspaceStore;

    public KeyspaceService(KeyspaceStore keyspaceStore) {
        this.keyspaceStore = keyspaceStore;
    }

    @Override
    public void create(KeyspaceProto.Keyspace.Create.Req request, StreamObserver<KeyspaceProto.Keyspace.Create.Res> response) {
        response.onError((Throwable)new StatusRuntimeException(Status.UNIMPLEMENTED));
    }

    @Override
    public void retrieve(KeyspaceProto.Keyspace.Retrieve.Req request, StreamObserver<KeyspaceProto.Keyspace.Retrieve.Res> response) {
        try {
            Iterable list = this.keyspaceStore.keyspaces().stream().map(Keyspace::getValue).collect(Collectors.toSet());
            response.onNext((Object)KeyspaceProto.Keyspace.Retrieve.Res.newBuilder().addAllNames(list).build());
            response.onCompleted();
        }
        catch (RuntimeException e) {
            response.onError((Throwable)ResponseBuilder.exception(e));
        }
    }

    @Override
    public void delete(KeyspaceProto.Keyspace.Delete.Req request, StreamObserver<KeyspaceProto.Keyspace.Delete.Res> response) {
        try {
            ServerOpenRequest.Arguments args = new ServerOpenRequest.Arguments(Keyspace.of((String)request.getName()), GraknTxType.WRITE);
            this.keyspaceStore.deleteKeyspace(args.getKeyspace());
            response.onNext((Object)KeyspaceProto.Keyspace.Delete.Res.getDefaultInstance());
            response.onCompleted();
        }
        catch (RuntimeException e) {
            response.onError((Throwable)ResponseBuilder.exception(e));
        }
    }
}

