/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.rpc;

import ai.grakn.concept.AttributeType;
import ai.grakn.concept.ConceptId;
import ai.grakn.exception.GraknBackendException;
import ai.grakn.exception.GraknException;
import ai.grakn.exception.GraknTxOperationException;
import ai.grakn.exception.GraqlQueryException;
import ai.grakn.exception.GraqlSyntaxException;
import ai.grakn.exception.InvalidKBException;
import ai.grakn.exception.PropertyNotUniqueException;
import ai.grakn.exception.TemporaryWriteException;
import ai.grakn.graql.admin.Explanation;
import ai.grakn.graql.answer.AnswerGroup;
import ai.grakn.graql.answer.ConceptList;
import ai.grakn.graql.answer.ConceptMap;
import ai.grakn.graql.answer.ConceptSet;
import ai.grakn.graql.answer.ConceptSetMeasure;
import ai.grakn.graql.answer.Value;
import ai.grakn.rpc.proto.AnswerProto;
import ai.grakn.rpc.proto.ConceptProto;
import ai.grakn.rpc.proto.SessionProto;
import ai.grakn.util.CommonUtil;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class ResponseBuilder {
    public static StatusRuntimeException exception(Throwable e) {
        if (e instanceof GraknException) {
            GraknException ge = (GraknException)e;
            String message = ge.getName() + "-" + ge.getMessage();
            if (e instanceof TemporaryWriteException) {
                return ResponseBuilder.exception(Status.RESOURCE_EXHAUSTED, message);
            }
            if (e instanceof GraknBackendException) {
                return ResponseBuilder.exception(Status.INTERNAL, message);
            }
            if (e instanceof PropertyNotUniqueException) {
                return ResponseBuilder.exception(Status.ALREADY_EXISTS, message);
            }
            if (e instanceof GraknTxOperationException | e instanceof GraqlQueryException | e instanceof GraqlSyntaxException | e instanceof InvalidKBException) {
                return ResponseBuilder.exception(Status.INVALID_ARGUMENT, message);
            }
        } else if (e instanceof StatusRuntimeException) {
            return (StatusRuntimeException)e;
        }
        return ResponseBuilder.exception(Status.UNKNOWN, e.getMessage());
    }

    private static StatusRuntimeException exception(Status status, String message) {
        return ResponseBuilder.exception(status.withDescription(message + ". Please check server logs for the stack trace."));
    }

    public static StatusRuntimeException exception(Status status) {
        return new StatusRuntimeException(status);
    }

    public static class Answer {
        public static AnswerProto.Answer answer(Object object) {
            AnswerProto.Answer.Builder answer = AnswerProto.Answer.newBuilder();
            if (object instanceof AnswerGroup) {
                answer.setAnswerGroup(Answer.answerGroup((AnswerGroup)object));
            } else if (object instanceof ConceptMap) {
                answer.setConceptMap(Answer.conceptMap((ConceptMap)object));
            } else if (object instanceof ConceptList) {
                answer.setConceptList(Answer.conceptList((ConceptList)object));
            } else if (object instanceof ConceptSetMeasure) {
                answer.setConceptSetMeasure(Answer.conceptSetMeasure((ConceptSetMeasure)object));
            } else if (object instanceof ConceptSet) {
                answer.setConceptSet(Answer.conceptSet((ConceptSet)object));
            } else if (object instanceof Value) {
                answer.setValue(Answer.value((Value)object));
            }
            return answer.build();
        }

        static AnswerProto.Explanation explanation(Explanation explanation) {
            AnswerProto.Explanation.Builder builder = AnswerProto.Explanation.newBuilder().addAllAnswers(explanation.getAnswers().stream().map(Answer::conceptMap).collect(Collectors.toList()));
            if (explanation.getQuery() != null) {
                builder.setPattern(explanation.getQuery().getPattern().toString());
            }
            return builder.build();
        }

        static AnswerProto.AnswerGroup answerGroup(AnswerGroup<?> answer) {
            AnswerProto.AnswerGroup.Builder answerGroupProto = AnswerProto.AnswerGroup.newBuilder().setOwner(Concept.concept(answer.owner())).addAllAnswers(answer.answers().stream().map(Answer::answer).collect(Collectors.toList()));
            if (answer.explanation() != null && !answer.explanation().isEmpty()) {
                answerGroupProto.setExplanation(Answer.explanation(answer.explanation()));
            }
            return answerGroupProto.build();
        }

        static AnswerProto.ConceptMap conceptMap(ConceptMap answer) {
            AnswerProto.ConceptMap.Builder conceptMapProto = AnswerProto.ConceptMap.newBuilder();
            answer.map().forEach((var, concept) -> {
                ConceptProto.Concept conceptProto = Concept.concept(concept);
                conceptMapProto.putMap(var.getValue(), conceptProto);
            });
            if (answer.explanation() != null && !answer.explanation().isEmpty()) {
                conceptMapProto.setExplanation(Answer.explanation(answer.explanation()));
            }
            return conceptMapProto.build();
        }

        static AnswerProto.ConceptList conceptList(ConceptList answer) {
            AnswerProto.ConceptList.Builder conceptListProto = AnswerProto.ConceptList.newBuilder();
            conceptListProto.setList(Answer.conceptIds(answer.list()));
            if (answer.explanation() != null && !answer.explanation().isEmpty()) {
                conceptListProto.setExplanation(Answer.explanation(answer.explanation()));
            }
            return conceptListProto.build();
        }

        static AnswerProto.ConceptSet conceptSet(ConceptSet answer) {
            AnswerProto.ConceptSet.Builder conceptSetProto = AnswerProto.ConceptSet.newBuilder();
            conceptSetProto.setSet(Answer.conceptIds(answer.set()));
            if (answer.explanation() != null && !answer.explanation().isEmpty()) {
                conceptSetProto.setExplanation(Answer.explanation(answer.explanation()));
            }
            return conceptSetProto.build();
        }

        static AnswerProto.ConceptSetMeasure conceptSetMeasure(ConceptSetMeasure answer) {
            AnswerProto.ConceptSetMeasure.Builder conceptSetMeasureProto = AnswerProto.ConceptSetMeasure.newBuilder();
            conceptSetMeasureProto.setSet(Answer.conceptIds(answer.set()));
            conceptSetMeasureProto.setMeasurement(Answer.number(answer.measurement()));
            if (answer.explanation() != null && !answer.explanation().isEmpty()) {
                conceptSetMeasureProto.setExplanation(Answer.explanation(answer.explanation()));
            }
            return conceptSetMeasureProto.build();
        }

        static AnswerProto.Value value(Value answer) {
            AnswerProto.Value.Builder valueProto = AnswerProto.Value.newBuilder();
            valueProto.setNumber(Answer.number(answer.number()));
            if (answer.explanation() != null && !answer.explanation().isEmpty()) {
                valueProto.setExplanation(Answer.explanation(answer.explanation()));
            }
            return valueProto.build();
        }

        static AnswerProto.Number number(Number number) {
            return AnswerProto.Number.newBuilder().setValue(number.toString()).build();
        }

        private static AnswerProto.ConceptIds conceptIds(Collection<ConceptId> conceptIds) {
            AnswerProto.ConceptIds.Builder conceptIdsRPC = AnswerProto.ConceptIds.newBuilder();
            conceptIdsRPC.addAllIds(conceptIds.stream().map(id -> id.getValue()).collect(Collectors.toList()));
            return conceptIdsRPC.build();
        }
    }

    public static class Concept {
        public static ConceptProto.Concept concept(ai.grakn.concept.Concept concept) {
            return ConceptProto.Concept.newBuilder().setId(concept.id().getValue()).setBaseType(Concept.getBaseType(concept)).build();
        }

        private static ConceptProto.Concept.BASE_TYPE getBaseType(ai.grakn.concept.Concept concept) {
            if (concept.isEntityType()) {
                return ConceptProto.Concept.BASE_TYPE.ENTITY_TYPE;
            }
            if (concept.isRelationshipType()) {
                return ConceptProto.Concept.BASE_TYPE.RELATION_TYPE;
            }
            if (concept.isAttributeType()) {
                return ConceptProto.Concept.BASE_TYPE.ATTRIBUTE_TYPE;
            }
            if (concept.isEntity()) {
                return ConceptProto.Concept.BASE_TYPE.ENTITY;
            }
            if (concept.isRelationship()) {
                return ConceptProto.Concept.BASE_TYPE.RELATION;
            }
            if (concept.isAttribute()) {
                return ConceptProto.Concept.BASE_TYPE.ATTRIBUTE;
            }
            if (concept.isRole()) {
                return ConceptProto.Concept.BASE_TYPE.ROLE;
            }
            if (concept.isRule()) {
                return ConceptProto.Concept.BASE_TYPE.RULE;
            }
            if (concept.isType()) {
                return ConceptProto.Concept.BASE_TYPE.META_TYPE;
            }
            throw CommonUtil.unreachableStatement((String)("Unrecognised concept " + concept));
        }

        static ConceptProto.AttributeType.DATA_TYPE DATA_TYPE(AttributeType.DataType<?> dataType) {
            if (dataType.equals((Object)AttributeType.DataType.STRING)) {
                return ConceptProto.AttributeType.DATA_TYPE.STRING;
            }
            if (dataType.equals((Object)AttributeType.DataType.BOOLEAN)) {
                return ConceptProto.AttributeType.DATA_TYPE.BOOLEAN;
            }
            if (dataType.equals((Object)AttributeType.DataType.INTEGER)) {
                return ConceptProto.AttributeType.DATA_TYPE.INTEGER;
            }
            if (dataType.equals((Object)AttributeType.DataType.LONG)) {
                return ConceptProto.AttributeType.DATA_TYPE.LONG;
            }
            if (dataType.equals((Object)AttributeType.DataType.FLOAT)) {
                return ConceptProto.AttributeType.DATA_TYPE.FLOAT;
            }
            if (dataType.equals((Object)AttributeType.DataType.DOUBLE)) {
                return ConceptProto.AttributeType.DATA_TYPE.DOUBLE;
            }
            if (dataType.equals((Object)AttributeType.DataType.DATE)) {
                return ConceptProto.AttributeType.DATA_TYPE.DATE;
            }
            throw CommonUtil.unreachableStatement((String)("Unrecognised " + dataType));
        }

        public static AttributeType.DataType<?> DATA_TYPE(ConceptProto.AttributeType.DATA_TYPE dataType) {
            switch (dataType) {
                case STRING: {
                    return AttributeType.DataType.STRING;
                }
                case BOOLEAN: {
                    return AttributeType.DataType.BOOLEAN;
                }
                case INTEGER: {
                    return AttributeType.DataType.INTEGER;
                }
                case LONG: {
                    return AttributeType.DataType.LONG;
                }
                case FLOAT: {
                    return AttributeType.DataType.FLOAT;
                }
                case DOUBLE: {
                    return AttributeType.DataType.DOUBLE;
                }
                case DATE: {
                    return AttributeType.DataType.DATE;
                }
            }
            throw new IllegalArgumentException("Unrecognised " + (Object)((Object)dataType));
        }

        static ConceptProto.ValueObject attributeValue(Object value) {
            ConceptProto.ValueObject.Builder builder = ConceptProto.ValueObject.newBuilder();
            if (value instanceof String) {
                builder.setString((String)value);
            } else if (value instanceof Boolean) {
                builder.setBoolean((Boolean)value);
            } else if (value instanceof Integer) {
                builder.setInteger((Integer)value);
            } else if (value instanceof Long) {
                builder.setLong((Long)value);
            } else if (value instanceof Float) {
                builder.setFloat(((Float)value).floatValue());
            } else if (value instanceof Double) {
                builder.setDouble((Double)value);
            } else if (value instanceof LocalDateTime) {
                builder.setDate(((LocalDateTime)value).atZone(ZoneId.of("Z")).toInstant().toEpochMilli());
            } else {
                throw CommonUtil.unreachableStatement((String)("Unrecognised " + value));
            }
            return builder.build();
        }
    }

    public static class Transaction {
        static SessionProto.Transaction.Res open() {
            return SessionProto.Transaction.Res.newBuilder().setOpenRes(SessionProto.Transaction.Open.Res.getDefaultInstance()).build();
        }

        static SessionProto.Transaction.Res commit() {
            return SessionProto.Transaction.Res.newBuilder().setCommitRes(SessionProto.Transaction.Commit.Res.getDefaultInstance()).build();
        }

        static SessionProto.Transaction.Res queryIterator(int iteratorId) {
            return SessionProto.Transaction.Res.newBuilder().setQueryIter(SessionProto.Transaction.Query.Iter.newBuilder().setId(iteratorId)).build();
        }

        static SessionProto.Transaction.Res getSchemaConcept(@Nullable ai.grakn.concept.Concept concept) {
            SessionProto.Transaction.GetSchemaConcept.Res.Builder res = SessionProto.Transaction.GetSchemaConcept.Res.newBuilder();
            if (concept == null) {
                res.setNull(ConceptProto.Null.getDefaultInstance());
            } else {
                res.setSchemaConcept(Concept.concept(concept));
            }
            return SessionProto.Transaction.Res.newBuilder().setGetSchemaConceptRes(res).build();
        }

        static SessionProto.Transaction.Res getConcept(@Nullable ai.grakn.concept.Concept concept) {
            SessionProto.Transaction.GetConcept.Res.Builder res = SessionProto.Transaction.GetConcept.Res.newBuilder();
            if (concept == null) {
                res.setNull(ConceptProto.Null.getDefaultInstance());
            } else {
                res.setConcept(Concept.concept(concept));
            }
            return SessionProto.Transaction.Res.newBuilder().setGetConceptRes(res).build();
        }

        static SessionProto.Transaction.Res getAttributesIterator(int iteratorId) {
            SessionProto.Transaction.GetAttributes.Iter.Builder res = SessionProto.Transaction.GetAttributes.Iter.newBuilder().setId(iteratorId);
            return SessionProto.Transaction.Res.newBuilder().setGetAttributesIter(res).build();
        }

        static SessionProto.Transaction.Res putEntityType(ai.grakn.concept.Concept concept) {
            SessionProto.Transaction.PutEntityType.Res.Builder res = SessionProto.Transaction.PutEntityType.Res.newBuilder().setEntityType(Concept.concept(concept));
            return SessionProto.Transaction.Res.newBuilder().setPutEntityTypeRes(res).build();
        }

        static SessionProto.Transaction.Res putAttributeType(ai.grakn.concept.Concept concept) {
            SessionProto.Transaction.PutAttributeType.Res.Builder res = SessionProto.Transaction.PutAttributeType.Res.newBuilder().setAttributeType(Concept.concept(concept));
            return SessionProto.Transaction.Res.newBuilder().setPutAttributeTypeRes(res).build();
        }

        static SessionProto.Transaction.Res putRelationshipType(ai.grakn.concept.Concept concept) {
            SessionProto.Transaction.PutRelationType.Res.Builder res = SessionProto.Transaction.PutRelationType.Res.newBuilder().setRelationType(Concept.concept(concept));
            return SessionProto.Transaction.Res.newBuilder().setPutRelationTypeRes(res).build();
        }

        static SessionProto.Transaction.Res putRole(ai.grakn.concept.Concept concept) {
            SessionProto.Transaction.PutRole.Res.Builder res = SessionProto.Transaction.PutRole.Res.newBuilder().setRole(Concept.concept(concept));
            return SessionProto.Transaction.Res.newBuilder().setPutRoleRes(res).build();
        }

        static SessionProto.Transaction.Res putRule(ai.grakn.concept.Concept concept) {
            SessionProto.Transaction.PutRule.Res.Builder res = SessionProto.Transaction.PutRule.Res.newBuilder().setRule(Concept.concept(concept));
            return SessionProto.Transaction.Res.newBuilder().setPutRuleRes(res).build();
        }

        static class Iter {
            Iter() {
            }

            static SessionProto.Transaction.Res query(Object object) {
                return SessionProto.Transaction.Res.newBuilder().setIterateRes(SessionProto.Transaction.Iter.Res.newBuilder().setQueryIterRes(SessionProto.Transaction.Query.Iter.Res.newBuilder().setAnswer(Answer.answer(object)))).build();
            }

            static SessionProto.Transaction.Res getAttributes(ai.grakn.concept.Concept concept) {
                return SessionProto.Transaction.Res.newBuilder().setIterateRes(SessionProto.Transaction.Iter.Res.newBuilder().setGetAttributesIterRes(SessionProto.Transaction.GetAttributes.Iter.Res.newBuilder().setAttribute(Concept.concept(concept)))).build();
            }

            static SessionProto.Transaction.Res conceptMethod(ConceptProto.Method.Iter.Res methodResponse) {
                return SessionProto.Transaction.Res.newBuilder().setIterateRes(SessionProto.Transaction.Iter.Res.newBuilder().setConceptMethodIterRes(methodResponse)).build();
            }
        }
    }
}

