/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.rpc;

import ai.grakn.GraknTxType;
import ai.grakn.Keyspace;
import ai.grakn.concept.AttributeType;
import ai.grakn.concept.Concept;
import ai.grakn.concept.ConceptId;
import ai.grakn.concept.EntityType;
import ai.grakn.concept.Label;
import ai.grakn.concept.RelationshipType;
import ai.grakn.concept.Role;
import ai.grakn.concept.Rule;
import ai.grakn.concept.SchemaConcept;
import ai.grakn.engine.rpc.ConceptMethod;
import ai.grakn.engine.rpc.OpenRequest;
import ai.grakn.engine.rpc.ResponseBuilder;
import ai.grakn.engine.rpc.ServerOpenRequest;
import ai.grakn.engine.task.postprocessing.PostProcessor;
import ai.grakn.graql.Graql;
import ai.grakn.graql.Pattern;
import ai.grakn.graql.Query;
import ai.grakn.kb.internal.EmbeddedGraknTx;
import ai.grakn.rpc.proto.SessionProto;
import ai.grakn.rpc.proto.SessionServiceGrpc;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionService
extends SessionServiceGrpc.SessionServiceImplBase {
    private final OpenRequest requestOpener;
    private PostProcessor postProcessor;

    public SessionService(OpenRequest requestOpener, PostProcessor postProcessor) {
        this.requestOpener = requestOpener;
        this.postProcessor = postProcessor;
    }

    @Override
    public StreamObserver<SessionProto.Transaction.Req> transaction(StreamObserver<SessionProto.Transaction.Res> responseSender) {
        return TransactionListener.create(responseSender, this.requestOpener, this.postProcessor);
    }

    public static class Iterators {
        private final AtomicInteger iteratorIdCounter = new AtomicInteger(1);
        private final Map<Integer, Iterator<SessionProto.Transaction.Res>> iterators = new ConcurrentHashMap<Integer, Iterator<SessionProto.Transaction.Res>>();

        public static Iterators create() {
            return new Iterators();
        }

        public int add(Iterator<SessionProto.Transaction.Res> iterator) {
            int iteratorId = this.iteratorIdCounter.getAndIncrement();
            this.iterators.put(iteratorId, iterator);
            return iteratorId;
        }

        public SessionProto.Transaction.Res next(int iteratorId) {
            SessionProto.Transaction.Res response;
            Iterator<SessionProto.Transaction.Res> iterator = this.iterators.get(iteratorId);
            if (iterator == null) {
                return null;
            }
            if (iterator.hasNext()) {
                response = iterator.next();
            } else {
                response = SessionProto.Transaction.Res.newBuilder().setIterateRes(SessionProto.Transaction.Iter.Res.newBuilder().setDone(true)).build();
                this.stop(iteratorId);
            }
            return response;
        }

        public void stop(int iteratorId) {
            this.iterators.remove(iteratorId);
        }
    }

    static class TransactionListener
    implements StreamObserver<SessionProto.Transaction.Req> {
        final Logger LOG = LoggerFactory.getLogger(TransactionListener.class);
        private final StreamObserver<SessionProto.Transaction.Res> responseSender;
        private final AtomicBoolean terminated = new AtomicBoolean(false);
        private final ExecutorService threadExecutor;
        private final OpenRequest requestOpener;
        private final PostProcessor postProcessor;
        private final Iterators iterators = Iterators.create();
        @Nullable
        private EmbeddedGraknTx<?> tx = null;

        private TransactionListener(StreamObserver<SessionProto.Transaction.Res> responseSender, ExecutorService threadExecutor, OpenRequest requestOpener, PostProcessor postProcessor) {
            this.responseSender = responseSender;
            this.threadExecutor = threadExecutor;
            this.requestOpener = requestOpener;
            this.postProcessor = postProcessor;
        }

        public static TransactionListener create(StreamObserver<SessionProto.Transaction.Res> responseSender, OpenRequest requestOpener, PostProcessor postProcessor) {
            ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("transaction-listener-%s").build();
            ExecutorService threadExecutor = Executors.newSingleThreadExecutor(threadFactory);
            return new TransactionListener(responseSender, threadExecutor, requestOpener, postProcessor);
        }

        private static <T> T nonNull(@Nullable T item) {
            if (item == null) {
                throw ResponseBuilder.exception(Status.FAILED_PRECONDITION);
            }
            return item;
        }

        public void onNext(SessionProto.Transaction.Req request) {
            try {
                this.submit(() -> this.handleRequest(request));
            }
            catch (RuntimeException e) {
                this.close(e);
            }
        }

        public void onError(Throwable t) {
            this.close(t);
        }

        public void onCompleted() {
            this.close(null);
        }

        private void handleRequest(SessionProto.Transaction.Req request) {
            switch (request.getReqCase()) {
                case OPEN_REQ: {
                    this.open(request.getOpenReq());
                    break;
                }
                case COMMIT_REQ: {
                    this.commit();
                    break;
                }
                case QUERY_REQ: {
                    this.query(request.getQueryReq());
                    break;
                }
                case ITERATE_REQ: {
                    this.next(request.getIterateReq());
                    break;
                }
                case GETSCHEMACONCEPT_REQ: {
                    this.getSchemaConcept(request.getGetSchemaConceptReq());
                    break;
                }
                case GETCONCEPT_REQ: {
                    this.getConcept(request.getGetConceptReq());
                    break;
                }
                case GETATTRIBUTES_REQ: {
                    this.getAttributes(request.getGetAttributesReq());
                    break;
                }
                case PUTENTITYTYPE_REQ: {
                    this.putEntityType(request.getPutEntityTypeReq());
                    break;
                }
                case PUTATTRIBUTETYPE_REQ: {
                    this.putAttributeType(request.getPutAttributeTypeReq());
                    break;
                }
                case PUTRELATIONTYPE_REQ: {
                    this.putRelationshipType(request.getPutRelationTypeReq());
                    break;
                }
                case PUTROLE_REQ: {
                    this.putRole(request.getPutRoleReq());
                    break;
                }
                case PUTRULE_REQ: {
                    this.putRule(request.getPutRuleReq());
                    break;
                }
                case CONCEPTMETHOD_REQ: {
                    this.conceptMethod(request.getConceptMethodReq());
                    break;
                }
                default: {
                    throw ResponseBuilder.exception(Status.INVALID_ARGUMENT);
                }
            }
        }

        public void close(@Nullable Throwable error) {
            this.submit(() -> {
                if (this.tx != null) {
                    this.tx.close();
                }
            });
            if (!this.terminated.getAndSet(true)) {
                if (error != null) {
                    this.LOG.error("Runtime Exception in RPC TransactionListener: ", error);
                    this.responseSender.onError((Throwable)ResponseBuilder.exception(error));
                } else {
                    this.responseSender.onCompleted();
                }
            }
            this.threadExecutor.shutdown();
        }

        private void submit(Runnable runnable) {
            try {
                this.threadExecutor.submit(runnable).get();
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                assert (cause instanceof RuntimeException) : "No checked exceptions are thrown, because it's a `Runnable`";
                throw (RuntimeException)cause;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        private void open(SessionProto.Transaction.Open.Req request) {
            if (this.tx != null) {
                throw ResponseBuilder.exception(Status.FAILED_PRECONDITION);
            }
            ServerOpenRequest.Arguments args = new ServerOpenRequest.Arguments(Keyspace.of((String)request.getKeyspace()), GraknTxType.of((int)request.getType().getNumber()));
            this.tx = this.requestOpener.open(args);
            this.responseSender.onNext((Object)ResponseBuilder.Transaction.open());
        }

        private void commit() {
            this.tx().commitAndGetLogs().ifPresent(this.postProcessor::submit);
            this.responseSender.onNext((Object)ResponseBuilder.Transaction.commit());
        }

        private void query(SessionProto.Transaction.Query.Req request) {
            Query query = this.tx().graql().infer(request.getInfer().equals((Object)SessionProto.Transaction.Query.INFER.TRUE)).parse(request.getQuery());
            Stream<SessionProto.Transaction.Res> responseStream = query.stream().map(ResponseBuilder.Transaction.Iter::query);
            SessionProto.Transaction.Res response = ResponseBuilder.Transaction.queryIterator(this.iterators.add(responseStream.iterator()));
            this.responseSender.onNext((Object)response);
        }

        private void getSchemaConcept(SessionProto.Transaction.GetSchemaConcept.Req request) {
            SchemaConcept concept = this.tx().getSchemaConcept(Label.of((String)request.getLabel()));
            this.responseSender.onNext((Object)ResponseBuilder.Transaction.getSchemaConcept((Concept)concept));
        }

        private void getConcept(SessionProto.Transaction.GetConcept.Req request) {
            Concept concept = this.tx().getConcept(ConceptId.of((String)request.getId()));
            this.responseSender.onNext((Object)ResponseBuilder.Transaction.getConcept(concept));
        }

        private void getAttributes(SessionProto.Transaction.GetAttributes.Req request) {
            Object value = request.getValue().getAllFields().values().iterator().next();
            Collection attributes = this.tx().getAttributesByValue(value);
            Iterator<SessionProto.Transaction.Res> iterator = attributes.stream().map(ResponseBuilder.Transaction.Iter::getAttributes).iterator();
            int iteratorId = this.iterators.add(iterator);
            this.responseSender.onNext((Object)ResponseBuilder.Transaction.getAttributesIterator(iteratorId));
        }

        private void putEntityType(SessionProto.Transaction.PutEntityType.Req request) {
            EntityType entityType = this.tx().putEntityType(Label.of((String)request.getLabel()));
            this.responseSender.onNext((Object)ResponseBuilder.Transaction.putEntityType((Concept)entityType));
        }

        private void putAttributeType(SessionProto.Transaction.PutAttributeType.Req request) {
            Label label = Label.of((String)request.getLabel());
            AttributeType.DataType<?> dataType = ResponseBuilder.Concept.DATA_TYPE(request.getDataType());
            AttributeType attributeType = this.tx().putAttributeType(label, dataType);
            this.responseSender.onNext((Object)ResponseBuilder.Transaction.putAttributeType((Concept)attributeType));
        }

        private void putRelationshipType(SessionProto.Transaction.PutRelationType.Req request) {
            RelationshipType relationshipType = this.tx().putRelationshipType(Label.of((String)request.getLabel()));
            this.responseSender.onNext((Object)ResponseBuilder.Transaction.putRelationshipType((Concept)relationshipType));
        }

        private void putRole(SessionProto.Transaction.PutRole.Req request) {
            Role role = this.tx().putRole(Label.of((String)request.getLabel()));
            this.responseSender.onNext((Object)ResponseBuilder.Transaction.putRole((Concept)role));
        }

        private void putRule(SessionProto.Transaction.PutRule.Req request) {
            Label label = Label.of((String)request.getLabel());
            Pattern when = Graql.parser().parsePattern(request.getWhen());
            Pattern then = Graql.parser().parsePattern(request.getThen());
            Rule rule = this.tx().putRule(label, when, then);
            this.responseSender.onNext((Object)ResponseBuilder.Transaction.putRule((Concept)rule));
        }

        private EmbeddedGraknTx<?> tx() {
            return TransactionListener.nonNull(this.tx);
        }

        private void conceptMethod(SessionProto.Transaction.ConceptMethod.Req request) {
            Concept concept = TransactionListener.nonNull(this.tx().getConcept(ConceptId.of((String)request.getId())));
            SessionProto.Transaction.Res response = ConceptMethod.run(concept, request.getMethod(), this.iterators, this.tx());
            this.responseSender.onNext((Object)response);
        }

        private void next(SessionProto.Transaction.Iter.Req iterate) {
            int iteratorId = iterate.getId();
            SessionProto.Transaction.Res response = this.iterators.next(iteratorId);
            if (response == null) {
                throw ResponseBuilder.exception(Status.FAILED_PRECONDITION);
            }
            this.responseSender.onNext((Object)response);
        }
    }
}

