/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.task;

import ai.grakn.GraknConfigKey;
import ai.grakn.engine.GraknConfig;
import ai.grakn.engine.task.BackgroundTask;
import ai.grakn.util.ErrorMessage;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackgroundTaskRunner
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(BackgroundTaskRunner.class);
    private final Set<BackgroundTask> registeredTasks = new HashSet<BackgroundTask>();
    private final ScheduledExecutorService threadPool;

    public BackgroundTaskRunner(GraknConfig graknConfig) {
        int numThread = (Integer)graknConfig.getProperty(GraknConfigKey.NUM_BACKGROUND_THREADS);
        this.threadPool = Executors.newScheduledThreadPool(numThread);
    }

    public void register(BackgroundTask backgroundTask) {
        if (!this.registeredTasks.contains(backgroundTask)) {
            LOG.info("Registering a new background task.");
            this.registeredTasks.add(backgroundTask);
            this.threadPool.scheduleAtFixedRate(() -> {
                try {
                    backgroundTask.run();
                }
                catch (Exception e) {
                    LOG.error(ErrorMessage.BACKGROUND_TASK_UNHANDLED_EXCEPTION.getMessage(new Object[]{backgroundTask}), (Throwable)e);
                }
            }, backgroundTask.period(), backgroundTask.period(), TimeUnit.SECONDS);
        }
    }

    @Override
    public void close() {
        this.registeredTasks.forEach(BackgroundTask::close);
        this.threadPool.shutdown();
    }

    @VisibleForTesting
    public Set<BackgroundTask> tasks() {
        return ImmutableSet.copyOf(this.registeredTasks);
    }
}

