/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.task.postprocessing;

import ai.grakn.GraknConfigKey;
import ai.grakn.GraknTxType;
import ai.grakn.Keyspace;
import ai.grakn.concept.ConceptId;
import ai.grakn.engine.GraknConfig;
import ai.grakn.engine.factory.EngineGraknTxFactory;
import ai.grakn.engine.lock.LockProvider;
import ai.grakn.engine.task.postprocessing.CountStorage;
import ai.grakn.kb.internal.EmbeddedGraknTx;
import ai.grakn.kb.log.CommitLog;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CountPostProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(CountPostProcessor.class);
    private final CountStorage countStorage;
    private final MetricRegistry metricRegistry;
    private final EngineGraknTxFactory factory;
    private final LockProvider lockProvider;
    private final long shardingThreshold;

    private CountPostProcessor(GraknConfig engineConfig, EngineGraknTxFactory factory, LockProvider lockProvider, MetricRegistry metricRegistry, CountStorage countStorage) {
        this.countStorage = countStorage;
        this.shardingThreshold = (Long)engineConfig.getProperty(GraknConfigKey.SHARDING_THRESHOLD);
        this.metricRegistry = metricRegistry;
        this.factory = factory;
        this.lockProvider = lockProvider;
    }

    public static CountPostProcessor create(GraknConfig engineConfig, EngineGraknTxFactory factory, LockProvider lockProvider, MetricRegistry metricRegistry, CountStorage countStorage) {
        return new CountPostProcessor(engineConfig, factory, lockProvider, metricRegistry, countStorage);
    }

    public void updateCounts(CommitLog commitLog) {
        try (Timer.Context context = this.metricRegistry.timer(MetricRegistry.name(CountPostProcessor.class, (String[])new String[]{"execution"})).time();){
            Map jobs = commitLog.instanceCount();
            this.metricRegistry.histogram(MetricRegistry.name(CountPostProcessor.class, (String[])new String[]{"jobs"})).update(jobs.size());
            HashSet conceptToShard = new HashSet();
            jobs.forEach((key, value) -> {
                this.metricRegistry.histogram(MetricRegistry.name(CountPostProcessor.class, (String[])new String[]{"shard-size-increase"})).update(value.longValue());
                Timer.Context contextSingle = this.metricRegistry.timer(MetricRegistry.name(CountPostProcessor.class, (String[])new String[]{"execution-single"})).time();
                try {
                    if (CountPostProcessor.incrementInstanceCountAndCheckIfShardingIsNeeded(this.countStorage, commitLog.keyspace(), key, value, this.shardingThreshold)) {
                        conceptToShard.add(key);
                    }
                }
                finally {
                    contextSingle.stop();
                }
            });
            conceptToShard.forEach(type -> {
                Timer.Context contextSharding = this.metricRegistry.timer("sharding").time();
                try {
                    this.shardConcept(this.countStorage, this.factory, commitLog.keyspace(), (ConceptId)type, this.shardingThreshold);
                }
                finally {
                    contextSharding.stop();
                }
            });
            LOG.debug("Updating instance count successful for {} tasks", (Object)jobs.size());
        }
        catch (Exception e) {
            LOG.error("Could not terminate task", (Throwable)e);
            throw e;
        }
    }

    private static boolean incrementInstanceCountAndCheckIfShardingIsNeeded(CountStorage countStorage, Keyspace keyspace, ConceptId conceptId, long value, long shardingThreshold) {
        long numInstances;
        long numShards = countStorage.getShardCount(keyspace, conceptId);
        if (numShards == 0L) {
            numShards = 1L;
        }
        return (numInstances = countStorage.incrementInstanceCount(keyspace, conceptId, value)) > shardingThreshold * numShards;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shardConcept(CountStorage countStorage, EngineGraknTxFactory factory, Keyspace keyspace, ConceptId conceptId, long shardingThreshold) {
        block15: {
            Lock engineLock = this.lockProvider.getLock(CountPostProcessor.getLockingKey(keyspace, conceptId));
            engineLock.lock();
            try {
                if (!CountPostProcessor.incrementInstanceCountAndCheckIfShardingIsNeeded(countStorage, keyspace, conceptId, 0L, shardingThreshold)) break block15;
                try (EmbeddedGraknTx<?> tx = factory.tx(keyspace, GraknTxType.WRITE);){
                    tx.shard(conceptId);
                    tx.commit();
                }
                countStorage.incrementShardCount(keyspace, conceptId, 1L);
            }
            finally {
                engineLock.unlock();
            }
        }
    }

    private static String getLockingKey(Keyspace keyspace, ConceptId conceptId) {
        return "/updating-instance-count-lock/" + keyspace + "/" + conceptId.getValue();
    }
}

