/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.task.postprocessing;

import ai.grakn.Keyspace;
import ai.grakn.concept.ConceptId;
import ai.grakn.engine.lock.LockProvider;
import ai.grakn.engine.task.postprocessing.IndexStorage;
import ai.grakn.kb.internal.EmbeddedGraknTx;
import ai.grakn.kb.log.CommitLog;
import ai.grakn.util.Schema;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.Lock;

public class IndexPostProcessor {
    private final LockProvider lockProvider;
    private final IndexStorage indexStorage;
    private static final String LOCK_KEY = "post-processing-index-lock-%s-%s";

    private IndexPostProcessor(LockProvider lockProvider, IndexStorage indexStorage) {
        this.lockProvider = lockProvider;
        this.indexStorage = indexStorage;
    }

    public static IndexPostProcessor create(LockProvider lockProvider, IndexStorage redisIndexStorage) {
        return new IndexPostProcessor(lockProvider, redisIndexStorage);
    }

    private String getLockKey(Keyspace keyspace, String index) {
        return String.format(LOCK_KEY, keyspace.getValue(), index);
    }

    public String popIndex(Keyspace keyspace) {
        return this.indexStorage.popIndex(keyspace);
    }

    public Set<ConceptId> popIds(Keyspace keyspace, String index) {
        return this.indexStorage.popIds(keyspace, index);
    }

    public void updateIndices(CommitLog commitLog) {
        commitLog.attributes().forEach((index, ids) -> this.indexStorage.addIndex(commitLog.keyspace(), (String)index, (Set<ConceptId>)ids));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeDuplicateConcepts(EmbeddedGraknTx<?> tx, String conceptIndex, Set<ConceptId> conceptIds) {
        if (tx.duplicateResourcesExist(conceptIndex, conceptIds)) {
            Lock indexLock = this.lockProvider.getLock(this.getLockKey(tx.keyspace(), conceptIndex));
            indexLock.lock();
            try {
                boolean commitNeeded = tx.fixDuplicateResources(conceptIndex, conceptIds);
                if (commitNeeded) {
                    this.validateMerged(tx, conceptIndex, conceptIds).ifPresent(message -> {
                        throw new RuntimeException((String)message);
                    });
                    tx.commit();
                }
            }
            finally {
                indexLock.unlock();
            }
        }
    }

    private Optional<String> validateMerged(EmbeddedGraknTx<?> tx, String conceptIndex, Set<ConceptId> conceptIds) {
        int numConceptFound = 0;
        for (ConceptId conceptId : conceptIds) {
            if (tx.getConcept(conceptId) == null || ++numConceptFound <= 1) continue;
            StringBuilder conceptIdValues = new StringBuilder();
            for (ConceptId id : conceptIds) {
                conceptIdValues.append(id.getValue()).append(",");
            }
            return Optional.of("Not all concept were merged. The set of concepts [" + conceptIds.size() + "] with IDs [" + conceptIdValues.toString() + "] matched more than one concept");
        }
        if (tx.getConcept(Schema.VertexProperty.INDEX, (Object)conceptIndex) == null) {
            return Optional.of("The concept index [" + conceptIndex + "] did not return any concept");
        }
        return Optional.empty();
    }
}

