/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.task.postprocessing.redisstorage;

import ai.grakn.Keyspace;
import ai.grakn.concept.ConceptId;
import ai.grakn.engine.task.postprocessing.CountStorage;
import ai.grakn.engine.task.postprocessing.redisstorage.RedisStorage;
import com.codahale.metrics.MetricRegistry;
import redis.clients.jedis.Jedis;
import redis.clients.util.Pool;

public class RedisCountStorage
implements CountStorage {
    private final RedisStorage redisStorage;

    private RedisCountStorage(Pool<Jedis> jedisPool, MetricRegistry metricRegistry) {
        this.redisStorage = new RedisStorage(jedisPool, metricRegistry);
    }

    public static RedisCountStorage create(Pool<Jedis> jedisPool, MetricRegistry metricRegistry) {
        return new RedisCountStorage(jedisPool, metricRegistry);
    }

    @Override
    public long incrementInstanceCount(Keyspace keyspace, ConceptId conceptId, long incrementBy) {
        return this.incrementCount(RedisCountStorage.getKeyNumInstances(keyspace, conceptId), incrementBy);
    }

    @Override
    public long incrementShardCount(Keyspace keyspace, ConceptId conceptId, long incrementBy) {
        return this.incrementCount(RedisCountStorage.getKeyNumShards(keyspace, conceptId), incrementBy);
    }

    @Override
    public long getInstanceCount(Keyspace keyspace, ConceptId conceptId) {
        return this.getCount(RedisCountStorage.getKeyNumInstances(keyspace, conceptId));
    }

    @Override
    public long getShardCount(Keyspace keyspace, ConceptId conceptId) {
        return this.getCount(RedisCountStorage.getKeyNumShards(keyspace, conceptId));
    }

    public long incrementCount(String key, long incrementBy) {
        return this.redisStorage.contactRedis(jedis -> {
            if (incrementBy != 0L) {
                return jedis.incrBy(key, incrementBy);
            }
            return this.getCount(key);
        });
    }

    public long getCount(String key) {
        return this.redisStorage.contactRedis(jedis -> {
            String value = jedis.get(key);
            if (value == null) {
                return 0L;
            }
            return Long.parseLong(value);
        });
    }

    public static String getKeyNumInstances(Keyspace keyspace, ConceptId conceptId) {
        return "NI_" + keyspace + "_" + conceptId.getValue();
    }

    public static String getKeyNumShards(Keyspace keyspace, ConceptId conceptId) {
        return "NS_" + keyspace + "_" + conceptId.getValue();
    }
}

