/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.task.postprocessing.redisstorage;

import ai.grakn.Keyspace;
import ai.grakn.concept.ConceptId;
import ai.grakn.engine.task.postprocessing.IndexStorage;
import ai.grakn.engine.task.postprocessing.redisstorage.RedisStorage;
import com.codahale.metrics.MetricRegistry;
import com.google.common.annotations.VisibleForTesting;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Response;
import redis.clients.jedis.Transaction;
import redis.clients.util.Pool;

public class RedisIndexStorage
implements IndexStorage {
    private final RedisStorage redisStorage;

    private RedisIndexStorage(Pool<Jedis> jedisPool, MetricRegistry metricRegistry) {
        this.redisStorage = new RedisStorage(jedisPool, metricRegistry);
    }

    public static RedisIndexStorage create(Pool<Jedis> jedisPool, MetricRegistry metricRegistry) {
        return new RedisIndexStorage(jedisPool, metricRegistry);
    }

    @Override
    public void addIndex(Keyspace keyspace, String index, Set<ConceptId> conceptIds) {
        String listOfIndicesKey = RedisIndexStorage.getIndicesKey(keyspace);
        String listOfIdsKey = RedisIndexStorage.getConceptIdsKey(keyspace, index);
        this.redisStorage.contactRedis(jedis -> {
            jedis.sadd(listOfIndicesKey, new String[]{index});
            conceptIds.forEach(id -> jedis.sadd(listOfIdsKey, new String[]{id.getValue()}));
            return null;
        });
    }

    @Override
    @Nullable
    public String popIndex(Keyspace keyspace) {
        String indexKey = RedisIndexStorage.getIndicesKey(keyspace);
        return this.redisStorage.contactRedis(jedis -> jedis.spop(indexKey));
    }

    @Override
    public Set<ConceptId> popIds(Keyspace keyspace, String index) {
        String idKey = RedisIndexStorage.getConceptIdsKey(keyspace, index);
        return this.redisStorage.contactRedis(jedis -> {
            Transaction tx = jedis.multi();
            Response responseIds = tx.smembers(idKey);
            tx.del(idKey);
            tx.exec();
            return ((Set)responseIds.get()).stream().map(ConceptId::of).collect(Collectors.toSet());
        });
    }

    @VisibleForTesting
    public static String getIndicesKey(Keyspace keyspace) {
        return "IndicesToProcess_" + keyspace.getValue();
    }

    @VisibleForTesting
    public static String getConceptIdsKey(Keyspace keyspace, String index) {
        return "IdsToPostProcess_" + keyspace.getValue() + "_Id_" + index;
    }
}

