/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.util;

import ai.grakn.engine.util.AutoValue_EngineID;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.UUID;
import javax.annotation.CheckReturnValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EngineID
implements Serializable {
    private static final long serialVersionUID = 8846772120873129437L;
    private static final Logger LOG = LoggerFactory.getLogger(EngineID.class);

    @CheckReturnValue
    @JsonValue
    public abstract String getValue();

    @CheckReturnValue
    public static EngineID of(String value) {
        return new AutoValue_EngineID(value);
    }

    @CheckReturnValue
    public static EngineID me() {
        String hostName = "";
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            LOG.error("Could not get system hostname: ", (Throwable)e);
        }
        String value = hostName + "-" + UUID.randomUUID().toString();
        return EngineID.of(value);
    }
}

