
package ai.grakn.engine.controller.response;

import ai.grakn.concept.ConceptId;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Set;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_Relationship extends Relationship {

  private final String baseType;
  private final ConceptId id;
  private final Link selfLink;
  private final EmbeddedSchemaConcept type;
  private final Link attributes;
  private final Link keys;
  private final Link relationships;
  private final boolean inferred;
  private final String explanation;
  private final Set<RolePlayer> roleplayers;

  AutoValue_Relationship(
      String baseType,
      ConceptId id,
      Link selfLink,
      EmbeddedSchemaConcept type,
      Link attributes,
      Link keys,
      Link relationships,
      boolean inferred,
      @Nullable String explanation,
      Set<RolePlayer> roleplayers) {
    if (baseType == null) {
      throw new NullPointerException("Null baseType");
    }
    this.baseType = baseType;
    if (id == null) {
      throw new NullPointerException("Null id");
    }
    this.id = id;
    if (selfLink == null) {
      throw new NullPointerException("Null selfLink");
    }
    this.selfLink = selfLink;
    if (type == null) {
      throw new NullPointerException("Null type");
    }
    this.type = type;
    if (attributes == null) {
      throw new NullPointerException("Null attributes");
    }
    this.attributes = attributes;
    if (keys == null) {
      throw new NullPointerException("Null keys");
    }
    this.keys = keys;
    if (relationships == null) {
      throw new NullPointerException("Null relationships");
    }
    this.relationships = relationships;
    this.inferred = inferred;
    this.explanation = explanation;
    if (roleplayers == null) {
      throw new NullPointerException("Null roleplayers");
    }
    this.roleplayers = roleplayers;
  }

  @JsonProperty(value = "base-type")
  @Override
  public String baseType() {
    return baseType;
  }

  @JsonProperty(value = "id")
  @Override
  public ConceptId id() {
    return id;
  }

  @JsonProperty(value = "@id")
  @Override
  public Link selfLink() {
    return selfLink;
  }

  @JsonProperty
  @Override
  public EmbeddedSchemaConcept type() {
    return type;
  }

  @JsonProperty
  @Override
  public Link attributes() {
    return attributes;
  }

  @JsonProperty
  @Override
  public Link keys() {
    return keys;
  }

  @JsonProperty
  @Override
  public Link relationships() {
    return relationships;
  }

  @JsonProperty
  @Override
  public boolean inferred() {
    return inferred;
  }

  @Nullable
  @JsonProperty(value = "explanation-query")
  @Override
  public String explanation() {
    return explanation;
  }

  @JsonProperty
  @Override
  public Set<RolePlayer> roleplayers() {
    return roleplayers;
  }

  @Override
  public String toString() {
    return "Relationship{"
        + "baseType=" + baseType + ", "
        + "id=" + id + ", "
        + "selfLink=" + selfLink + ", "
        + "type=" + type + ", "
        + "attributes=" + attributes + ", "
        + "keys=" + keys + ", "
        + "relationships=" + relationships + ", "
        + "inferred=" + inferred + ", "
        + "explanation=" + explanation + ", "
        + "roleplayers=" + roleplayers
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof Relationship) {
      Relationship that = (Relationship) o;
      return (this.baseType.equals(that.baseType()))
           && (this.id.equals(that.id()))
           && (this.selfLink.equals(that.selfLink()))
           && (this.type.equals(that.type()))
           && (this.attributes.equals(that.attributes()))
           && (this.keys.equals(that.keys()))
           && (this.relationships.equals(that.relationships()))
           && (this.inferred == that.inferred())
           && ((this.explanation == null) ? (that.explanation() == null) : this.explanation.equals(that.explanation()))
           && (this.roleplayers.equals(that.roleplayers()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= this.baseType.hashCode();
    h *= 1000003;
    h ^= this.id.hashCode();
    h *= 1000003;
    h ^= this.selfLink.hashCode();
    h *= 1000003;
    h ^= this.type.hashCode();
    h *= 1000003;
    h ^= this.attributes.hashCode();
    h *= 1000003;
    h ^= this.keys.hashCode();
    h *= 1000003;
    h ^= this.relationships.hashCode();
    h *= 1000003;
    h ^= this.inferred ? 1231 : 1237;
    h *= 1000003;
    h ^= (explanation == null) ? 0 : this.explanation.hashCode();
    h *= 1000003;
    h ^= this.roleplayers.hashCode();
    return h;
  }

}
