/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.factory;

import ai.grakn.factory.JanusPreviousPropertyStep;
import java.util.List;
import java.util.Optional;
import org.apache.tinkerpop.gremlin.process.traversal.Compare;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.TraversalFilterStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.WherePredicateStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GraphStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.PropertiesStep;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class JanusPreviousPropertyStepStrategy
extends AbstractTraversalStrategy<TraversalStrategy.ProviderOptimizationStrategy>
implements TraversalStrategy.ProviderOptimizationStrategy {
    private static final long serialVersionUID = 6888929702831948298L;

    public void apply(Traversal.Admin<?, ?> traversal) {
        List graphSteps = TraversalHelper.getStepsOfAssignableClass(GraphStep.class, traversal);
        for (GraphStep graphStep : graphSteps) {
            Optional<String> label;
            Optional<String> propertyKey;
            TraversalFilterStep filterStep;
            List<Step> steps;
            if (!(graphStep.getNextStep() instanceof TraversalFilterStep) || (steps = this.stepsFromFilterStep((TraversalFilterStep<Vertex>)(filterStep = (TraversalFilterStep)graphStep.getNextStep()))).size() < 2) continue;
            Step propertiesStep = steps.get(0);
            Step whereStep = steps.get(1);
            if (!(propertiesStep instanceof PropertiesStep) || !(propertyKey = this.propertyFromPropertiesStep((PropertiesStep<Vertex>)((PropertiesStep)propertiesStep))).isPresent() || !(whereStep instanceof WherePredicateStep) || !(label = this.labelFromWhereEqPredicate((WherePredicateStep<Vertex>)((WherePredicateStep)whereStep))).isPresent()) continue;
            this.executeStrategy(traversal, graphStep, (TraversalFilterStep<Vertex>)filterStep, propertyKey.get(), label.get());
        }
    }

    private List<Step> stepsFromFilterStep(TraversalFilterStep<Vertex> filterStep) {
        return ((Traversal.Admin)filterStep.getLocalChildren().get(0)).getSteps();
    }

    private Optional<String> propertyFromPropertiesStep(PropertiesStep<Vertex> propertiesStep) {
        String[] propertyKeys = propertiesStep.getPropertyKeys();
        if (propertyKeys.length != 1) {
            return Optional.empty();
        }
        return Optional.of(propertyKeys[0]);
    }

    private Optional<String> labelFromWhereEqPredicate(WherePredicateStep<Vertex> whereStep) {
        Optional optionalPredicate = whereStep.getPredicate();
        return optionalPredicate.flatMap(predicate -> {
            if (!predicate.getBiPredicate().equals(Compare.eq)) {
                return Optional.empty();
            }
            return Optional.of((String)predicate.getValue());
        });
    }

    private void executeStrategy(Traversal.Admin<?, ?> traversal, GraphStep<?, ?> graphStep, TraversalFilterStep<Vertex> filterStep, String propertyKey, String label) {
        JanusPreviousPropertyStep newStep = new JanusPreviousPropertyStep(traversal, propertyKey, label);
        traversal.removeStep(filterStep);
        TraversalHelper.replaceStep(graphStep, newStep, traversal);
    }
}

