/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.factory;

import ai.grakn.GraknConfigKey;
import ai.grakn.factory.EmbeddedGraknSession;
import ai.grakn.factory.TxFactoryAbstract;
import ai.grakn.factory.TxFactoryJanus;
import ai.grakn.kb.internal.EmbeddedGraknTx;
import ai.grakn.util.ErrorMessage;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.tinkerpop.gremlin.hadoop.structure.HadoopGraph;
import org.apache.tinkerpop.gremlin.structure.util.GraphFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TxFactoryJanusHadoop
extends TxFactoryAbstract<EmbeddedGraknTx<HadoopGraph>, HadoopGraph> {
    private final Logger LOG = LoggerFactory.getLogger(TxFactoryJanusHadoop.class);

    private static Map<String, String> overrideMap(EmbeddedGraknSession session) {
        String mrPrefixConf = "janusmr.ioformat.conf.";
        String graphMrPrefixConf = "janusgraphmr.ioformat.conf.";
        String inputKeyspaceConf = "cassandra.input.keyspace";
        String keyspaceConf = "storage.cassandra.keyspace";
        String hostnameConf = "storage.hostname";
        String keyspaceValue = session.keyspace().getValue();
        String hostnameValue = (String)session.config().getProperty(GraknConfigKey.STORAGE_HOSTNAME);
        return ImmutableMap.of((Object)(mrPrefixConf + keyspaceConf), (Object)keyspaceValue, (Object)(mrPrefixConf + hostnameConf), (Object)hostnameValue, (Object)(graphMrPrefixConf + hostnameConf), (Object)hostnameValue, (Object)(graphMrPrefixConf + keyspaceConf), (Object)keyspaceValue, (Object)inputKeyspaceConf, (Object)keyspaceValue);
    }

    TxFactoryJanusHadoop(EmbeddedGraknSession session) {
        super(session);
        TxFactoryJanusHadoop.overrideMap(this.session()).forEach((k, v) -> this.session().config().properties().setProperty((String)k, (String)v));
    }

    protected EmbeddedGraknTx<HadoopGraph> buildGraknTxFromTinkerGraph(HadoopGraph graph) {
        throw new UnsupportedOperationException(ErrorMessage.CANNOT_PRODUCE_TX.getMessage(new Object[]{HadoopGraph.class.getName()}));
    }

    protected HadoopGraph buildTinkerPopGraph(boolean batchLoading) {
        this.LOG.warn("Hadoop graph ignores parameter address [" + this.session().uri() + "]");
        TxFactoryJanus.getDefaultProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            if (!this.session().config().properties().containsKey(key)) {
                this.session().config().properties().put(key, value);
            }
        }));
        return (HadoopGraph)GraphFactory.open((Map)this.session().config().properties());
    }

    protected HadoopGraph getGraphWithNewTransaction(HadoopGraph graph, boolean batchloading) {
        return graph;
    }
}

