/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.example;

import ai.grakn.GraknGraph;
import ai.grakn.concept.EntityType;
import ai.grakn.concept.Instance;
import ai.grakn.concept.RelationType;
import ai.grakn.concept.Resource;
import ai.grakn.concept.ResourceType;
import ai.grakn.concept.RoleType;
import ai.grakn.concept.Rule;
import ai.grakn.concept.RuleType;
import ai.grakn.concept.Type;
import ai.grakn.exception.GraknValidationException;
import ai.grakn.graql.Pattern;
import ai.grakn.util.ErrorMessage;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;

public class MovieGraphFactory {
    private static GraknGraph graknGraph;
    private static EntityType movie;
    private static EntityType person;
    private static EntityType genre;
    private static EntityType character;
    private static EntityType cluster;
    private static EntityType language;
    private static ResourceType<String> title;
    private static ResourceType<String> gender;
    private static ResourceType<String> realName;
    private static ResourceType<String> name;
    private static ResourceType<Long> tmdbVoteCount;
    private static ResourceType<Long> releaseDate;
    private static ResourceType<Long> runtime;
    private static ResourceType<Double> tmdbVoteAverage;
    private static RelationType hasCast;
    private static RelationType directedBy;
    private static RelationType hasGenre;
    private static RelationType hasCluster;
    private static RoleType productionBeingDirected;
    private static RoleType director;
    private static RoleType productionWithCast;
    private static RoleType actor;
    private static RoleType characterBeingPlayed;
    private static RoleType genreOfProduction;
    private static RoleType productionWithGenre;
    private static RoleType clusterOfProduction;
    private static RoleType productionWithCluster;
    private static Instance godfather;
    private static Instance theMuppets;
    private static Instance heat;
    private static Instance apocalypseNow;
    private static Instance hocusPocus;
    private static Instance spy;
    private static Instance chineseCoffee;
    private static Instance marlonBrando;
    private static Instance alPacino;
    private static Instance missPiggy;
    private static Instance kermitTheFrog;
    private static Instance martinSheen;
    private static Instance robertDeNiro;
    private static Instance judeLaw;
    private static Instance mirandaHeart;
    private static Instance betteMidler;
    private static Instance sarahJessicaParker;
    private static Instance crime;
    private static Instance drama;
    private static Instance war;
    private static Instance action;
    private static Instance comedy;
    private static Instance family;
    private static Instance musical;
    private static Instance fantasy;
    private static Instance donVitoCorleone;
    private static Instance michaelCorleone;
    private static Instance colonelWalterEKurtz;
    private static Instance benjaminLWillard;
    private static Instance ltVincentHanna;
    private static Instance neilMcCauley;
    private static Instance bradleyFine;
    private static Instance nancyBArtingstall;
    private static Instance winifred;
    private static Instance sarah;
    private static Instance harry;
    private static Instance cluster0;
    private static Instance cluster1;
    private static final SimpleDateFormat DATE_FORMAT;

    private MovieGraphFactory() {
        throw new UnsupportedOperationException();
    }

    public static void loadGraph(GraknGraph graknGraph) {
        MovieGraphFactory.graknGraph = graknGraph;
        MovieGraphFactory.buildGraph();
        try {
            MovieGraphFactory.graknGraph.commit();
        }
        catch (GraknValidationException e) {
            throw new RuntimeException(ErrorMessage.CANNOT_LOAD_EXAMPLE.getMessage(new Object[0]), e);
        }
    }

    private static void buildGraph() {
        MovieGraphFactory.buildOntology();
        try {
            MovieGraphFactory.buildInstances();
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        MovieGraphFactory.buildRelations();
        MovieGraphFactory.buildRules();
    }

    private static void buildOntology() {
        productionBeingDirected = graknGraph.putRoleType("production-being-directed");
        director = graknGraph.putRoleType("director");
        directedBy = graknGraph.putRelationType("directed-by").hasRole(productionBeingDirected).hasRole(director);
        productionWithCast = graknGraph.putRoleType("production-with-cast");
        actor = graknGraph.putRoleType("actor");
        characterBeingPlayed = graknGraph.putRoleType("character-being-played");
        hasCast = graknGraph.putRelationType("has-cast").hasRole(productionWithCast).hasRole(actor).hasRole(characterBeingPlayed);
        genreOfProduction = graknGraph.putRoleType("genre-of-production");
        productionWithGenre = graknGraph.putRoleType("production-with-genre");
        hasGenre = graknGraph.putRelationType("has-genre").hasRole(genreOfProduction).hasRole(productionWithGenre);
        clusterOfProduction = graknGraph.putRoleType("cluster-of-production");
        productionWithCluster = graknGraph.putRoleType("production-with-cluster");
        hasCluster = graknGraph.putRelationType("has-cluster").hasRole(clusterOfProduction).hasRole(productionWithCluster);
        title = graknGraph.putResourceType("title", ResourceType.DataType.STRING);
        tmdbVoteCount = graknGraph.putResourceType("tmdb-vote-count", ResourceType.DataType.LONG);
        tmdbVoteAverage = graknGraph.putResourceType("tmdb-vote-average", ResourceType.DataType.DOUBLE);
        releaseDate = graknGraph.putResourceType("release-date", ResourceType.DataType.LONG);
        runtime = graknGraph.putResourceType("runtime", ResourceType.DataType.LONG);
        gender = graknGraph.putResourceType("gender", ResourceType.DataType.STRING).setRegex("(fe)?male");
        realName = graknGraph.putResourceType("real-name", ResourceType.DataType.STRING);
        name = graknGraph.putResourceType("name", ResourceType.DataType.STRING);
        EntityType production = graknGraph.putEntityType("production").playsRole(productionWithCluster).playsRole(productionBeingDirected).playsRole(productionWithCast).playsRole(productionWithGenre);
        production.hasResource(title);
        production.hasResource(tmdbVoteCount);
        production.hasResource(tmdbVoteAverage);
        production.hasResource(releaseDate);
        production.hasResource(runtime);
        movie = graknGraph.putEntityType("movie").superType(production);
        graknGraph.putEntityType("tv-show").superType(production);
        person = graknGraph.putEntityType("person").playsRole(director).playsRole(actor).playsRole(characterBeingPlayed);
        person.hasResource(gender);
        person.hasResource(name);
        person.hasResource(realName);
        genre = graknGraph.putEntityType("genre").playsRole(genreOfProduction);
        genre.key(name);
        character = graknGraph.putEntityType("character").playsRole(characterBeingPlayed);
        character.hasResource(name);
        graknGraph.putEntityType("award");
        language = graknGraph.putEntityType("language");
        language.hasResource(name);
        cluster = graknGraph.putEntityType("cluster").playsRole(clusterOfProduction);
        cluster.hasResource(name);
    }

    private static void buildInstances() throws ParseException {
        godfather = movie.addEntity();
        MovieGraphFactory.putResource(godfather, title, "Godfather");
        MovieGraphFactory.putResource(godfather, tmdbVoteCount, 1000L);
        MovieGraphFactory.putResource(godfather, tmdbVoteAverage, 8.6);
        MovieGraphFactory.putResource(godfather, releaseDate, DATE_FORMAT.parse("Sun Jan 01 00:00:00 GMT 1984").getTime());
        theMuppets = movie.addEntity();
        MovieGraphFactory.putResource(theMuppets, title, "The Muppets");
        MovieGraphFactory.putResource(theMuppets, tmdbVoteCount, 100L);
        MovieGraphFactory.putResource(theMuppets, tmdbVoteAverage, 7.6);
        MovieGraphFactory.putResource(theMuppets, releaseDate, DATE_FORMAT.parse("Sat Feb 02 00:00:00 GMT 1985").getTime());
        apocalypseNow = movie.addEntity();
        MovieGraphFactory.putResource(apocalypseNow, title, "Apocalypse Now");
        MovieGraphFactory.putResource(apocalypseNow, tmdbVoteCount, 400L);
        MovieGraphFactory.putResource(apocalypseNow, tmdbVoteAverage, 8.4);
        heat = movie.addEntity();
        MovieGraphFactory.putResource(heat, title, "Heat");
        hocusPocus = movie.addEntity();
        MovieGraphFactory.putResource(hocusPocus, title, "Hocus Pocus");
        MovieGraphFactory.putResource(hocusPocus, tmdbVoteCount, 435L);
        spy = movie.addEntity();
        MovieGraphFactory.putResource(spy, title, "Spy");
        MovieGraphFactory.putResource(spy, releaseDate, DATE_FORMAT.parse("Mon Mar 03 00:00:00 BST 1986").getTime());
        chineseCoffee = movie.addEntity();
        MovieGraphFactory.putResource(chineseCoffee, title, "Chinese Coffee");
        MovieGraphFactory.putResource(chineseCoffee, tmdbVoteCount, 5L);
        MovieGraphFactory.putResource(chineseCoffee, tmdbVoteAverage, 3.1);
        MovieGraphFactory.putResource(chineseCoffee, releaseDate, DATE_FORMAT.parse("Sat Sep 02 00:00:00 GMT 2000").getTime());
        marlonBrando = person.addEntity();
        MovieGraphFactory.putResource(marlonBrando, name, "Marlon Brando");
        alPacino = person.addEntity();
        MovieGraphFactory.putResource(alPacino, name, "Al Pacino");
        missPiggy = person.addEntity();
        MovieGraphFactory.putResource(missPiggy, name, "Miss Piggy");
        kermitTheFrog = person.addEntity();
        MovieGraphFactory.putResource(kermitTheFrog, name, "Kermit The Frog");
        martinSheen = person.addEntity();
        MovieGraphFactory.putResource(martinSheen, name, "Martin Sheen");
        robertDeNiro = person.addEntity();
        MovieGraphFactory.putResource(robertDeNiro, name, "Robert de Niro");
        judeLaw = person.addEntity();
        MovieGraphFactory.putResource(judeLaw, name, "Jude Law");
        mirandaHeart = person.addEntity();
        MovieGraphFactory.putResource(mirandaHeart, name, "Miranda Heart");
        betteMidler = person.addEntity();
        MovieGraphFactory.putResource(betteMidler, name, "Bette Midler");
        sarahJessicaParker = person.addEntity();
        MovieGraphFactory.putResource(sarahJessicaParker, name, "Sarah Jessica Parker");
        crime = genre.addEntity();
        MovieGraphFactory.putResource(crime, name, "crime");
        drama = genre.addEntity();
        MovieGraphFactory.putResource(drama, name, "drama");
        war = genre.addEntity();
        MovieGraphFactory.putResource(war, name, "war");
        action = genre.addEntity();
        MovieGraphFactory.putResource(action, name, "action");
        comedy = genre.addEntity();
        MovieGraphFactory.putResource(comedy, name, "comedy");
        family = genre.addEntity();
        MovieGraphFactory.putResource(family, name, "family");
        musical = genre.addEntity();
        MovieGraphFactory.putResource(musical, name, "musical");
        fantasy = genre.addEntity();
        MovieGraphFactory.putResource(fantasy, name, "fantasy");
        donVitoCorleone = character.addEntity();
        MovieGraphFactory.putResource(donVitoCorleone, name, "Don Vito Corleone");
        michaelCorleone = character.addEntity();
        MovieGraphFactory.putResource(michaelCorleone, name, "Michael Corleone");
        colonelWalterEKurtz = character.addEntity();
        MovieGraphFactory.putResource(colonelWalterEKurtz, name, "Colonel Walter E. Kurtz");
        benjaminLWillard = character.addEntity();
        MovieGraphFactory.putResource(benjaminLWillard, name, "Benjamin L. Willard");
        ltVincentHanna = character.addEntity();
        MovieGraphFactory.putResource(ltVincentHanna, name, "Lt Vincent Hanna");
        neilMcCauley = character.addEntity();
        MovieGraphFactory.putResource(neilMcCauley, name, "Neil McCauley");
        bradleyFine = character.addEntity();
        MovieGraphFactory.putResource(bradleyFine, name, "Bradley Fine");
        nancyBArtingstall = character.addEntity();
        MovieGraphFactory.putResource(nancyBArtingstall, name, "Nancy B Artingstall");
        winifred = character.addEntity();
        MovieGraphFactory.putResource(winifred, name, "Winifred");
        sarah = character.addEntity();
        MovieGraphFactory.putResource(sarah, name, "Sarah");
        harry = character.addEntity();
        MovieGraphFactory.putResource(harry, name, "Harry");
        cluster0 = cluster.addEntity();
        cluster1 = cluster.addEntity();
        MovieGraphFactory.putResource(cluster0, name, "0");
        MovieGraphFactory.putResource(cluster1, name, "1");
    }

    private static void buildRelations() {
        directedBy.addRelation().putRolePlayer(productionBeingDirected, chineseCoffee).putRolePlayer(director, alPacino);
        MovieGraphFactory.hasCast(godfather, marlonBrando, donVitoCorleone);
        MovieGraphFactory.hasCast(godfather, alPacino, michaelCorleone);
        MovieGraphFactory.hasCast(theMuppets, missPiggy, missPiggy);
        MovieGraphFactory.hasCast(theMuppets, kermitTheFrog, kermitTheFrog);
        MovieGraphFactory.hasCast(apocalypseNow, marlonBrando, colonelWalterEKurtz);
        MovieGraphFactory.hasCast(apocalypseNow, martinSheen, benjaminLWillard);
        MovieGraphFactory.hasCast(heat, alPacino, ltVincentHanna);
        MovieGraphFactory.hasCast(heat, robertDeNiro, neilMcCauley);
        MovieGraphFactory.hasCast(spy, judeLaw, bradleyFine);
        MovieGraphFactory.hasCast(spy, mirandaHeart, nancyBArtingstall);
        MovieGraphFactory.hasCast(hocusPocus, betteMidler, winifred);
        MovieGraphFactory.hasCast(hocusPocus, sarahJessicaParker, sarah);
        MovieGraphFactory.hasCast(chineseCoffee, alPacino, harry);
        MovieGraphFactory.hasGenre(godfather, crime);
        MovieGraphFactory.hasGenre(godfather, drama);
        MovieGraphFactory.hasGenre(apocalypseNow, drama);
        MovieGraphFactory.hasGenre(apocalypseNow, war);
        MovieGraphFactory.hasGenre(heat, crime);
        MovieGraphFactory.hasGenre(heat, drama);
        MovieGraphFactory.hasGenre(heat, action);
        MovieGraphFactory.hasGenre(theMuppets, comedy);
        MovieGraphFactory.hasGenre(theMuppets, family);
        MovieGraphFactory.hasGenre(theMuppets, musical);
        MovieGraphFactory.hasGenre(hocusPocus, comedy);
        MovieGraphFactory.hasGenre(hocusPocus, family);
        MovieGraphFactory.hasGenre(hocusPocus, fantasy);
        MovieGraphFactory.hasGenre(spy, comedy);
        MovieGraphFactory.hasGenre(spy, family);
        MovieGraphFactory.hasGenre(spy, musical);
        MovieGraphFactory.hasGenre(chineseCoffee, drama);
        MovieGraphFactory.hasCluster(godfather, cluster0);
        MovieGraphFactory.hasCluster(apocalypseNow, cluster0);
        MovieGraphFactory.hasCluster(heat, cluster0);
        MovieGraphFactory.hasCluster(theMuppets, cluster1);
        MovieGraphFactory.hasCluster(hocusPocus, cluster1);
    }

    private static void buildRules() {
        RuleType aRuleType = graknGraph.putRuleType("a-rule-type");
        aRuleType.hasResource(name);
        Pattern lhs = graknGraph.graql().parsePattern("$x id 'expect-lhs'");
        Pattern rhs = graknGraph.graql().parsePattern("$x id 'expect-rhs'");
        Rule expectation = aRuleType.addRule(lhs, rhs).setExpectation(true).addConclusion((Type)movie).addHypothesis((Type)person);
        MovieGraphFactory.putResource((Instance)expectation, name, "expectation-rule");
        lhs = graknGraph.graql().parsePattern("$x id 'materialize-lhs'");
        rhs = graknGraph.graql().parsePattern("$x id 'materialize-rhs'");
        Rule materialize = aRuleType.addRule(lhs, rhs).setMaterialise(true).addConclusion((Type)person).addConclusion((Type)genre).addHypothesis((Type)hasCast);
        MovieGraphFactory.putResource((Instance)materialize, name, "materialize-rule");
    }

    private static <D> void putResource(Instance instance, ResourceType<D> resourceType, D resource) {
        Resource resourceInstance = resourceType.putResource(resource);
        instance.hasResource(resourceInstance);
    }

    private static void hasCast(Instance movie, Instance person, Instance character) {
        hasCast.addRelation().putRolePlayer(productionWithCast, movie).putRolePlayer(actor, person).putRolePlayer(characterBeingPlayed, character);
    }

    private static void hasGenre(Instance movie, Instance genre) {
        hasGenre.addRelation().putRolePlayer(productionWithGenre, movie).putRolePlayer(genreOfProduction, genre);
    }

    private static void hasCluster(Instance movie, Instance cluster) {
        hasCluster.addRelation().putRolePlayer(productionWithCluster, movie).putRolePlayer(clusterOfProduction, cluster);
    }

    static {
        DATE_FORMAT = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US);
    }
}

