/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.example;

import ai.grakn.GraknGraph;
import ai.grakn.concept.Entity;
import ai.grakn.concept.EntityType;
import ai.grakn.concept.Instance;
import ai.grakn.concept.RelationType;
import ai.grakn.concept.Resource;
import ai.grakn.concept.ResourceType;
import ai.grakn.concept.RoleType;
import ai.grakn.exception.GraknValidationException;
import ai.grakn.util.ErrorMessage;

public class PokemonGraphFactory {
    private static EntityType pokemon;
    private static EntityType pokemonType;
    private static ResourceType<Long> pokedexNo;
    private static ResourceType<String> description;
    private static ResourceType<String> name;
    private static ResourceType<Long> height;
    private static ResourceType<Double> weight;
    private static RoleType ancestor;
    private static RoleType descendent;
    private static RoleType pokemonWithType;
    private static RoleType typeOfPokemon;
    private static RoleType defendingType;
    private static RoleType attackingType;
    private static RelationType evolution;
    private static RelationType hasType;
    private static RelationType superEffective;
    private static Entity normal;
    private static Entity fighting;
    private static Entity flying;
    private static Entity poison;
    private static Entity ground;
    private static Entity rock;
    private static Entity bug;
    private static Entity ghost;
    private static Entity steel;
    private static Entity fire;
    private static Entity water;
    private static Entity grass;
    private static Entity electric;
    private static Entity psychic;
    private static Entity ice;
    private static Entity dragon;
    private static Entity dark;
    private static Entity fairy;
    private static Entity unknown;
    private static Entity shadow;

    private PokemonGraphFactory() {
        throw new UnsupportedOperationException();
    }

    public static void loadGraph(GraknGraph graknGraph) {
        PokemonGraphFactory.buildGraph(graknGraph);
        try {
            graknGraph.commit();
        }
        catch (GraknValidationException e) {
            throw new RuntimeException(ErrorMessage.CANNOT_LOAD_EXAMPLE.getMessage(new Object[0]), e);
        }
    }

    private static void buildGraph(GraknGraph graph) {
        PokemonGraphFactory.buildOntology(graph);
        PokemonGraphFactory.buildRelations(graph);
        PokemonGraphFactory.buildInstances(graph);
    }

    private static void buildOntology(GraknGraph graph) {
        ancestor = graph.putRoleType("ancestor");
        descendent = graph.putRoleType("descendent");
        evolution = graph.putRelationType("evolution").hasRole(ancestor).hasRole(descendent);
        pokemonWithType = graph.putRoleType("pokemon-with-type");
        typeOfPokemon = graph.putRoleType("type-of-pokemon");
        hasType = graph.putRelationType("has-type").hasRole(pokemonWithType).hasRole(typeOfPokemon);
        defendingType = graph.putRoleType("defending-type");
        attackingType = graph.putRoleType("attacking-type");
        superEffective = graph.putRelationType("super-effective").hasRole(defendingType).hasRole(attackingType);
        pokemon = graph.putEntityType("pokemon").playsRole(ancestor).playsRole(descendent).playsRole(pokemonWithType);
        pokemonType = graph.putEntityType("pokemon-type").playsRole(typeOfPokemon).playsRole(defendingType).playsRole(attackingType);
        name = graph.putResourceType("name", ResourceType.DataType.STRING);
        pokedexNo = graph.putResourceType("pokedex-no", ResourceType.DataType.LONG);
        description = graph.putResourceType("description", ResourceType.DataType.STRING);
        height = graph.putResourceType("height", ResourceType.DataType.LONG);
        weight = graph.putResourceType("weight", ResourceType.DataType.DOUBLE);
        pokemon.hasResource(name);
        pokemon.hasResource(pokedexNo);
        pokemon.hasResource(description);
        pokemon.hasResource(height);
        pokemon.hasResource(weight);
        pokemonType.hasResource(name);
    }

    private static void buildInstances(GraknGraph graph) {
        Entity bulbasaur = pokemon.addEntity();
        PokemonGraphFactory.addResource(graph, bulbasaur, "Bulbasaur", name);
        PokemonGraphFactory.addResource(graph, bulbasaur, 1L, pokedexNo);
        PokemonGraphFactory.addResource(graph, bulbasaur, "A strange seed was planted on its back at birth. The plant sprouts and grows with this POK\u00e9MON.", description);
        PokemonGraphFactory.addResource(graph, bulbasaur, 7L, height);
        PokemonGraphFactory.addResource(graph, bulbasaur, 69.0, weight);
        PokemonGraphFactory.putTypes(graph, bulbasaur, poison, grass);
        Entity ivysaur = pokemon.addEntity();
        PokemonGraphFactory.addResource(graph, ivysaur, "Ivysaur", name);
        PokemonGraphFactory.addResource(graph, ivysaur, 2L, pokedexNo);
        PokemonGraphFactory.addResource(graph, ivysaur, "When the bulb on its back grows large, it appears to lose the ability to stand on its hind legs.", description);
        PokemonGraphFactory.addResource(graph, ivysaur, 10L, height);
        PokemonGraphFactory.addResource(graph, ivysaur, 130.0, weight);
        PokemonGraphFactory.putTypes(graph, ivysaur, poison, grass);
        evolution.addRelation().putRolePlayer(descendent, (Instance)ivysaur).putRolePlayer(ancestor, (Instance)bulbasaur);
        Entity venusaur = pokemon.addEntity();
        PokemonGraphFactory.addResource(graph, venusaur, "Venusaur", name);
        PokemonGraphFactory.addResource(graph, venusaur, 3L, pokedexNo);
        PokemonGraphFactory.addResource(graph, venusaur, "The plant blooms when it is absorbing solar energy. It stays on the move to seek sunlight.", description);
        PokemonGraphFactory.addResource(graph, venusaur, 20L, height);
        PokemonGraphFactory.addResource(graph, venusaur, 1000.0, weight);
        PokemonGraphFactory.putTypes(graph, venusaur, poison, grass);
        evolution.addRelation().putRolePlayer(descendent, (Instance)venusaur).putRolePlayer(ancestor, (Instance)ivysaur);
        Entity charmander = pokemon.addEntity();
        PokemonGraphFactory.addResource(graph, charmander, "Charmander", name);
        PokemonGraphFactory.addResource(graph, charmander, 4L, pokedexNo);
        PokemonGraphFactory.addResource(graph, charmander, "Obviously prefers hot places. When it rains, steam is said to spout from the tip of its tail.", description);
        PokemonGraphFactory.addResource(graph, charmander, 6L, height);
        PokemonGraphFactory.addResource(graph, charmander, 85.0, weight);
        PokemonGraphFactory.putTypes(graph, charmander, fire);
        Entity charmeleon = pokemon.addEntity();
        PokemonGraphFactory.addResource(graph, charmeleon, "Charmeleon", name);
        PokemonGraphFactory.addResource(graph, charmeleon, 5L, pokedexNo);
        PokemonGraphFactory.addResource(graph, charmeleon, "When it swings its burning tail, it elevates the temperature to unbearably high levels.", description);
        PokemonGraphFactory.addResource(graph, charmeleon, 11L, height);
        PokemonGraphFactory.addResource(graph, charmeleon, 190.0, weight);
        PokemonGraphFactory.putTypes(graph, charmeleon, fire);
        evolution.addRelation().putRolePlayer(descendent, (Instance)charmeleon).putRolePlayer(ancestor, (Instance)charmander);
        Entity charizard = pokemon.addEntity();
        PokemonGraphFactory.addResource(graph, charizard, "Charizard", name);
        PokemonGraphFactory.addResource(graph, charizard, 6L, pokedexNo);
        PokemonGraphFactory.addResource(graph, charizard, "Spits fire that is hot enough to melt boulders. Known to cause forest fires unintentionally.", description);
        PokemonGraphFactory.addResource(graph, charizard, 17L, height);
        PokemonGraphFactory.addResource(graph, charizard, 905.0, weight);
        PokemonGraphFactory.putTypes(graph, charizard, fire, flying);
        evolution.addRelation().putRolePlayer(descendent, (Instance)charizard).putRolePlayer(ancestor, (Instance)charmeleon);
    }

    private static <T> void addResource(GraknGraph graph, Entity entity, T s, ResourceType<T> type) {
        Resource resource = type.putResource(s);
        entity.hasResource(resource);
    }

    private static void putTypes(GraknGraph graph, Entity pokemon, Entity ... entities) {
        for (Entity entity : entities) {
            hasType.addRelation().putRolePlayer(pokemonWithType, (Instance)pokemon).putRolePlayer(typeOfPokemon, (Instance)entity);
        }
    }

    private static void buildRelations(GraknGraph graph) {
        normal = pokemonType.addEntity();
        PokemonGraphFactory.addResource(graph, normal, "normal", name);
        fighting = pokemonType.addEntity();
        PokemonGraphFactory.addResource(graph, fighting, "fighting", name);
        flying = pokemonType.addEntity();
        PokemonGraphFactory.addResource(graph, flying, "flying", name);
        poison = pokemonType.addEntity();
        PokemonGraphFactory.addResource(graph, poison, "poison", name);
        ground = pokemonType.addEntity();
        PokemonGraphFactory.addResource(graph, ground, "ground", name);
        rock = pokemonType.addEntity();
        PokemonGraphFactory.addResource(graph, rock, "rock", name);
        bug = pokemonType.addEntity();
        PokemonGraphFactory.addResource(graph, bug, "bug", name);
        ghost = pokemonType.addEntity();
        PokemonGraphFactory.addResource(graph, ghost, "ghost", name);
        steel = pokemonType.addEntity();
        PokemonGraphFactory.addResource(graph, steel, "steel", name);
        fire = pokemonType.addEntity();
        PokemonGraphFactory.addResource(graph, fire, "fire", name);
        water = pokemonType.addEntity();
        PokemonGraphFactory.addResource(graph, water, "water", name);
        grass = pokemonType.addEntity();
        PokemonGraphFactory.addResource(graph, grass, "grass", name);
        electric = pokemonType.addEntity();
        PokemonGraphFactory.addResource(graph, electric, "electric", name);
        psychic = pokemonType.addEntity();
        PokemonGraphFactory.addResource(graph, psychic, "psychic", name);
        ice = pokemonType.addEntity();
        PokemonGraphFactory.addResource(graph, ice, "ice", name);
        dragon = pokemonType.addEntity();
        PokemonGraphFactory.addResource(graph, dragon, "dragon", name);
        dark = pokemonType.addEntity();
        PokemonGraphFactory.addResource(graph, dark, "dark", name);
        fairy = pokemonType.addEntity();
        PokemonGraphFactory.addResource(graph, fairy, "fairy", name);
        unknown = pokemonType.addEntity();
        PokemonGraphFactory.addResource(graph, unknown, "unknown", name);
        shadow = pokemonType.addEntity();
        PokemonGraphFactory.addResource(graph, shadow, "shadow", name);
        PokemonGraphFactory.putSuper(graph, normal, fighting);
        PokemonGraphFactory.putSuper(graph, rock, fighting);
        PokemonGraphFactory.putSuper(graph, fighting, flying);
        PokemonGraphFactory.putSuper(graph, bug, flying);
        PokemonGraphFactory.putSuper(graph, grass, flying);
        PokemonGraphFactory.putSuper(graph, grass, poison);
        PokemonGraphFactory.putSuper(graph, grass, bug);
        PokemonGraphFactory.putSuper(graph, grass, fire);
        PokemonGraphFactory.putSuper(graph, fairy, poison);
        PokemonGraphFactory.putSuper(graph, poison, ground);
        PokemonGraphFactory.putSuper(graph, ice, steel);
        PokemonGraphFactory.putSuper(graph, poison, psychic);
        PokemonGraphFactory.putSuper(graph, ground, grass);
        PokemonGraphFactory.putSuper(graph, rock, grass);
        PokemonGraphFactory.putSuper(graph, water, grass);
        PokemonGraphFactory.putSuper(graph, grass, ice);
    }

    private static void putSuper(GraknGraph graph, Entity defend, Entity attack) {
        superEffective.addRelation().putRolePlayer(defendingType, (Instance)defend).putRolePlayer(attackingType, (Instance)attack);
    }
}

