/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.factory;

import ai.grakn.exception.GraphRuntimeException;
import ai.grakn.factory.FactoryBuilder;
import ai.grakn.factory.InternalFactory;
import ai.grakn.factory.SystemKeyspace;
import ai.grakn.graph.internal.AbstractGraknGraph;
import ai.grakn.util.ErrorMessage;
import java.util.Properties;
import org.apache.tinkerpop.gremlin.structure.Graph;

abstract class AbstractInternalFactory<M extends AbstractGraknGraph<G>, G extends Graph>
implements InternalFactory<M, G> {
    protected final String keyspace;
    protected final String engineUrl;
    protected final Properties properties;
    protected M graknGraph = null;
    private M batchLoadingGraknGraph = null;
    protected G graph = null;
    private G batchLoadingGraph = null;
    private Boolean lastGraphBuiltBatchLoading = null;
    private SystemKeyspace<M, G> systemKeyspace;

    AbstractInternalFactory(String keyspace, String engineUrl, Properties properties) {
        if (keyspace == null) {
            throw new GraphRuntimeException(ErrorMessage.NULL_VALUE.getMessage(new Object[]{"keyspace"}));
        }
        this.keyspace = keyspace.toLowerCase();
        this.engineUrl = engineUrl;
        this.properties = properties;
        if (!keyspace.equals("graknSystem")) {
            this.systemKeyspace = new SystemKeyspace<M, G>(this.getSystemFactory());
        }
    }

    InternalFactory<M, G> getSystemFactory() {
        return FactoryBuilder.getGraknGraphFactory(this.getClass().getName(), "graknSystem", this.engineUrl, this.properties);
    }

    abstract boolean isClosed(G var1);

    abstract M buildGraknGraphFromTinker(G var1, boolean var2);

    abstract G buildTinkerPopGraph(boolean var1);

    @Override
    public synchronized M getGraph(boolean batchLoading) {
        if (batchLoading) {
            this.batchLoadingGraknGraph = this.getGraph(this.batchLoadingGraknGraph, true);
            this.lastGraphBuiltBatchLoading = true;
            return this.batchLoadingGraknGraph;
        }
        this.graknGraph = this.getGraph(this.graknGraph, false);
        this.lastGraphBuiltBatchLoading = false;
        return this.graknGraph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected M getGraph(M graknGraph, boolean batchLoading) {
        boolean hasCommitted;
        if (this.lastGraphBuiltBatchLoading != null && this.lastGraphBuiltBatchLoading != batchLoading && graknGraph != null && (hasCommitted = this.lastGraphBuiltBatchLoading != false ? ((AbstractGraknGraph)this.batchLoadingGraknGraph).hasCommitted() : ((AbstractGraknGraph)graknGraph).hasCommitted())) {
            try {
                ((AbstractGraknGraph)graknGraph).finaliseClose(() -> graknGraph.closePermanent(), ErrorMessage.CLOSED_FACTORY.getMessage(new Object[0]));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (graknGraph == null) {
            graknGraph = this.buildGraknGraphFromTinker(this.getTinkerPopGraph(batchLoading), batchLoading);
            if (!"graknSystem".equalsIgnoreCase(this.keyspace)) {
                this.systemKeyspace.keyspaceOpened(this.keyspace);
            }
        } else if (((AbstractGraknGraph)graknGraph).isClosed()) {
            graknGraph = this.buildGraknGraphFromTinker(this.getTinkerPopGraph(batchLoading), batchLoading);
        } else {
            Object innerGraph;
            Object g = innerGraph = ((AbstractGraknGraph)graknGraph).getTinkerPopGraph();
            synchronized (g) {
                if (this.isClosed(innerGraph)) {
                    graknGraph = this.buildGraknGraphFromTinker(this.getTinkerPopGraph(batchLoading), batchLoading);
                } else {
                    this.getGraphWithNewTransaction(((AbstractGraknGraph)graknGraph).getTinkerPopGraph());
                }
            }
        }
        return graknGraph;
    }

    @Override
    public synchronized G getTinkerPopGraph(boolean batchLoading) {
        if (batchLoading) {
            this.batchLoadingGraph = this.getTinkerPopGraph(this.batchLoadingGraph, true);
            return this.batchLoadingGraph;
        }
        this.graph = this.getTinkerPopGraph(this.graph, false);
        return this.graph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected G getTinkerPopGraph(G graph, boolean batchLoading) {
        if (graph == null) {
            return this.getGraphWithNewTransaction(this.buildTinkerPopGraph(batchLoading));
        }
        G g = graph;
        synchronized (g) {
            if (this.isClosed(graph)) {
                return this.getGraphWithNewTransaction(this.buildTinkerPopGraph(batchLoading));
            }
            return this.getGraphWithNewTransaction(graph);
        }
    }

    protected G getGraphWithNewTransaction(G graph) {
        return graph;
    }
}

