/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.factory;

import ai.grakn.factory.InternalFactory;
import ai.grakn.factory.SystemKeyspace;
import ai.grakn.factory.TinkerInternalFactory;
import ai.grakn.util.ErrorMessage;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.tinkerpop.shaded.minlog.Log;

class FactoryBuilder {
    private static final String FACTORY = "factory.internal";
    private static final Map<String, InternalFactory> openFactories = new ConcurrentHashMap<String, InternalFactory>();

    private FactoryBuilder() {
        throw new UnsupportedOperationException();
    }

    static InternalFactory getFactory(String keyspace, String engineUrl, Properties properties) {
        try {
            String factoryType = !"in-memory".equals(engineUrl) ? properties.get(FACTORY).toString() : TinkerInternalFactory.class.getName();
            return FactoryBuilder.getGraknGraphFactory(factoryType, keyspace, engineUrl, properties);
        }
        catch (MissingResourceException e) {
            throw new IllegalArgumentException(ErrorMessage.MISSING_FACTORY_DEFINITION.getMessage(new Object[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static InternalFactory getGraknGraphFactory(String factoryType, String keyspace, String engineUrl, Properties properties) {
        String key = factoryType + keyspace.toLowerCase();
        Log.debug((String)("Get factory for " + key));
        InternalFactory factory = openFactories.get(key);
        if (factory != null) {
            return factory;
        }
        Map<String, InternalFactory> map = openFactories;
        synchronized (map) {
            InternalFactory internalFactory;
            try {
                internalFactory = (InternalFactory)Class.forName(factoryType).getDeclaredConstructor(String.class, String.class, Properties.class).newInstance(keyspace, engineUrl, properties);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalArgumentException(ErrorMessage.INVALID_FACTORY.getMessage(new Object[]{factoryType}), e);
            }
            openFactories.put(key, internalFactory);
            Log.debug((String)("New factory created " + internalFactory));
            if (keyspace.equalsIgnoreCase("graknSystem")) {
                Log.debug((String)"This is a system factory, loading system ontology.");
                new SystemKeyspace(internalFactory).loadSystemOntology();
            } else {
                Log.debug((String)"This is not a system factory, not loading system ontology.");
            }
            return internalFactory;
        }
    }

    static void refresh() {
        openFactories.clear();
    }
}

