/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.factory;

import ai.grakn.GraknComputer;
import ai.grakn.GraknGraph;
import ai.grakn.GraknGraphFactory;
import ai.grakn.factory.FactoryBuilder;
import ai.grakn.factory.InternalFactory;
import ai.grakn.factory.TinkerInternalFactory;
import ai.grakn.graph.internal.GraknComputerImpl;
import ai.grakn.util.EngineCommunicator;
import ai.grakn.util.ErrorMessage;
import java.io.IOException;
import java.io.StringReader;
import java.util.Properties;
import org.apache.tinkerpop.gremlin.structure.Graph;

public class GraknGraphFactoryImpl
implements GraknGraphFactory {
    private static final String TINKER_GRAPH_COMPUTER = "org.apache.tinkerpop.gremlin.tinkergraph.process.computer.TinkerGraphComputer";
    private static final String COMPUTER = "graph.computer";
    private final String location;
    private final String keyspace;

    public GraknGraphFactoryImpl(String keyspace, String location) {
        this.location = location;
        this.keyspace = keyspace;
    }

    public GraknGraph getGraph() {
        return this.getConfiguredFactory().factory.getGraph(false);
    }

    public GraknGraph getGraphBatchLoading() {
        return this.getConfiguredFactory().factory.getGraph(true);
    }

    private ConfiguredFactory getConfiguredFactory() {
        return GraknGraphFactoryImpl.configureGraphFactory(this.keyspace, this.location, "default");
    }

    public GraknComputer getGraphComputer() {
        ConfiguredFactory configuredFactory = GraknGraphFactoryImpl.configureGraphFactory(this.keyspace, this.location, "computer");
        Object graph = configuredFactory.factory.getTinkerPopGraph(false);
        return new GraknComputerImpl((Graph)graph, configuredFactory.graphComputer);
    }

    static ConfiguredFactory configureGraphFactory(String keyspace, String location, String graphType) {
        if ("in-memory".equals(location)) {
            return GraknGraphFactoryImpl.configureGraphFactoryInMemory(keyspace);
        }
        return GraknGraphFactoryImpl.configureGraphFactoryRemote(keyspace, location, graphType);
    }

    private static ConfiguredFactory configureGraphFactoryRemote(String keyspace, String engineUrl, String graphType) {
        try {
            String restFactoryUri = engineUrl + "/graph_factory" + "?" + "graphConfig" + "=" + graphType;
            Properties properties = new Properties();
            properties.load(new StringReader(EngineCommunicator.contactEngine(restFactoryUri, "GET")));
            String computer = null;
            if (properties.containsKey(COMPUTER)) {
                computer = properties.get(COMPUTER).toString();
            }
            return new ConfiguredFactory(properties, computer, FactoryBuilder.getFactory(keyspace, engineUrl, properties));
        }
        catch (IOException e) {
            throw new IllegalArgumentException(ErrorMessage.CONFIG_NOT_FOUND.getMessage(new Object[]{engineUrl, e.getMessage()}));
        }
    }

    private static ConfiguredFactory configureGraphFactoryInMemory(String keyspace) {
        InternalFactory factory = FactoryBuilder.getGraknGraphFactory(TinkerInternalFactory.class.getName(), keyspace, "in-memory", null);
        return new ConfiguredFactory(null, TINKER_GRAPH_COMPUTER, factory);
    }

    static class ConfiguredFactory {
        final Properties properties;
        final String graphComputer;
        final InternalFactory factory;

        ConfiguredFactory(Properties properties, String graphComputer, InternalFactory factory) {
            this.properties = properties;
            this.graphComputer = graphComputer;
            this.factory = factory;
        }
    }
}

