/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.factory;

import ai.grakn.GraknGraph;
import ai.grakn.concept.Resource;
import ai.grakn.concept.ResourceType;
import ai.grakn.exception.GraknValidationException;
import ai.grakn.factory.InternalFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemKeyspace<M extends GraknGraph, T extends Graph> {
    public static final String SYSTEM_GRAPH_NAME = "graknSystem";
    public static final String SYSTEM_ONTOLOGY_FILE = "system.gql";
    public static final String KEYSPACE_ENTITY = "keyspace";
    public static final String KEYSPACE_RESOURCE = "keyspace-name";
    protected final Logger LOG = LoggerFactory.getLogger(SystemKeyspace.class);
    private static final ConcurrentHashMap<String, Boolean> openSpaces = new ConcurrentHashMap();
    private final InternalFactory<M, T> factory;

    public SystemKeyspace(InternalFactory<M, T> factory) {
        this.factory = factory;
    }

    public SystemKeyspace<M, T> keyspaceOpened(String keyspace) {
        openSpaces.computeIfAbsent(keyspace, name -> {
            try (M graph = this.factory.getGraph(false);){
                ResourceType keyspaceName = graph.getResourceType(KEYSPACE_RESOURCE);
                Resource resource = keyspaceName.getResource((Object)keyspace);
                if (resource == null) {
                    resource = keyspaceName.putResource((Object)keyspace);
                }
                if (resource.owner() == null) {
                    graph.getEntityType(KEYSPACE_ENTITY).addEntity().hasResource(resource);
                }
                graph.commit();
            }
            catch (GraknValidationException e) {
                e.printStackTrace();
            }
            return true;
        });
        return this;
    }

    public void loadSystemOntology() {
        try (M graph = this.factory.getGraph(false);){
            String query;
            if (graph.getEntityType(KEYSPACE_ENTITY) != null) {
                return;
            }
            ClassLoader loader = this.getClass().getClassLoader();
            try (BufferedReader buffer = new BufferedReader(new InputStreamReader(loader.getResourceAsStream(SYSTEM_ONTOLOGY_FILE)));){
                query = buffer.lines().collect(Collectors.joining("\n"));
            }
            this.LOG.info("System ontology is " + query);
            graph.graql().parse(query).execute();
            graph.getResourceType("system-version").putResource((Object)"0.10.0");
            graph.commit();
            this.LOG.info("Loaded system ontology to system keyspace.");
        }
        catch (GraknValidationException | IOException | NullPointerException e) {
            e.printStackTrace(System.err);
            this.LOG.error("Could not load system ontology. The error was: " + e);
        }
    }
}

