/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.factory;

import ai.grakn.factory.AbstractInternalFactory;
import ai.grakn.graph.internal.GraknTinkerGraph;
import ai.grakn.util.Schema;
import java.util.Properties;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TinkerInternalFactory
extends AbstractInternalFactory<GraknTinkerGraph, TinkerGraph> {
    private final Logger LOG = LoggerFactory.getLogger(TinkerInternalFactory.class);

    TinkerInternalFactory(String keyspace, String engineUrl, Properties properties) {
        super(keyspace, engineUrl, properties);
    }

    @Override
    boolean isClosed(TinkerGraph innerGraph) {
        return !innerGraph.traversal().V(new Object[0]).has(Schema.ConceptProperty.NAME.name(), (Object)Schema.MetaSchema.ENTITY.getName()).hasNext();
    }

    @Override
    GraknTinkerGraph buildGraknGraphFromTinker(TinkerGraph graph, boolean batchLoading) {
        return new GraknTinkerGraph(graph, this.keyspace, this.engineUrl, batchLoading);
    }

    @Override
    TinkerGraph buildTinkerPopGraph(boolean batchLoading) {
        this.LOG.warn("In memory Tinkergraph ignores the address [" + this.engineUrl + "] and " + "the config path [" + this.properties + "]");
        return TinkerGraph.open();
    }

    @Override
    protected TinkerGraph getTinkerPopGraph(TinkerGraph graph, boolean batchLoading) {
        if (this.graph == null || this.isClosed((TinkerGraph)this.graph)) {
            this.graph = this.buildTinkerPopGraph(batchLoading);
        }
        return (TinkerGraph)this.graph;
    }
}

