/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graph.internal;

import ai.grakn.GraknAdmin;
import ai.grakn.GraknGraph;
import ai.grakn.concept.Concept;
import ai.grakn.concept.ConceptId;
import ai.grakn.concept.EntityType;
import ai.grakn.concept.Instance;
import ai.grakn.concept.Relation;
import ai.grakn.concept.RelationType;
import ai.grakn.concept.Resource;
import ai.grakn.concept.ResourceType;
import ai.grakn.concept.RoleType;
import ai.grakn.concept.RuleType;
import ai.grakn.concept.Type;
import ai.grakn.exception.ConceptException;
import ai.grakn.exception.ConceptNotUniqueException;
import ai.grakn.exception.GraknValidationException;
import ai.grakn.exception.GraphRuntimeException;
import ai.grakn.exception.MoreThanOneConceptException;
import ai.grakn.graph.internal.CastingImpl;
import ai.grakn.graph.internal.ConceptImpl;
import ai.grakn.graph.internal.ConceptLog;
import ai.grakn.graph.internal.EdgeImpl;
import ai.grakn.graph.internal.ElementFactory;
import ai.grakn.graph.internal.EntityTypeImpl;
import ai.grakn.graph.internal.InstanceImpl;
import ai.grakn.graph.internal.RelationImpl;
import ai.grakn.graph.internal.RelationTypeImpl;
import ai.grakn.graph.internal.ResourceImpl;
import ai.grakn.graph.internal.ResourceTypeImpl;
import ai.grakn.graph.internal.RoleTypeImpl;
import ai.grakn.graph.internal.RuleTypeImpl;
import ai.grakn.graph.internal.TypeImpl;
import ai.grakn.graph.internal.Validator;
import ai.grakn.graql.QueryBuilder;
import ai.grakn.graql.internal.query.QueryBuilderImpl;
import ai.grakn.util.EngineCommunicator;
import ai.grakn.util.ErrorMessage;
import ai.grakn.util.Schema;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.verification.ReadOnlyStrategy;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGraknGraph<G extends Graph>
implements GraknGraph,
GraknAdmin {
    protected final Logger LOG = LoggerFactory.getLogger(AbstractGraknGraph.class);
    private final ElementFactory elementFactory;
    private final String keyspace;
    private final String engine;
    private final boolean batchLoadingEnabled;
    private final G graph;
    private final ThreadLocal<ConceptLog> localConceptLog = new ThreadLocal();
    private final ThreadLocal<Boolean> localIsOpen = new ThreadLocal();
    private final ThreadLocal<String> localClosedReason = new ThreadLocal();
    private final ThreadLocal<Boolean> localShowImplicitStructures = new ThreadLocal();
    private boolean committed;

    public AbstractGraknGraph(G graph, String keyspace, String engine, boolean batchLoadingEnabled) {
        this.graph = graph;
        this.keyspace = keyspace;
        this.engine = engine;
        this.localIsOpen.set(true);
        this.elementFactory = new ElementFactory(this);
        if (this.initialiseMetaConcepts()) {
            try {
                this.commit();
            }
            catch (GraknValidationException e) {
                throw new RuntimeException(ErrorMessage.CREATING_ONTOLOGY_ERROR.getMessage(new Object[]{e.getMessage()}));
            }
        }
        this.batchLoadingEnabled = batchLoadingEnabled;
        this.committed = false;
        this.localShowImplicitStructures.set(false);
    }

    public String getKeyspace() {
        return this.keyspace;
    }

    public boolean isClosed() {
        return !this.getBooleanFromLocalThread(this.localIsOpen);
    }

    public boolean implicitConceptsVisible() {
        return this.getBooleanFromLocalThread(this.localShowImplicitStructures);
    }

    private boolean getBooleanFromLocalThread(ThreadLocal<Boolean> local) {
        Boolean value = local.get();
        if (value == null) {
            return false;
        }
        return value;
    }

    public void showImplicitConcepts(boolean flag) {
        this.localShowImplicitStructures.set(flag);
    }

    public GraknAdmin admin() {
        return this;
    }

    public <T extends Concept> T buildConcept(Vertex vertex) {
        return (T)this.elementFactory.buildConcept(vertex);
    }

    public boolean hasCommitted() {
        return this.committed;
    }

    public boolean isBatchLoadingEnabled() {
        return this.batchLoadingEnabled;
    }

    public boolean initialiseMetaConcepts() {
        if (this.isMetaOntologyNotInitialised()) {
            Vertex type = this.putVertexInternal(Schema.MetaSchema.CONCEPT.getName(), Schema.BaseType.TYPE);
            Vertex entityType = this.putVertexInternal(Schema.MetaSchema.ENTITY.getName(), Schema.BaseType.ENTITY_TYPE);
            Vertex relationType = this.putVertexInternal(Schema.MetaSchema.RELATION.getName(), Schema.BaseType.RELATION_TYPE);
            Vertex resourceType = this.putVertexInternal(Schema.MetaSchema.RESOURCE.getName(), Schema.BaseType.RESOURCE_TYPE);
            Vertex roleType = this.putVertexInternal(Schema.MetaSchema.ROLE.getName(), Schema.BaseType.ROLE_TYPE);
            Vertex ruleType = this.putVertexInternal(Schema.MetaSchema.RULE.getName(), Schema.BaseType.RULE_TYPE);
            Vertex inferenceRuleType = this.putVertexInternal(Schema.MetaSchema.INFERENCE_RULE.getName(), Schema.BaseType.RULE_TYPE);
            Vertex constraintRuleType = this.putVertexInternal(Schema.MetaSchema.CONSTRAINT_RULE.getName(), Schema.BaseType.RULE_TYPE);
            relationType.property(Schema.ConceptProperty.IS_ABSTRACT.name(), (Object)true);
            roleType.property(Schema.ConceptProperty.IS_ABSTRACT.name(), (Object)true);
            resourceType.property(Schema.ConceptProperty.IS_ABSTRACT.name(), (Object)true);
            ruleType.property(Schema.ConceptProperty.IS_ABSTRACT.name(), (Object)true);
            entityType.property(Schema.ConceptProperty.IS_ABSTRACT.name(), (Object)true);
            relationType.addEdge(Schema.EdgeLabel.SUB.getLabel(), type, new Object[0]);
            roleType.addEdge(Schema.EdgeLabel.SUB.getLabel(), type, new Object[0]);
            resourceType.addEdge(Schema.EdgeLabel.SUB.getLabel(), type, new Object[0]);
            ruleType.addEdge(Schema.EdgeLabel.SUB.getLabel(), type, new Object[0]);
            entityType.addEdge(Schema.EdgeLabel.SUB.getLabel(), type, new Object[0]);
            inferenceRuleType.addEdge(Schema.EdgeLabel.SUB.getLabel(), ruleType, new Object[0]);
            constraintRuleType.addEdge(Schema.EdgeLabel.SUB.getLabel(), ruleType, new Object[0]);
            return true;
        }
        return false;
    }

    private boolean isMetaOntologyNotInitialised() {
        return this.getMetaConcept() == null;
    }

    public G getTinkerPopGraph() {
        if (this.isClosed()) {
            String reason = this.localClosedReason.get();
            if (reason == null) {
                throw new GraphRuntimeException(ErrorMessage.GRAPH_CLOSED.getMessage(new Object[]{this.getKeyspace()}));
            }
            throw new GraphRuntimeException(reason);
        }
        return this.graph;
    }

    public GraphTraversal<Vertex, Vertex> getTinkerTraversal() {
        ReadOnlyStrategy readOnlyStrategy = ReadOnlyStrategy.instance();
        return this.getTinkerPopGraph().traversal().asBuilder().with((TraversalStrategy)readOnlyStrategy).create(this.getTinkerPopGraph()).V(new Object[0]);
    }

    public QueryBuilder graql() {
        return new QueryBuilderImpl((GraknGraph)this);
    }

    public ElementFactory getElementFactory() {
        return this.elementFactory;
    }

    private EdgeImpl addEdge(Concept from, Concept to, Schema.EdgeLabel type) {
        return ((ConceptImpl)from).addEdge((ConceptImpl)to, type);
    }

    public <T extends Concept> T getConcept(Schema.ConceptProperty key, String value) {
        GraphTraversal vertices = this.getTinkerTraversal().has(key.name(), (Object)value);
        if (vertices.hasNext()) {
            Vertex vertex = (Vertex)vertices.next();
            if (!this.isBatchLoadingEnabled() && vertices.hasNext()) {
                throw new MoreThanOneConceptException(ErrorMessage.TOO_MANY_CONCEPTS.getMessage(new Object[]{key.name(), value}));
            }
            return (T)this.elementFactory.buildConcept(vertex);
        }
        return null;
    }

    public Set<ConceptImpl> getConcepts(Schema.ConceptProperty key, Object value) {
        HashSet<ConceptImpl> concepts = new HashSet<ConceptImpl>();
        this.getTinkerTraversal().has(key.name(), value).forEachRemaining(v -> concepts.add((ConceptImpl)this.elementFactory.buildConcept((Vertex)v)));
        return concepts;
    }

    public ConceptLog getConceptLog() {
        ConceptLog conceptLog = this.localConceptLog.get();
        if (conceptLog == null) {
            conceptLog = new ConceptLog();
            this.localConceptLog.set(conceptLog);
        }
        return conceptLog;
    }

    void checkOntologyMutation() {
        if (this.isBatchLoadingEnabled()) {
            throw new GraphRuntimeException(ErrorMessage.SCHEMA_LOCKED.getMessage(new Object[0]));
        }
    }

    Vertex addVertex(Schema.BaseType baseType) {
        Vertex vertex = this.getTinkerPopGraph().addVertex(baseType.name());
        vertex.property(Schema.ConceptProperty.ID.name(), (Object)vertex.id().toString());
        return vertex;
    }

    private Vertex putVertex(String name, Schema.BaseType baseType) {
        if (Schema.MetaSchema.isMetaName((String)name)) {
            throw new ConceptException(ErrorMessage.ID_RESERVED.getMessage(new Object[]{name}));
        }
        return this.putVertexInternal(name, baseType);
    }

    private Vertex putVertexInternal(String name, Schema.BaseType baseType) {
        Vertex vertex;
        ConceptImpl concept = (ConceptImpl)this.getConcept(Schema.ConceptProperty.NAME, name);
        if (concept == null) {
            vertex = this.addVertex(baseType);
            vertex.property(Schema.ConceptProperty.NAME.name(), (Object)name);
        } else {
            if (!baseType.name().equals(concept.getBaseType())) {
                throw new ConceptNotUniqueException((Concept)concept, name);
            }
            vertex = concept.getVertex();
        }
        return vertex;
    }

    public EntityType putEntityType(String name) {
        return this.putType(name, Schema.BaseType.ENTITY_TYPE, (Type)this.getMetaEntityType()).asEntityType();
    }

    private TypeImpl putType(String name, Schema.BaseType baseType, Type metaType) {
        this.checkOntologyMutation();
        return this.elementFactory.buildSpecificType(this.putVertex(name, baseType), metaType);
    }

    public RelationType putRelationType(String name) {
        return this.putType(name, Schema.BaseType.RELATION_TYPE, (Type)this.getMetaRelationType()).asRelationType();
    }

    RelationType putRelationTypeImplicit(String itemIdentifier) {
        Vertex v = this.putVertex(itemIdentifier, Schema.BaseType.RELATION_TYPE);
        return this.elementFactory.buildRelationType(v, this.getMetaRelationType(), Boolean.TRUE);
    }

    public RoleType putRoleType(String name) {
        return this.putType(name, Schema.BaseType.ROLE_TYPE, (Type)this.getMetaRoleType()).asRoleType();
    }

    RoleType putRoleTypeImplicit(String itemIdentifier) {
        Vertex v = this.putVertex(itemIdentifier, Schema.BaseType.ROLE_TYPE);
        return this.elementFactory.buildRoleType(v, this.getMetaRoleType(), Boolean.TRUE);
    }

    public <V> ResourceType<V> putResourceType(String name, ResourceType.DataType<V> dataType) {
        return this.elementFactory.buildResourceType(this.putType(name, Schema.BaseType.RESOURCE_TYPE, (Type)this.getMetaResourceType()).getVertex(), this.getMetaResourceType(), dataType, false);
    }

    public <V> ResourceType<V> putResourceTypeUnique(String name, ResourceType.DataType<V> dataType) {
        return this.elementFactory.buildResourceType(this.putType(name, Schema.BaseType.RESOURCE_TYPE, (Type)this.getMetaResourceType()).getVertex(), this.getMetaResourceType(), dataType, true);
    }

    public RuleType putRuleType(String name) {
        return this.putType(name, Schema.BaseType.RULE_TYPE, (Type)this.getMetaRuleType()).asRuleType();
    }

    private <T extends Concept> T validConceptOfType(Concept concept, Class type) {
        if (concept != null && type.isInstance(concept)) {
            return (T)concept;
        }
        return null;
    }

    public <T extends Concept> T getConceptByBaseIdentifier(Object baseIdentifier) {
        GraphTraversal traversal = this.getTinkerPopGraph().traversal().V(new Object[]{baseIdentifier});
        if (traversal.hasNext()) {
            return (T)this.elementFactory.buildConcept((Vertex)traversal.next());
        }
        return null;
    }

    public <T extends Concept> T getConcept(ConceptId id) {
        return this.getConcept(Schema.ConceptProperty.ID, id.getValue());
    }

    private <T extends Type> T getTypeByName(String name) {
        return (T)((Type)this.getConcept(Schema.ConceptProperty.NAME, name));
    }

    public <V> Collection<Resource<V>> getResourcesByValue(V value) {
        HashSet resources = new HashSet();
        ResourceType.DataType dataType = (ResourceType.DataType)ResourceType.DataType.SUPPORTED_TYPES.get(value.getClass().getTypeName());
        this.getConcepts(dataType.getConceptProperty(), value).forEach(concept -> {
            if (concept != null && concept.isResource()) {
                Object resource = this.validConceptOfType((Concept)concept, ResourceImpl.class);
                resources.add(resource.asResource());
            }
        });
        return resources;
    }

    public Type getType(String name) {
        return (Type)this.validConceptOfType((Concept)this.getTypeByName(name), TypeImpl.class);
    }

    public EntityType getEntityType(String name) {
        return (EntityType)this.validConceptOfType((Concept)this.getTypeByName(name), EntityTypeImpl.class);
    }

    public RelationType getRelationType(String name) {
        return (RelationType)this.validConceptOfType((Concept)this.getTypeByName(name), RelationTypeImpl.class);
    }

    public <V> ResourceType<V> getResourceType(String name) {
        return (ResourceType)this.validConceptOfType((Concept)this.getTypeByName(name), ResourceTypeImpl.class);
    }

    public RoleType getRoleType(String name) {
        return (RoleType)this.validConceptOfType((Concept)this.getTypeByName(name), RoleTypeImpl.class);
    }

    public RuleType getRuleType(String name) {
        return (RuleType)this.validConceptOfType((Concept)this.getTypeByName(name), RuleTypeImpl.class);
    }

    public Type getMetaConcept() {
        return this.getTypeByName(Schema.MetaSchema.CONCEPT.getName());
    }

    public RelationType getMetaRelationType() {
        return (RelationType)this.getTypeByName(Schema.MetaSchema.RELATION.getName());
    }

    public RoleType getMetaRoleType() {
        return (RoleType)this.getTypeByName(Schema.MetaSchema.ROLE.getName());
    }

    public ResourceType getMetaResourceType() {
        return (ResourceType)this.getTypeByName(Schema.MetaSchema.RESOURCE.getName());
    }

    public EntityType getMetaEntityType() {
        return (EntityType)this.getTypeByName(Schema.MetaSchema.ENTITY.getName());
    }

    public RuleType getMetaRuleType() {
        return (RuleType)this.getTypeByName(Schema.MetaSchema.RULE.getName());
    }

    public RuleType getMetaRuleInference() {
        return this.getTypeByName(Schema.MetaSchema.INFERENCE_RULE.getName()).asRuleType();
    }

    public RuleType getMetaRuleConstraint() {
        return this.getTypeByName(Schema.MetaSchema.CONSTRAINT_RULE.getName()).asRuleType();
    }

    private CastingImpl addCasting(RoleTypeImpl role, InstanceImpl rolePlayer) {
        CastingImpl casting = this.elementFactory.buildCasting(this.addVertex(Schema.BaseType.CASTING), role).setHash(role, rolePlayer);
        if (rolePlayer != null) {
            EdgeImpl castingToRolePlayer = this.addEdge(casting, rolePlayer, Schema.EdgeLabel.ROLE_PLAYER);
            castingToRolePlayer.setProperty(Schema.EdgeProperty.ROLE_TYPE, role.getId().getValue());
        }
        return casting;
    }

    CastingImpl putCasting(RoleTypeImpl role, InstanceImpl rolePlayer, RelationImpl relation) {
        CastingImpl foundCasting = null;
        if (rolePlayer != null) {
            foundCasting = this.getCasting(role, rolePlayer);
        }
        if (foundCasting == null) {
            foundCasting = this.addCasting(role, rolePlayer);
        }
        EdgeImpl assertionToCasting = this.addEdge(relation, foundCasting, Schema.EdgeLabel.CASTING);
        assertionToCasting.setProperty(Schema.EdgeProperty.ROLE_TYPE, role.getId().getValue());
        this.putShortcutEdges(relation, (RelationType)relation.type());
        return foundCasting;
    }

    private CastingImpl getCasting(RoleTypeImpl role, InstanceImpl rolePlayer) {
        try {
            String hash = CastingImpl.generateNewHash(role, rolePlayer);
            ConceptImpl concept = (ConceptImpl)this.getConcept(Schema.ConceptProperty.INDEX, hash);
            if (concept != null) {
                return concept.asCasting();
            }
            return null;
        }
        catch (GraphRuntimeException e) {
            throw new MoreThanOneConceptException(ErrorMessage.TOO_MANY_CASTINGS.getMessage(new Object[]{role, rolePlayer}));
        }
    }

    private void putShortcutEdges(Relation relation, RelationType relationType) {
        Map roleMap = relation.rolePlayers();
        if (roleMap.size() > 1) {
            for (Map.Entry from : roleMap.entrySet()) {
                for (Map.Entry to : roleMap.entrySet()) {
                    if (from.getValue() == null || to.getValue() == null || from.getKey() == to.getKey()) continue;
                    this.putShortcutEdge(relation, relationType.asRelationType(), ((RoleType)from.getKey()).asRoleType(), ((Instance)from.getValue()).asInstance(), ((RoleType)to.getKey()).asRoleType(), ((Instance)to.getValue()).asInstance());
                }
            }
        }
    }

    private void putShortcutEdge(Relation relation, RelationType relationType, RoleType fromRole, Instance from, RoleType toRole, Instance to) {
        InstanceImpl fromRolePlayer = (InstanceImpl)from;
        InstanceImpl toRolePlayer = (InstanceImpl)to;
        String hash = this.calculateShortcutHash(relation, relationType, fromRole, fromRolePlayer, toRole, toRolePlayer);
        boolean exists = this.getTinkerPopGraph().traversal().V(new Object[]{fromRolePlayer.getBaseIdentifier()}).local((Traversal)__.outE((String[])new String[]{Schema.EdgeLabel.SHORTCUT.getLabel()}).has(Schema.EdgeProperty.SHORTCUT_HASH.name(), (Object)hash)).hasNext();
        if (!exists) {
            EdgeImpl edge = this.addEdge(fromRolePlayer, toRolePlayer, Schema.EdgeLabel.SHORTCUT);
            edge.setProperty(Schema.EdgeProperty.RELATION_TYPE_NAME, relationType.getName());
            edge.setProperty(Schema.EdgeProperty.RELATION_ID, relation.getId().getValue());
            if (fromRolePlayer.getId() != null) {
                edge.setProperty(Schema.EdgeProperty.FROM_ID, fromRolePlayer.getId().getValue());
            }
            edge.setProperty(Schema.EdgeProperty.FROM_ROLE_NAME, fromRole.getName());
            if (toRolePlayer.getId() != null) {
                edge.setProperty(Schema.EdgeProperty.TO_ID, toRolePlayer.getId().getValue());
            }
            edge.setProperty(Schema.EdgeProperty.TO_ROLE_NAME, toRole.getName());
            edge.setProperty(Schema.EdgeProperty.FROM_TYPE_NAME, fromRolePlayer.type().getName());
            edge.setProperty(Schema.EdgeProperty.TO_TYPE_NAME, toRolePlayer.type().getName());
            edge.setProperty(Schema.EdgeProperty.SHORTCUT_HASH, hash);
        }
    }

    private String calculateShortcutHash(Relation relation, RelationType relationType, RoleType fromRole, Instance fromRolePlayer, RoleType toRole, Instance toRolePlayer) {
        String hash = "";
        String relationIdValue = relationType.getId().getValue();
        String fromIdValue = fromRolePlayer.getId().getValue();
        String fromRoleValue = fromRole.getId().getValue();
        String toIdValue = toRolePlayer.getId().getValue();
        String toRoleValue = toRole.getId().getValue();
        String assertionIdValue = relation.getId().getValue();
        if (relationIdValue != null) {
            hash = hash + relationIdValue;
        }
        if (fromIdValue != null) {
            hash = hash + fromIdValue;
        }
        if (fromRoleValue != null) {
            hash = hash + fromRoleValue;
        }
        if (toIdValue != null) {
            hash = hash + toIdValue;
        }
        if (toRoleValue != null) {
            hash = hash + toRoleValue;
        }
        hash = hash + String.valueOf(assertionIdValue);
        return hash;
    }

    public Relation getRelation(RelationType relationType, Map<RoleType, Instance> roleMap) {
        String hash = RelationImpl.generateNewHash(relationType, roleMap);
        RelationImpl concept = this.getConceptLog().getCachedRelation(hash);
        if (concept == null) {
            concept = this.getConcept(Schema.ConceptProperty.INDEX, hash);
        }
        if (concept == null) {
            return null;
        }
        return concept.asRelation();
    }

    public void rollback() {
        try {
            this.getTinkerPopGraph().tx().rollback();
        }
        catch (UnsupportedOperationException e) {
            throw new UnsupportedOperationException(ErrorMessage.UNSUPPORTED_GRAPH.getMessage(new Object[]{this.getTinkerPopGraph().getClass().getName(), "rollback"}));
        }
        this.getConceptLog().clearTransaction();
    }

    public void clear() {
        EngineCommunicator.contactEngine(this.getCommitLogEndPoint(), "DELETE");
        this.clearGraph();
        this.finaliseClose(this::closePermanent, ErrorMessage.CLOSED_CLEAR.getMessage(new Object[0]));
    }

    protected void clearGraph() {
        this.getTinkerPopGraph().traversal().V(new Object[0]).drop().iterate();
    }

    public void close() {
        this.getConceptLog().clearTransaction();
        this.closeGraph(ErrorMessage.CLOSED_USER.getMessage(new Object[0]));
    }

    public void open() {
        this.localIsOpen.set(true);
        this.localClosedReason.remove();
        this.getTinkerPopGraph();
    }

    public void closeGraph(String closedReason) {
        this.finaliseClose(this::closePermanent, closedReason);
    }

    public void finaliseClose(Runnable closer, String closedReason) {
        if (!this.isClosed()) {
            closer.run();
            this.localClosedReason.set(closedReason);
            this.localIsOpen.set(false);
        }
    }

    public void closePermanent() {
        try {
            this.graph.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void commit() throws GraknValidationException {
        this.commit(true);
    }

    public void commit(boolean submitLogs) throws GraknValidationException {
        this.validateGraph();
        HashMap<Schema.BaseType, Set<String>> modifiedConcepts = new HashMap<Schema.BaseType, Set<String>>();
        Set<String> castings = this.getConceptLog().getModifiedCastingIds();
        Set<String> resources = this.getConceptLog().getModifiedResourceIds();
        if (castings.size() > 0) {
            modifiedConcepts.put(Schema.BaseType.CASTING, castings);
        }
        if (resources.size() > 0) {
            modifiedConcepts.put(Schema.BaseType.RESOURCE, resources);
        }
        this.LOG.debug("Graph is valid. Committing graph . . . ");
        this.commitTx();
        this.LOG.debug("Graph committed.");
        this.getConceptLog().clearTransaction();
        if (submitLogs && modifiedConcepts.size() > 0) {
            this.submitCommitLogs(modifiedConcepts);
        }
    }

    protected void commitTx() {
        try {
            this.getTinkerPopGraph().tx().commit();
        }
        catch (UnsupportedOperationException e) {
            this.LOG.warn(ErrorMessage.TRANSACTIONS_NOT_SUPPORTED.getMessage(new Object[]{this.graph.getClass().getName()}));
        }
        this.committed = true;
    }

    void validateGraph() throws GraknValidationException {
        Validator validator = new Validator(this);
        if (!validator.validate()) {
            List<String> errors = validator.getErrorsFound();
            String error = ErrorMessage.VALIDATION.getMessage(new Object[]{errors.size()});
            for (String s : errors) {
                error = error + s;
            }
            throw new GraknValidationException(error);
        }
    }

    private void submitCommitLogs(Map<Schema.BaseType, Set<String>> concepts) {
        JSONArray jsonArray = new JSONArray();
        for (Map.Entry<Schema.BaseType, Set<String>> entry : concepts.entrySet()) {
            Schema.BaseType type = entry.getKey();
            for (String vertexId : entry.getValue()) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("id", (Object)vertexId);
                jsonObject.put("type", (Object)type.name());
                jsonArray.put((Object)jsonObject);
            }
        }
        JSONObject postObject = new JSONObject();
        postObject.put("concepts", (Object)jsonArray);
        String result = EngineCommunicator.contactEngine(this.getCommitLogEndPoint(), "POST", postObject.toString());
        this.LOG.debug("Response from engine [" + result + "]");
    }

    private String getCommitLogEndPoint() {
        if ("in-memory".equals(this.engine)) {
            return "in-memory";
        }
        return this.engine + "/commit_log" + "?" + "keyspace" + "=" + this.keyspace;
    }

    public boolean fixDuplicateCasting(Object castingId) {
        ConceptImpl concept = (ConceptImpl)this.getConceptByBaseIdentifier(castingId);
        if (concept == null || !concept.isCasting()) {
            return false;
        }
        CastingImpl casting = concept.asCasting();
        InstanceImpl rolePlayer = casting.getRolePlayer();
        RoleType role = casting.getRole();
        List castingVertices = this.getTinkerPopGraph().traversal().V(new Object[]{rolePlayer.getBaseIdentifier()}).inE(new String[]{Schema.EdgeLabel.ROLE_PLAYER.getLabel()}).has(Schema.EdgeProperty.ROLE_TYPE.name(), (Object)role.getId()).otherV().toList();
        Set<CastingImpl> castings = castingVertices.stream().map(this.elementFactory::buildConcept).collect(Collectors.toSet());
        if (castings.size() < 2) {
            return false;
        }
        castings.remove(casting);
        Set<RelationImpl> duplicateRelations = this.mergeCastings(casting, castings);
        this.deleteRelations(duplicateRelations);
        return true;
    }

    private void deleteRelations(Set<RelationImpl> relations) {
        for (RelationImpl relation : relations) {
            String relationID = relation.getId().getValue();
            relation.rolePlayers().values().forEach(instance -> {
                if (instance != null) {
                    List edges = this.getTinkerTraversal().hasId(new Object[]{instance.getId().getValue()}).bothE(new String[]{Schema.EdgeLabel.SHORTCUT.getLabel()}).has(Schema.EdgeProperty.RELATION_ID.name(), (Object)relationID).toList();
                    edges.forEach(Element::remove);
                }
            });
            relation.deleteNode();
        }
    }

    private Set<RelationImpl> mergeCastings(CastingImpl mainCasting, Set<CastingImpl> castings) {
        RoleType role = mainCasting.getRole();
        Set<RelationImpl> relations = mainCasting.getRelations();
        HashSet<RelationImpl> relationsToClean = new HashSet<RelationImpl>();
        for (CastingImpl otherCasting : castings) {
            for (RelationImpl otherRelation : otherCasting.getRelations()) {
                boolean transferEdge = true;
                for (Relation relation : relations) {
                    if (!this.relationsEqual(relation, otherRelation)) continue;
                    relationsToClean.add(otherRelation);
                    transferEdge = false;
                    break;
                }
                if (!transferEdge) continue;
                EdgeImpl assertionToCasting = this.addEdge(otherRelation, mainCasting, Schema.EdgeLabel.CASTING);
                assertionToCasting.setProperty(Schema.EdgeProperty.ROLE_TYPE, role.getId().getValue());
            }
            ((Vertex)this.getTinkerPopGraph().traversal().V(new Object[]{otherCasting.getBaseIdentifier()}).next()).remove();
        }
        return relationsToClean;
    }

    private boolean relationsEqual(Relation mainRelation, Relation otherRelation) {
        return mainRelation.rolePlayers().equals(otherRelation.rolePlayers()) && mainRelation.type().equals(otherRelation.type());
    }

    public boolean fixDuplicateResources(Set<Object> resourceIds) {
        boolean commitRequired = false;
        HashSet<ResourceImpl> resources = new HashSet<ResourceImpl>();
        for (Object resourceId : resourceIds) {
            ConceptImpl concept = (ConceptImpl)this.getConceptByBaseIdentifier(resourceId);
            if (concept == null || !concept.isResource()) continue;
            resources.add((ResourceImpl)concept);
        }
        Map<String, Set<ResourceImpl>> resourceMap = this.formatResourcesByType(resources);
        for (Map.Entry<String, Set<ResourceImpl>> entry : resourceMap.entrySet()) {
            Set<ResourceImpl> dups = entry.getValue();
            if (dups.size() <= 1) continue;
            this.mergeResources(dups);
            commitRequired = true;
        }
        return commitRequired;
    }

    private Map<String, Set<ResourceImpl>> formatResourcesByType(Set<ResourceImpl> resources) {
        HashMap<String, Set<ResourceImpl>> resourceMap = new HashMap<String, Set<ResourceImpl>>();
        resources.forEach(resource -> {
            String resourceKey = resource.getProperty(Schema.ConceptProperty.INDEX).toString();
            resourceMap.computeIfAbsent(resourceKey, key -> new HashSet()).add(resource);
        });
        return resourceMap;
    }

    private void mergeResources(Set<ResourceImpl> resources) {
        Iterator<ResourceImpl> it = resources.iterator();
        ResourceImpl mainResource = it.next();
        while (it.hasNext()) {
            ResourceImpl otherResource = it.next();
            Collection<Relation> otherRelations = otherResource.relations(new RoleType[0]);
            for (Relation otherRelation : otherRelations) {
                this.copyRelation(mainResource, otherResource, otherRelation);
            }
            otherResource.delete();
        }
    }

    private void copyRelation(Instance main, Instance other, Relation otherRelation) {
        RelationType relationType = otherRelation.type();
        Map rolePlayers = otherRelation.rolePlayers();
        for (RoleType roleType : rolePlayers.keySet()) {
            if (!((Instance)rolePlayers.get(roleType)).equals(other)) continue;
            rolePlayers.put(roleType, main);
        }
        Relation foundRelation = this.getRelation(relationType, rolePlayers);
        this.deleteRelations(Collections.singleton((RelationImpl)otherRelation));
        if (foundRelation != null) {
            return;
        }
        Relation relation = relationType.addRelation();
        rolePlayers.entrySet().forEach(entry -> relation.putRolePlayer((RoleType)entry.getKey(), (Instance)entry.getValue()));
    }
}

