/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graph.internal;

import ai.grakn.concept.RoleType;
import ai.grakn.exception.NoEdgeException;
import ai.grakn.graph.internal.AbstractGraknGraph;
import ai.grakn.graph.internal.InstanceImpl;
import ai.grakn.graph.internal.RelationImpl;
import ai.grakn.graph.internal.RoleTypeImpl;
import ai.grakn.util.Schema;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.structure.Vertex;

class CastingImpl
extends InstanceImpl<CastingImpl, RoleType> {
    CastingImpl(AbstractGraknGraph graknGraph, Vertex v, Optional<RoleType> type) {
        super(graknGraph, v, type);
    }

    public RoleType getRole() {
        Object concept = this.type();
        if (concept != null) {
            return concept.asRoleType();
        }
        throw new NoEdgeException(this.toString(), Schema.BaseType.ROLE_TYPE.name());
    }

    public InstanceImpl getRolePlayer() {
        Object concept = this.getOutgoingNeighbour(Schema.EdgeLabel.ROLE_PLAYER);
        if (concept != null) {
            return (InstanceImpl)concept;
        }
        return null;
    }

    public CastingImpl setHash(RoleTypeImpl role, InstanceImpl rolePlayer) {
        String hash = this.getGraknGraph().isBatchLoadingEnabled() ? "CastingBaseId_" + this.getBaseIdentifier() + UUID.randomUUID().toString() : CastingImpl.generateNewHash(role, rolePlayer);
        this.setUniqueProperty(Schema.ConceptProperty.INDEX, hash);
        return this;
    }

    public static String generateNewHash(RoleTypeImpl role, InstanceImpl rolePlayer) {
        return "Casting-Role-" + role.getId() + "-RolePlayer-" + rolePlayer.getId();
    }

    public Set<RelationImpl> getRelations() {
        CastingImpl thisRef = this;
        HashSet<RelationImpl> relations = new HashSet<RelationImpl>();
        Set concepts = thisRef.getIncomingNeighbours(Schema.EdgeLabel.CASTING);
        if (concepts.size() > 0) {
            relations.addAll(concepts.stream().map(concept -> (RelationImpl)concept).collect(Collectors.toList()));
        }
        return relations;
    }
}

