/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graph.internal;

import ai.grakn.concept.Concept;
import ai.grakn.concept.ConceptId;
import ai.grakn.concept.Entity;
import ai.grakn.concept.EntityType;
import ai.grakn.concept.Instance;
import ai.grakn.concept.Relation;
import ai.grakn.concept.RelationType;
import ai.grakn.concept.Resource;
import ai.grakn.concept.ResourceType;
import ai.grakn.concept.RoleType;
import ai.grakn.concept.Rule;
import ai.grakn.concept.RuleType;
import ai.grakn.concept.Type;
import ai.grakn.exception.ConceptException;
import ai.grakn.exception.ConceptNotUniqueException;
import ai.grakn.exception.InvalidConceptTypeException;
import ai.grakn.exception.InvalidConceptValueException;
import ai.grakn.exception.MoreThanOneEdgeException;
import ai.grakn.graph.internal.AbstractGraknGraph;
import ai.grakn.graph.internal.CastingImpl;
import ai.grakn.graph.internal.EdgeImpl;
import ai.grakn.util.ErrorMessage;
import ai.grakn.util.Schema;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;

abstract class ConceptImpl<T extends Concept, V extends Type>
implements Concept {
    private final AbstractGraknGraph graknGraph;
    private Vertex vertex;

    T getThis() {
        return (T)this;
    }

    ConceptImpl(AbstractGraknGraph graknGraph, Vertex v) {
        this.vertex = v;
        this.graknGraph = graknGraph;
    }

    private T setProperty(String key, Object value) {
        if (value == null) {
            this.vertex.property(key).remove();
        } else {
            VertexProperty foundProperty = this.vertex.property(key);
            if (foundProperty.isPresent() && foundProperty.value().equals(value)) {
                return this.getThis();
            }
            this.vertex.property(key, value);
        }
        return this.getThis();
    }

    public void delete() throws ConceptException {
        ConceptImpl properType = (ConceptImpl)this.getGraknGraph().getElementFactory().buildConcept(this.vertex);
        properType.innerDelete();
    }

    void innerDelete() {
        this.deleteNode();
    }

    T setUniqueProperty(Schema.ConceptProperty key, String id) {
        if (this.graknGraph.isBatchLoadingEnabled() || this.updateAllowed(key, id)) {
            return this.setProperty(key, (Object)id);
        }
        throw new ConceptNotUniqueException((Concept)this, key, id);
    }

    private boolean updateAllowed(Schema.ConceptProperty key, String value) {
        Object fetchedConcept = this.graknGraph.getConcept(key, value);
        return fetchedConcept == null || this.equals(fetchedConcept);
    }

    void deleteNode() {
        this.vertex.edges(Direction.BOTH, new String[0]).forEachRemaining(e -> {
            this.graknGraph.getConceptLog().putConcept((ConceptImpl)this.getGraknGraph().getElementFactory().buildConcept(e.inVertex()));
            this.graknGraph.getConceptLog().putConcept((ConceptImpl)this.getGraknGraph().getElementFactory().buildConcept(e.outVertex()));
        });
        this.graknGraph.getConceptLog().removeConcept(this);
        this.vertex.remove();
        this.vertex = null;
    }

    private <E extends Concept> E castConcept(Class<E> type) {
        try {
            return (E)((Concept)type.cast(this));
        }
        catch (ClassCastException e) {
            throw new InvalidConceptTypeException(ErrorMessage.INVALID_OBJECT_TYPE.getMessage(new Object[]{this, type}));
        }
    }

    public Type asType() {
        return this.castConcept(Type.class);
    }

    public Instance asInstance() {
        return this.castConcept(Instance.class);
    }

    public EntityType asEntityType() {
        return this.castConcept(EntityType.class);
    }

    public RoleType asRoleType() {
        return this.castConcept(RoleType.class);
    }

    public RelationType asRelationType() {
        return this.castConcept(RelationType.class);
    }

    public <D> ResourceType<D> asResourceType() {
        return this.castConcept(ResourceType.class);
    }

    public RuleType asRuleType() {
        return this.castConcept(RuleType.class);
    }

    public Entity asEntity() {
        return this.castConcept(Entity.class);
    }

    public Relation asRelation() {
        return this.castConcept(Relation.class);
    }

    public <D> Resource<D> asResource() {
        return this.castConcept(Resource.class);
    }

    public Rule asRule() {
        return this.castConcept(Rule.class);
    }

    public CastingImpl asCasting() {
        return (CastingImpl)this;
    }

    public boolean isType() {
        return this instanceof Type;
    }

    public boolean isInstance() {
        return this instanceof Instance;
    }

    public boolean isEntityType() {
        return this instanceof EntityType;
    }

    public boolean isRoleType() {
        return this instanceof RoleType;
    }

    public boolean isRelationType() {
        return this instanceof RelationType;
    }

    public boolean isResourceType() {
        return this instanceof ResourceType;
    }

    public boolean isRuleType() {
        return this instanceof RuleType;
    }

    public boolean isEntity() {
        return this instanceof Entity;
    }

    public boolean isRelation() {
        return this instanceof Relation;
    }

    public boolean isResource() {
        return this instanceof Resource;
    }

    public boolean isRule() {
        return this instanceof Rule;
    }

    public boolean isCasting() {
        return this instanceof CastingImpl;
    }

    protected <X extends Concept> X getOutgoingNeighbour(Schema.EdgeLabel edgeLabel) {
        Set<X> concepts = this.getOutgoingNeighbours(edgeLabel);
        if (concepts.size() == 1) {
            return (X)((Concept)concepts.iterator().next());
        }
        if (concepts.isEmpty()) {
            return null;
        }
        throw new MoreThanOneEdgeException((Concept)this, edgeLabel);
    }

    protected <X extends Concept> Set<X> getOutgoingNeighbours(Schema.EdgeLabel edgeType) {
        HashSet outgoingNeighbours = new HashSet();
        this.getEdgesOfType(Direction.OUT, edgeType).forEach(edge -> {
            Object found = edge.getTarget();
            if (found != null) {
                outgoingNeighbours.add(found);
            }
        });
        return outgoingNeighbours;
    }

    protected <X extends Concept> Set<X> getIncomingNeighbours(Schema.EdgeLabel edgeType) {
        HashSet incomingNeighbours = new HashSet();
        this.getEdgesOfType(Direction.IN, edgeType).forEach(edge -> {
            Object found = edge.getSource();
            if (found != null) {
                incomingNeighbours.add(found);
            }
        });
        return incomingNeighbours;
    }

    T setProperty(Schema.ConceptProperty key, Object value) {
        return this.setProperty(key.name(), value);
    }

    public <X> X getProperty(Schema.ConceptProperty key) {
        VertexProperty property = this.vertex.property(key.name());
        if (property != null && property.isPresent()) {
            return (X)property.value();
        }
        return null;
    }

    public Boolean getPropertyBoolean(Schema.ConceptProperty key) {
        Boolean value = (Boolean)this.getProperty(key);
        if (value == null) {
            return false;
        }
        return value;
    }

    Vertex getVertex() {
        return this.vertex;
    }

    public T setType(String type) {
        return this.setProperty(Schema.ConceptProperty.TYPE, (Object)type);
    }

    public Object getBaseIdentifier() {
        return this.vertex.id();
    }

    public String getBaseType() {
        return this.vertex.label();
    }

    public ConceptId getId() {
        return ConceptId.of((String)((String)this.getProperty(Schema.ConceptProperty.ID)));
    }

    public String getType() {
        return (String)this.getProperty(Schema.ConceptProperty.TYPE);
    }

    protected Set<EdgeImpl> getEdgesOfType(Direction direction, Schema.EdgeLabel type) {
        HashSet<EdgeImpl> edges = new HashSet<EdgeImpl>();
        this.vertex.edges(direction, new String[]{type.getLabel()}).forEachRemaining(e -> edges.add(new EdgeImpl((Edge)e, this.getGraknGraph())));
        return edges;
    }

    public EdgeImpl getEdgeOutgoingOfType(Schema.EdgeLabel type) {
        Set<EdgeImpl> edges = this.getEdgesOfType(Direction.OUT, type);
        if (edges.size() == 1) {
            return edges.iterator().next();
        }
        if (edges.size() > 1) {
            throw new MoreThanOneEdgeException((Concept)this, type);
        }
        return null;
    }

    protected AbstractGraknGraph getGraknGraph() {
        return this.graknGraph;
    }

    EdgeImpl putEdge(Concept to, Schema.EdgeLabel type) {
        ConceptImpl toConcept = (ConceptImpl)to;
        GraphTraversal traversal = this.graknGraph.getTinkerPopGraph().traversal().V(new Object[]{this.getBaseIdentifier()}).outE(new String[]{type.getLabel()}).as("edge", new String[0]).otherV().hasId(new Object[]{toConcept.getBaseIdentifier()}).select("edge");
        if (!traversal.hasNext()) {
            return this.addEdge(toConcept, type);
        }
        return this.graknGraph.getElementFactory().buildEdge((Edge)traversal.next(), this.graknGraph);
    }

    public EdgeImpl addEdge(ConceptImpl toConcept, Schema.EdgeLabel type) {
        EdgeImpl newEdge = this.getGraknGraph().getElementFactory().buildEdge(toConcept.addEdgeFrom(this.vertex, type.getLabel()), this.graknGraph);
        this.graknGraph.getConceptLog().putConcept(this);
        this.graknGraph.getConceptLog().putConcept(toConcept);
        return newEdge;
    }

    void deleteEdges(Direction direction, Schema.EdgeLabel type) {
        this.vertex.edges(direction, new String[]{type.getLabel()}).forEachRemaining(e -> {
            this.graknGraph.getConceptLog().putConcept((ConceptImpl)this.getGraknGraph().getElementFactory().buildConcept(e.inVertex()));
            this.graknGraph.getConceptLog().putConcept((ConceptImpl)this.getGraknGraph().getElementFactory().buildConcept(e.outVertex()));
        });
        this.vertex.edges(direction, new String[]{type.getLabel()}).forEachRemaining(Element::remove);
    }

    void deleteEdgeTo(Schema.EdgeLabel type, Concept toConcept) {
        GraphTraversal traversal = this.graknGraph.getTinkerPopGraph().traversal().V(new Object[]{this.getBaseIdentifier()}).outE(new String[]{type.getLabel()}).as("edge", new String[0]).otherV().hasId(new Object[]{((ConceptImpl)toConcept).getBaseIdentifier()}).select("edge");
        if (traversal.hasNext()) {
            ((Edge)traversal.next()).remove();
        }
    }

    private Edge addEdgeFrom(Vertex fromVertex, String type) {
        return fromVertex.addEdge(type, this.vertex, new Object[0]);
    }

    public int hashCode() {
        return this.vertex.hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof ConceptImpl && ((ConceptImpl)object).getVertex().equals(this.vertex);
    }

    public String toString() {
        String message = "[Base Type [" + this.getBaseType() + "] ";
        if (this.getId() != null) {
            message = message + "- Id [" + this.getId() + "] ";
        }
        return message;
    }

    boolean isAlive() {
        if (this.vertex == null) {
            return false;
        }
        try {
            return this.vertex.property(Schema.ConceptProperty.ID.name()).isPresent();
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    <X> void setImmutableProperty(Schema.ConceptProperty conceptProperty, X newValue, X foundValue, Function<X, Object> converter) {
        if (newValue == null) {
            throw new InvalidConceptValueException(ErrorMessage.NULL_VALUE.getMessage(new Object[]{conceptProperty.name()}));
        }
        if (foundValue != null) {
            if (!foundValue.equals(newValue)) {
                throw new InvalidConceptValueException(ErrorMessage.IMMUTABLE_VALUE.getMessage(new Object[]{foundValue, this, newValue, conceptProperty.name()}));
            }
        } else {
            this.setProperty(conceptProperty, converter.apply(newValue));
        }
    }

    public int compareTo(Concept o) {
        return this.getId().compareTo(o.getId());
    }
}

