/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graph.internal;

import ai.grakn.concept.RelationType;
import ai.grakn.graph.internal.CastingImpl;
import ai.grakn.graph.internal.ConceptImpl;
import ai.grakn.graph.internal.RelationImpl;
import ai.grakn.graph.internal.ResourceImpl;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ConceptLog {
    private Set<ConceptImpl> modifiedConcepts;
    private final Set<CastingImpl> modifiedCastings = new HashSet<CastingImpl>();
    private final Set<ResourceImpl> modifiedResources;
    private final Map<String, RelationImpl> modifiedRelations;

    ConceptLog() {
        this.modifiedConcepts = new HashSet<ConceptImpl>();
        this.modifiedResources = new HashSet<ResourceImpl>();
        this.modifiedRelations = new HashMap<String, RelationImpl>();
    }

    public void clearTransaction() {
        this.modifiedConcepts.clear();
        this.modifiedCastings.clear();
        this.modifiedResources.clear();
        this.modifiedRelations.clear();
    }

    public void putConcept(ConceptImpl concept) {
        if (!this.modifiedConcepts.contains(concept)) {
            this.modifiedConcepts.add(concept);
            if (concept.isCasting()) {
                this.modifiedCastings.add(concept.asCasting());
            }
            if (concept.isResource()) {
                this.modifiedResources.add((ResourceImpl)concept);
            }
        }
        if (concept.isRelation()) {
            RelationImpl relation = (RelationImpl)concept;
            this.modifiedRelations.put(RelationImpl.generateNewHash((RelationType)relation.type(), relation.rolePlayers()), relation);
        }
    }

    public Set<ConceptImpl> getModifiedConcepts() {
        this.modifiedConcepts = this.modifiedConcepts.stream().filter(c -> c != null && c.isAlive()).collect(Collectors.toSet());
        return this.modifiedConcepts;
    }

    public Set<String> getModifiedCastingIds() {
        return this.modifiedCastings.stream().filter(ConceptImpl::isAlive).map(concept -> concept.getBaseIdentifier().toString()).collect(Collectors.toSet());
    }

    public Set<String> getModifiedResourceIds() {
        return this.modifiedResources.stream().filter(ConceptImpl::isAlive).map(concept -> concept.getBaseIdentifier().toString()).collect(Collectors.toSet());
    }

    public void removeConcept(ConceptImpl c) {
        this.modifiedConcepts.remove(c);
        this.modifiedCastings.remove(c);
        this.modifiedResources.remove(c);
    }

    public RelationImpl getCachedRelation(String index) {
        return this.modifiedRelations.get(index);
    }
}

