/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graph.internal;

import ai.grakn.concept.Concept;
import ai.grakn.graph.internal.AbstractGraknGraph;
import ai.grakn.graph.internal.ConceptImpl;
import ai.grakn.util.Schema;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Property;

class EdgeImpl {
    private Edge edge;
    private final AbstractGraknGraph graknGraph;

    EdgeImpl(Edge e, AbstractGraknGraph graknGraph) {
        this.edge = e;
        this.graknGraph = graknGraph;
    }

    public void delete() {
        this.graknGraph.getConceptLog().putConcept((ConceptImpl)this.getTarget());
        this.graknGraph.getConceptLog().putConcept((ConceptImpl)this.getSource());
        this.edge.remove();
        this.edge = null;
    }

    public int hashCode() {
        return this.edge.hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof EdgeImpl && ((EdgeImpl)object).edgeEquals(this.edge);
    }

    public <X extends Concept> X getSource() {
        return this.graknGraph.getElementFactory().buildConcept(this.edge.outVertex());
    }

    public <X extends Concept> X getTarget() {
        return this.graknGraph.getElementFactory().buildConcept(this.edge.inVertex());
    }

    public Schema.EdgeLabel getType() {
        return Schema.EdgeLabel.getEdgeLabel((String)this.edge.label());
    }

    <X> X getProperty(Schema.EdgeProperty type) {
        Property property = this.edge.property(type.name());
        if (property != null && property.isPresent()) {
            return (X)property.value();
        }
        return null;
    }

    Boolean getPropertyBoolean(Schema.EdgeProperty key) {
        Boolean value = (Boolean)this.getProperty(key);
        if (value == null) {
            return false;
        }
        return value;
    }

    void setProperty(Schema.EdgeProperty type, String value) {
        this.edge.property(type.name(), (Object)value);
    }

    void setProperty(Schema.EdgeProperty type, boolean value) {
        this.edge.property(type.name(), (Object)value);
    }

    private boolean edgeEquals(Edge toEdge) {
        return this.edge.equals(toEdge);
    }
}

