/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graph.internal;

import ai.grakn.concept.Concept;
import ai.grakn.concept.EntityType;
import ai.grakn.concept.RelationType;
import ai.grakn.concept.ResourceType;
import ai.grakn.concept.RoleType;
import ai.grakn.concept.RuleType;
import ai.grakn.concept.Type;
import ai.grakn.exception.InvalidConceptValueException;
import ai.grakn.graph.internal.AbstractGraknGraph;
import ai.grakn.graph.internal.CastingImpl;
import ai.grakn.graph.internal.ConceptImpl;
import ai.grakn.graph.internal.EdgeImpl;
import ai.grakn.graph.internal.EntityImpl;
import ai.grakn.graph.internal.EntityTypeImpl;
import ai.grakn.graph.internal.RelationImpl;
import ai.grakn.graph.internal.RelationTypeImpl;
import ai.grakn.graph.internal.ResourceImpl;
import ai.grakn.graph.internal.ResourceTypeImpl;
import ai.grakn.graph.internal.RoleTypeImpl;
import ai.grakn.graph.internal.RuleImpl;
import ai.grakn.graph.internal.RuleTypeImpl;
import ai.grakn.graph.internal.TypeImpl;
import ai.grakn.graql.Pattern;
import ai.grakn.util.ErrorMessage;
import ai.grakn.util.Schema;
import java.util.Optional;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ElementFactory {
    private final Logger LOG = LoggerFactory.getLogger(ElementFactory.class);
    private final AbstractGraknGraph graknGraph;

    ElementFactory(AbstractGraknGraph graknGraph) {
        this.graknGraph = graknGraph;
    }

    CastingImpl buildCasting(Vertex v, RoleType type) {
        return this.buildCasting(v, Optional.of(type));
    }

    private CastingImpl buildCasting(Vertex v, Optional<RoleType> type) {
        return this.trackConcept(new CastingImpl(this.graknGraph, v, type));
    }

    private TypeImpl buildType(Vertex v, Optional<Type> type, Optional<Boolean> isImplicit) {
        return this.trackConcept(new TypeImpl(this.graknGraph, v, type, isImplicit));
    }

    <V> ResourceTypeImpl<V> buildResourceType(Vertex v, ResourceType<V> type, ResourceType.DataType<V> dataType, Boolean isUnique) {
        return this.buildResourceType(v, Optional.of(type), Optional.of(dataType), Optional.of(isUnique));
    }

    private <V> ResourceTypeImpl<V> buildResourceType(Vertex v, Optional<ResourceType<V>> type, Optional<ResourceType.DataType<V>> dataType, Optional<Boolean> isUnique) {
        return this.trackConcept(new ResourceTypeImpl(this.graknGraph, v, type, dataType, isUnique));
    }

    <V> ResourceImpl<V> buildResource(Vertex v, ResourceType<V> type, V value) {
        return this.buildResource(v, Optional.of(type), Optional.of(value));
    }

    private <V> ResourceImpl<V> buildResource(Vertex v, Optional<ResourceType<V>> type, Optional<V> value) {
        return this.trackConcept(new ResourceImpl(this.graknGraph, v, type, value));
    }

    RelationTypeImpl buildRelationType(Vertex v, RelationType type, Boolean isImplicit) {
        return this.buildRelationType(v, Optional.of(type), Optional.of(isImplicit));
    }

    private RelationTypeImpl buildRelationType(Vertex v, Optional<RelationType> type, Optional<Boolean> isImplicit) {
        return this.trackConcept(new RelationTypeImpl(this.graknGraph, v, type, isImplicit));
    }

    RelationImpl buildRelation(Vertex v, RelationType type) {
        return this.buildRelation(v, Optional.of(type));
    }

    private RelationImpl buildRelation(Vertex v, Optional<RelationType> type) {
        return this.trackConcept(new RelationImpl(this.graknGraph, v, type));
    }

    private EntityTypeImpl buildEntityType(Vertex v, Optional<EntityType> type) {
        return this.trackConcept(new EntityTypeImpl(this.graknGraph, v, type));
    }

    EntityImpl buildEntity(Vertex v, EntityType type) {
        return this.buildEntity(v, Optional.of(type));
    }

    private EntityImpl buildEntity(Vertex v, Optional<EntityType> type) {
        return this.trackConcept(new EntityImpl(this.graknGraph, v, type));
    }

    private RuleTypeImpl buildRuleType(Vertex v, Optional<RuleType> type) {
        return this.trackConcept(new RuleTypeImpl(this.graknGraph, v, type));
    }

    RuleImpl buildRule(Vertex v, RuleType type, Pattern lhs, Pattern rhs) {
        if (lhs == null) {
            throw new InvalidConceptValueException(ErrorMessage.NULL_VALUE.getMessage(new Object[]{Schema.ConceptProperty.RULE_LHS.name()}));
        }
        if (rhs == null) {
            throw new InvalidConceptValueException(ErrorMessage.NULL_VALUE.getMessage(new Object[]{Schema.ConceptProperty.RULE_RHS.name()}));
        }
        return this.trackConcept(this.buildRule(v, Optional.of(type), Optional.of(lhs), Optional.of(rhs)));
    }

    private RuleImpl buildRule(Vertex v, Optional<RuleType> type, Optional<Pattern> lhs, Optional<Pattern> rhs) {
        return this.trackConcept(new RuleImpl(this.graknGraph, v, type, lhs, rhs));
    }

    RoleTypeImpl buildRoleType(Vertex v, RoleType type, Boolean isImplicit) {
        return this.buildRoleType(v, Optional.of(type), Optional.of(isImplicit));
    }

    private RoleTypeImpl buildRoleType(Vertex v, Optional<RoleType> type, Optional<Boolean> isImplicit) {
        return this.trackConcept(new RoleTypeImpl(this.graknGraph, v, type, isImplicit));
    }

    <X extends Concept> X buildConcept(Vertex v) {
        Schema.BaseType type;
        try {
            type = Schema.BaseType.valueOf((String)v.label());
        }
        catch (IllegalArgumentException e) {
            this.LOG.warn("Found vertex [" + v + "] which has an invalid base type [" + v.label() + "] ignoring . . . ");
            return null;
        }
        ConceptImpl concept = null;
        switch (type) {
            case RELATION: {
                concept = this.buildRelation(v, Optional.empty());
                break;
            }
            case CASTING: {
                concept = this.buildCasting(v, Optional.empty());
                break;
            }
            case TYPE: {
                concept = this.buildType(v, Optional.empty(), Optional.empty());
                break;
            }
            case ROLE_TYPE: {
                concept = this.buildRoleType(v, Optional.empty(), Optional.empty());
                break;
            }
            case RELATION_TYPE: {
                concept = this.buildRelationType(v, Optional.empty(), Optional.empty());
                break;
            }
            case ENTITY: {
                concept = this.buildEntity(v, Optional.empty());
                break;
            }
            case ENTITY_TYPE: {
                concept = this.buildEntityType(v, Optional.empty());
                break;
            }
            case RESOURCE_TYPE: {
                concept = this.buildResourceType(v, Optional.empty(), Optional.empty(), Optional.empty());
                break;
            }
            case RESOURCE: {
                concept = this.buildResource(v, Optional.empty(), Optional.empty());
                break;
            }
            case RULE: {
                concept = this.buildRule(v, Optional.empty(), Optional.empty(), Optional.empty());
                break;
            }
            case RULE_TYPE: {
                concept = this.buildRuleType(v, Optional.empty());
            }
        }
        return (X)concept;
    }

    TypeImpl buildSpecificType(Vertex vertex, Type type) {
        TypeImpl conceptType;
        Schema.BaseType baseType = Schema.BaseType.valueOf((String)vertex.label());
        switch (baseType) {
            case ROLE_TYPE: {
                conceptType = this.buildRoleType(vertex, Optional.of(type.asRoleType()), Optional.empty());
                break;
            }
            case RELATION_TYPE: {
                conceptType = this.buildRelationType(vertex, Optional.of(type.asRelationType()), Optional.empty());
                break;
            }
            case RESOURCE_TYPE: {
                conceptType = this.buildResourceType(vertex, Optional.of(type.asResourceType()), Optional.empty(), Optional.empty());
                break;
            }
            case RULE_TYPE: {
                conceptType = this.buildRuleType(vertex, Optional.of(type.asRuleType()));
                break;
            }
            case ENTITY_TYPE: {
                conceptType = this.buildEntityType(vertex, Optional.of(type.asEntityType()));
                break;
            }
            default: {
                conceptType = this.buildType(vertex, Optional.of(type), Optional.empty());
            }
        }
        return conceptType;
    }

    public EdgeImpl buildEdge(Edge edge, AbstractGraknGraph graknGraph) {
        return new EdgeImpl(edge, graknGraph);
    }

    private <X extends ConceptImpl> X trackConcept(X concept) {
        this.graknGraph.getConceptLog().putConcept(concept);
        return concept;
    }
}

