/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graph.internal;

import ai.grakn.GraknComputer;
import ai.grakn.util.ErrorMessage;
import java.util.concurrent.ExecutionException;
import org.apache.tinkerpop.gremlin.process.computer.ComputerResult;
import org.apache.tinkerpop.gremlin.process.computer.GraphComputer;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;
import org.apache.tinkerpop.gremlin.structure.Graph;

public class GraknComputerImpl
implements GraknComputer {
    private final Graph graph;
    private final Class<? extends GraphComputer> graphComputer;

    public GraknComputerImpl(Graph graph, String graphComputerType) {
        this.graph = graph;
        this.graphComputer = this.getGraphComputer(graphComputerType);
    }

    public ComputerResult compute(VertexProgram program, MapReduce ... mapReduces) {
        try {
            GraphComputer graphComputer = this.getComputer().program(program);
            for (MapReduce mapReduce : mapReduces) {
                graphComputer = graphComputer.mapReduce(mapReduce);
            }
            return (ComputerResult)graphComputer.submit().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw this.asRuntimeException(e);
        }
    }

    public ComputerResult compute(MapReduce mapReduce) {
        try {
            return (ComputerResult)this.getComputer().mapReduce(mapReduce).submit().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw this.asRuntimeException(e);
        }
    }

    private RuntimeException asRuntimeException(Throwable throwable) {
        Throwable cause = throwable.getCause();
        if (cause instanceof RuntimeException) {
            return (RuntimeException)cause;
        }
        return new RuntimeException(cause);
    }

    protected Class<? extends GraphComputer> getGraphComputer(String graphComputerType) {
        try {
            return Class.forName(graphComputerType);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(ErrorMessage.INVALID_COMPUTER.getMessage(new Object[]{graphComputerType}));
        }
    }

    protected GraphComputer getComputer() {
        return this.graph.compute(this.graphComputer);
    }
}

