/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graph.internal;

import ai.grakn.concept.Concept;
import ai.grakn.concept.Instance;
import ai.grakn.concept.Relation;
import ai.grakn.concept.RelationType;
import ai.grakn.concept.Resource;
import ai.grakn.concept.ResourceType;
import ai.grakn.concept.RoleType;
import ai.grakn.concept.Type;
import ai.grakn.exception.ConceptException;
import ai.grakn.exception.InvalidConceptTypeException;
import ai.grakn.graph.internal.AbstractGraknGraph;
import ai.grakn.graph.internal.CastingImpl;
import ai.grakn.graph.internal.ConceptImpl;
import ai.grakn.graph.internal.RelationImpl;
import ai.grakn.util.ErrorMessage;
import ai.grakn.util.Schema;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.structure.Vertex;

abstract class InstanceImpl<T extends Instance, V extends Type>
extends ConceptImpl<T, V>
implements Instance {
    InstanceImpl(AbstractGraknGraph graknGraph, Vertex v, Optional<V> type) {
        super(graknGraph, v);
        type.ifPresent(this::type);
    }

    @Override
    public void innerDelete() {
        InstanceImpl parent = this;
        Set<CastingImpl> castings = parent.castings();
        this.deleteNode();
        for (CastingImpl casting : castings) {
            Set<RelationImpl> relations = casting.getRelations();
            this.getGraknGraph().getConceptLog().putConcept(casting);
            for (RelationImpl relation : relations) {
                this.getGraknGraph().getConceptLog().putConcept(relation);
                relation.cleanUp();
            }
            casting.deleteNode();
        }
    }

    public String getIndex() {
        return (String)this.getProperty(Schema.ConceptProperty.INDEX);
    }

    public Collection<Resource<?>> resources(ResourceType ... resourceTypes) {
        Set resourceTypesIds = Arrays.stream(resourceTypes).map(Concept::getId).collect(Collectors.toSet());
        HashSet resources = new HashSet();
        this.getOutgoingNeighbours(Schema.EdgeLabel.SHORTCUT).forEach(concept -> {
            if (concept.isResource()) {
                Resource resource = concept.asResource();
                if (resourceTypesIds.isEmpty() || resourceTypesIds.contains(resource.type().getId())) {
                    resources.add(resource);
                }
            }
        });
        return resources;
    }

    public Set<CastingImpl> castings() {
        HashSet<CastingImpl> castings = new HashSet<CastingImpl>();
        this.getIncomingNeighbours(Schema.EdgeLabel.ROLE_PLAYER).forEach(casting -> castings.add((CastingImpl)casting));
        return castings;
    }

    public Collection<Relation> relations(RoleType ... roleTypes) {
        HashSet<Relation> relations = new HashSet<Relation>();
        Set roleTypeNames = Arrays.stream(roleTypes).map(Type::getName).collect(Collectors.toSet());
        InstanceImpl parent = this;
        parent.castings().forEach(c -> {
            CastingImpl casting = c.asCasting();
            if (roleTypeNames.size() != 0) {
                if (roleTypeNames.contains(casting.getType())) {
                    relations.addAll(casting.getRelations());
                }
            } else {
                relations.addAll(casting.getRelations());
            }
        });
        return relations;
    }

    public Collection<RoleType> playsRoles() {
        HashSet<RoleType> roleTypes = new HashSet<RoleType>();
        InstanceImpl parent = this;
        parent.getIncomingNeighbours(Schema.EdgeLabel.ROLE_PLAYER).forEach(c -> roleTypes.add(((CastingImpl)c).getRole()));
        return roleTypes;
    }

    public Relation hasResource(Resource resource) {
        String name = resource.type().getName();
        RelationType hasResource = this.getGraknGraph().getRelationType(Schema.Resource.HAS_RESOURCE.getName(name));
        RoleType hasResourceTarget = this.getGraknGraph().getRoleType(Schema.Resource.HAS_RESOURCE_OWNER.getName(name));
        RoleType hasResourceValue = this.getGraknGraph().getRoleType(Schema.Resource.HAS_RESOURCE_VALUE.getName(name));
        if (hasResource == null || hasResourceTarget == null || hasResourceValue == null) {
            throw new ConceptException(ErrorMessage.HAS_RESOURCE_INVALID.getMessage(new Object[]{this.type().getName(), resource.type().getName()}));
        }
        Relation relation = hasResource.addRelation();
        relation.putRolePlayer(hasResourceTarget, (Instance)this);
        relation.putRolePlayer(hasResourceValue, (Instance)resource);
        return relation;
    }

    protected T type(V type) {
        if (type != null && this.type() == null) {
            V currentIsa = this.type();
            if (currentIsa == null) {
                this.setType(String.valueOf(type.getName()));
                this.putEdge((Concept)type, Schema.EdgeLabel.ISA);
            } else if (!currentIsa.equals(type)) {
                throw new InvalidConceptTypeException(ErrorMessage.IMMUTABLE_TYPE.getMessage(new Object[]{this, type, currentIsa}));
            }
        }
        return (T)((Instance)this.getThis());
    }

    public V type() {
        return (V)((Type)this.getOutgoingNeighbour(Schema.EdgeLabel.ISA));
    }
}

