/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graph.internal;

import ai.grakn.concept.Concept;
import ai.grakn.concept.Instance;
import ai.grakn.concept.Relation;
import ai.grakn.concept.RelationType;
import ai.grakn.concept.Resource;
import ai.grakn.concept.RoleType;
import ai.grakn.exception.ConceptException;
import ai.grakn.exception.ConceptNotUniqueException;
import ai.grakn.graph.internal.AbstractGraknGraph;
import ai.grakn.graph.internal.CastingImpl;
import ai.grakn.graph.internal.ConceptImpl;
import ai.grakn.graph.internal.EdgeImpl;
import ai.grakn.graph.internal.InstanceImpl;
import ai.grakn.graph.internal.RoleTypeImpl;
import ai.grakn.util.ErrorMessage;
import ai.grakn.util.Schema;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Vertex;

class RelationImpl
extends InstanceImpl<Relation, RelationType>
implements Relation {
    RelationImpl(AbstractGraknGraph graknGraph, Vertex v, Optional<RelationType> type) {
        super(graknGraph, v, type);
    }

    public Set<CastingImpl> getMappingCasting() {
        HashSet<CastingImpl> castings = new HashSet<CastingImpl>();
        this.getOutgoingNeighbours(Schema.EdgeLabel.CASTING).forEach(casting -> castings.add((CastingImpl)casting));
        return castings;
    }

    public void setHash() {
        this.setUniqueProperty(Schema.ConceptProperty.INDEX, RelationImpl.generateNewHash((RelationType)this.type(), this.rolePlayers()));
    }

    public static String generateNewHash(RelationType relationType, Map<RoleType, Instance> roleMap) {
        TreeSet<RoleType> sortedRoleIds = new TreeSet<RoleType>(roleMap.keySet());
        String hash = "RelationType_" + relationType.getId().getValue().replace("_", "\\_") + "_Relation";
        for (RoleType role : sortedRoleIds) {
            hash = hash + "_" + role.getId().getValue().replace("_", "\\_");
            Instance instance = roleMap.get(role);
            if (instance == null) continue;
            hash = hash + "_" + instance.getId().getValue().replace("_", "\\_");
        }
        return hash;
    }

    public Map<RoleType, Instance> rolePlayers() {
        Set<CastingImpl> castings = this.getMappingCasting();
        HashMap<RoleType, Instance> roleMap = new HashMap<RoleType, Instance>();
        ((RelationType)this.type()).hasRoles().forEach(roleType -> {
            Instance cfr_ignored_0 = roleMap.put((RoleType)roleType, (Instance)null);
        });
        castings.forEach(casting -> {
            Instance cfr_ignored_0 = roleMap.put(casting.getRole(), casting.getRolePlayer());
        });
        return roleMap;
    }

    public Set<Instance> scopes() {
        HashSet<Instance> scopes = new HashSet<Instance>();
        this.getOutgoingNeighbours(Schema.EdgeLabel.HAS_SCOPE).forEach(concept -> scopes.add(concept.asInstance()));
        return scopes;
    }

    public Relation scope(Instance instance) {
        this.putEdge((Concept)instance, Schema.EdgeLabel.HAS_SCOPE);
        return this;
    }

    public Relation putRolePlayer(RoleType roleType, Instance instance) {
        GraphTraversal traversal;
        Resource resource;
        if (roleType == null) {
            throw new IllegalArgumentException(ErrorMessage.ROLE_IS_NULL.getMessage(new Object[]{instance}));
        }
        if (instance != null && instance.isResource() && (resource = instance.asResource()).type().isUnique().booleanValue() && (traversal = this.getGraknGraph().getTinkerTraversal().hasId(new Object[]{resource.getId().getValue()}).out(new String[]{Schema.EdgeLabel.SHORTCUT.getLabel()})).hasNext()) {
            ConceptImpl foundNeighbour = (ConceptImpl)this.getGraknGraph().getElementFactory().buildConcept((Vertex)traversal.next());
            throw new ConceptNotUniqueException(resource, foundNeighbour.asInstance());
        }
        return this.addNewRolePlayer(roleType, instance);
    }

    private Relation addNewRolePlayer(RoleType roleType, Instance instance) {
        if (instance != null) {
            this.getGraknGraph().putCasting((RoleTypeImpl)roleType, (InstanceImpl)instance, this);
        }
        return this;
    }

    public Relation deleteScope(Instance scope) throws ConceptException {
        this.deleteEdgeTo(Schema.EdgeLabel.HAS_SCOPE, (Concept)scope);
        return this;
    }

    public void cleanUp() {
        boolean performDeletion = true;
        Collection<Instance> rolePlayers = this.rolePlayers().values();
        rolePlayers.forEach(r -> {
            if (r != null) {
                this.getGraknGraph().getConceptLog().putConcept((ConceptImpl)r);
            }
        });
        this.getMappingCasting().forEach(c -> this.getGraknGraph().getConceptLog().putConcept((ConceptImpl)c));
        for (Instance instance : rolePlayers) {
            if (instance == null || instance.getId() == null) continue;
            performDeletion = false;
        }
        if (performDeletion) {
            this.delete();
        }
    }

    @Override
    public void innerDelete() {
        this.scopes().forEach(this::deleteScope);
        Set<CastingImpl> castings = this.getMappingCasting();
        for (CastingImpl casting : castings) {
            InstanceImpl instance = casting.getRolePlayer();
            if (instance == null) continue;
            for (EdgeImpl edge : instance.getEdgesOfType(Direction.BOTH, Schema.EdgeLabel.SHORTCUT)) {
                if (!edge.getProperty(Schema.EdgeProperty.RELATION_ID).equals(this.getId().getValue())) continue;
                edge.delete();
            }
        }
        super.innerDelete();
    }

    @Override
    public String toString() {
        String description = "ID [" + this.getId() + "] Type [" + ((RelationType)this.type()).getName() + "] Roles and Role Players: \n";
        for (Map.Entry<RoleType, Instance> entry : this.rolePlayers().entrySet()) {
            if (entry.getValue() == null) {
                description = description + "    Role [" + entry.getKey().getName() + "] not played by any instance \n";
                continue;
            }
            description = description + "    Role [" + entry.getKey().getName() + "] played by [" + entry.getValue().getId() + "] \n";
        }
        return description;
    }
}

