/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graph.internal;

import ai.grakn.concept.Concept;
import ai.grakn.concept.Relation;
import ai.grakn.concept.RelationType;
import ai.grakn.concept.RoleType;
import ai.grakn.graph.internal.AbstractGraknGraph;
import ai.grakn.graph.internal.ConceptImpl;
import ai.grakn.graph.internal.RoleTypeImpl;
import ai.grakn.graph.internal.TypeImpl;
import ai.grakn.util.Schema;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import org.apache.tinkerpop.gremlin.structure.Vertex;

class RelationTypeImpl
extends TypeImpl<RelationType, Relation>
implements RelationType {
    RelationTypeImpl(AbstractGraknGraph graknGraph, Vertex v, Optional<RelationType> type, Optional<Boolean> isImplicit) {
        super(graknGraph, v, type, isImplicit);
    }

    public Relation addRelation() {
        return this.addInstance(Schema.BaseType.RELATION, (vertex, type) -> this.getGraknGraph().getElementFactory().buildRelation((Vertex)vertex, (RelationType)type));
    }

    public Collection<RoleType> hasRoles() {
        HashSet<RoleType> roleTypes = new HashSet<RoleType>();
        this.getOutgoingNeighbours(Schema.EdgeLabel.HAS_ROLE).forEach(role -> roleTypes.add(role.asRoleType()));
        return roleTypes;
    }

    public RelationType hasRole(RoleType roleType) {
        this.checkTypeMutation();
        this.putEdge((Concept)roleType, Schema.EdgeLabel.HAS_ROLE);
        return this;
    }

    public RelationType deleteHasRole(RoleType roleType) {
        this.checkTypeMutation();
        this.deleteEdgeTo(Schema.EdgeLabel.HAS_ROLE, (Concept)roleType);
        ((RoleTypeImpl)roleType).castings().forEach(casting -> this.getGraknGraph().getConceptLog().putConcept((ConceptImpl)casting));
        return this;
    }
}

