/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graph.internal;

import ai.grakn.concept.Instance;
import ai.grakn.concept.Resource;
import ai.grakn.concept.ResourceType;
import ai.grakn.exception.InvalidConceptValueException;
import ai.grakn.graph.internal.AbstractGraknGraph;
import ai.grakn.graph.internal.InstanceImpl;
import ai.grakn.util.ErrorMessage;
import ai.grakn.util.Schema;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.apache.tinkerpop.gremlin.structure.Vertex;

class ResourceImpl<D>
extends InstanceImpl<Resource<D>, ResourceType<D>>
implements Resource<D> {
    ResourceImpl(AbstractGraknGraph graknGraph, Vertex v, Optional<ResourceType<D>> type, Optional<D> value) {
        super(graknGraph, v, type);
        value.ifPresent(this::setValue);
    }

    public ResourceType.DataType<D> dataType() {
        return ((ResourceType)this.type()).getDataType();
    }

    public Collection<Instance> ownerInstances() {
        HashSet<Instance> owners = new HashSet<Instance>();
        this.getOutgoingNeighbours(Schema.EdgeLabel.SHORTCUT).forEach(concept -> {
            if (!concept.isResource()) {
                owners.add(concept.asInstance());
            }
        });
        return owners;
    }

    public Instance owner() {
        Collection<Instance> owners = this.ownerInstances();
        if (owners.isEmpty()) {
            return null;
        }
        return owners.iterator().next();
    }

    private Resource<D> setValue(D value) {
        try {
            ResourceType resourceType = (ResourceType)this.type();
            String regex = resourceType.getRegex();
            if (regex != null && !Pattern.matches(regex, (String)value)) {
                throw new InvalidConceptValueException(ErrorMessage.REGEX_INSTANCE_FAILURE.getMessage(new Object[]{regex, this.toString()}));
            }
            Schema.ConceptProperty property = this.dataType().getConceptProperty();
            this.setImmutableProperty(property, this.castValue(value), this.getProperty(property), Function.identity());
            return (Resource)this.setUniqueProperty(Schema.ConceptProperty.INDEX, ResourceImpl.generateResourceIndex((ResourceType)this.type(), value.toString()));
        }
        catch (ClassCastException e) {
            throw new InvalidConceptValueException(ErrorMessage.INVALID_DATATYPE.getMessage(new Object[]{value, this.dataType().getName()}));
        }
    }

    public static String generateResourceIndex(ResourceType resourceType, String value) {
        return Schema.BaseType.RESOURCE.name() + "-" + resourceType.getName() + "-" + value;
    }

    private Object castValue(Object value) {
        ResourceType.DataType<D> parentDataType = this.dataType();
        if (parentDataType.equals((Object)ResourceType.DataType.DOUBLE)) {
            return ((Number)value).doubleValue();
        }
        if (parentDataType.equals((Object)ResourceType.DataType.LONG)) {
            if (value instanceof Double) {
                throw new ClassCastException();
            }
            return ((Number)value).longValue();
        }
        try {
            return Class.forName(parentDataType.getName()).cast(value);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(ErrorMessage.INVALID_RESOURCE_CAST.getMessage(new Object[]{value, parentDataType.getName()}));
        }
    }

    public D getValue() {
        return (D)this.getProperty(this.dataType().getConceptProperty());
    }

    @Override
    public String toString() {
        return super.toString() + "- Value [" + this.getValue() + "] ";
    }
}

