/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graph.internal;

import ai.grakn.concept.Resource;
import ai.grakn.concept.ResourceType;
import ai.grakn.exception.InvalidConceptValueException;
import ai.grakn.graph.internal.AbstractGraknGraph;
import ai.grakn.graph.internal.ResourceImpl;
import ai.grakn.graph.internal.TypeImpl;
import ai.grakn.util.ErrorMessage;
import ai.grakn.util.Schema;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tinkerpop.gremlin.structure.Vertex;

class ResourceTypeImpl<D>
extends TypeImpl<ResourceType<D>, Resource<D>>
implements ResourceType<D> {
    ResourceTypeImpl(AbstractGraknGraph graknGraph, Vertex v, Optional<ResourceType<D>> type, Optional<ResourceType.DataType<D>> dataType, Optional<Boolean> isUnique) {
        super(graknGraph, v, type, Optional.empty());
        dataType.ifPresent(d -> this.setImmutableProperty(Schema.ConceptProperty.DATA_TYPE, d, this.getDataType(), ResourceType.DataType::getName));
        isUnique.ifPresent(u -> this.setImmutableProperty(Schema.ConceptProperty.IS_UNIQUE, u, this.getProperty(Schema.ConceptProperty.IS_UNIQUE), Function.identity()));
    }

    public ResourceType<D> setRegex(String regex) {
        if (!this.getDataType().equals((Object)ResourceType.DataType.STRING)) {
            throw new UnsupportedOperationException(ErrorMessage.REGEX_NOT_STRING.getMessage(new Object[]{this.toString()}));
        }
        if (regex != null) {
            Pattern pattern = Pattern.compile(regex);
            for (Resource resource : this.instances()) {
                String value = (String)resource.getValue();
                Matcher matcher = pattern.matcher(value);
                if (matcher.matches()) continue;
                throw new InvalidConceptValueException(ErrorMessage.REGEX_INSTANCE_FAILURE.getMessage(new Object[]{regex, resource.toString()}));
            }
        }
        return (ResourceType)this.setProperty(Schema.ConceptProperty.REGEX, regex);
    }

    public Resource<D> putResource(D value) {
        Resource resource = this.getResource(value);
        if (resource == null) {
            resource = this.addInstance(Schema.BaseType.RESOURCE, (vertex, type) -> this.getGraknGraph().getElementFactory().buildResource((Vertex)vertex, type, value));
        }
        return resource;
    }

    public <V> Resource<V> getResource(V value) {
        String index = ResourceImpl.generateResourceIndex(this, value.toString());
        Object concept = this.getGraknGraph().getConcept(Schema.ConceptProperty.INDEX, index);
        if (concept != null) {
            return concept.asResource();
        }
        return null;
    }

    public ResourceType.DataType<D> getDataType() {
        return (ResourceType.DataType)ResourceType.DataType.SUPPORTED_TYPES.get(this.getProperty(Schema.ConceptProperty.DATA_TYPE));
    }

    public String getRegex() {
        return (String)this.getProperty(Schema.ConceptProperty.REGEX);
    }

    public Boolean isUnique() {
        return (Boolean)this.getProperty(Schema.ConceptProperty.IS_UNIQUE);
    }
}

