/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graph.internal;

import ai.grakn.concept.Instance;
import ai.grakn.concept.RelationType;
import ai.grakn.concept.RoleType;
import ai.grakn.concept.Type;
import ai.grakn.exception.ConceptException;
import ai.grakn.graph.internal.AbstractGraknGraph;
import ai.grakn.graph.internal.CastingImpl;
import ai.grakn.graph.internal.ConceptImpl;
import ai.grakn.graph.internal.TypeImpl;
import ai.grakn.util.ErrorMessage;
import ai.grakn.util.Schema;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Vertex;

class RoleTypeImpl
extends TypeImpl<RoleType, Instance>
implements RoleType {
    RoleTypeImpl(AbstractGraknGraph graknGraph, Vertex v, Optional<RoleType> type, Optional<Boolean> isImplicit) {
        super(graknGraph, v, type, isImplicit);
    }

    public Collection<RelationType> relationTypes() {
        return this.getIncomingNeighbours(Schema.EdgeLabel.HAS_ROLE);
    }

    public Collection<Type> playedByTypes() {
        return this.getIncomingNeighbours(Schema.EdgeLabel.PLAYS_ROLE);
    }

    @Override
    public Collection<Instance> instances() {
        return Collections.emptyList();
    }

    public Set<CastingImpl> castings() {
        HashSet<CastingImpl> castings = new HashSet<CastingImpl>();
        this.getIncomingNeighbours(Schema.EdgeLabel.ISA).forEach(concept -> ((CastingImpl)concept).getRelations().forEach(relation -> this.getGraknGraph().getConceptLog().putConcept((ConceptImpl)relation)));
        return castings;
    }

    @Override
    public RoleType playsRole(RoleType roleType) {
        if (this.equals(roleType)) {
            throw new ConceptException(ErrorMessage.ROLE_TYPE_ERROR.getMessage(new Object[]{roleType.getName()}));
        }
        return (RoleType)super.playsRole(roleType, false);
    }

    @Override
    public void innerDelete() {
        boolean hasHasRoles = this.getVertex().edges(Direction.IN, new String[]{Schema.EdgeLabel.HAS_ROLE.getLabel()}).hasNext();
        boolean hasPlaysRoles = this.getVertex().edges(Direction.IN, new String[]{Schema.EdgeLabel.PLAYS_ROLE.getLabel()}).hasNext();
        if (hasHasRoles || hasPlaysRoles) {
            throw new ConceptException(ErrorMessage.CANNOT_DELETE.getMessage(new Object[]{this.getName()}));
        }
        super.innerDelete();
    }
}

