/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graph.internal;

import ai.grakn.concept.Concept;
import ai.grakn.concept.Rule;
import ai.grakn.concept.RuleType;
import ai.grakn.concept.Type;
import ai.grakn.graph.internal.AbstractGraknGraph;
import ai.grakn.graph.internal.InstanceImpl;
import ai.grakn.graql.Pattern;
import ai.grakn.util.Schema;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import org.apache.tinkerpop.gremlin.structure.Vertex;

class RuleImpl
extends InstanceImpl<Rule, RuleType>
implements Rule {
    RuleImpl(AbstractGraknGraph graknGraph, Vertex v, Optional<RuleType> type, Optional<Pattern> lhs, Optional<Pattern> rhs) {
        super(graknGraph, v, type);
        lhs.ifPresent(l -> this.setImmutableProperty(Schema.ConceptProperty.RULE_LHS, l, this.getLHS(), Object::toString));
        rhs.ifPresent(r -> this.setImmutableProperty(Schema.ConceptProperty.RULE_RHS, r, this.getRHS(), Object::toString));
    }

    public Rule setExpectation(boolean expectation) {
        this.setProperty(Schema.ConceptProperty.IS_EXPECTED, expectation);
        return (Rule)this.getThis();
    }

    public Rule setMaterialise(boolean materialise) {
        this.setProperty(Schema.ConceptProperty.IS_MATERIALISED, materialise);
        return (Rule)this.getThis();
    }

    public Pattern getLHS() {
        return this.parsePattern((String)this.getProperty(Schema.ConceptProperty.RULE_LHS));
    }

    public Pattern getRHS() {
        return this.parsePattern((String)this.getProperty(Schema.ConceptProperty.RULE_RHS));
    }

    private Pattern parsePattern(String value) {
        if (value == null) {
            return null;
        }
        return this.getGraknGraph().graql().parsePattern(value);
    }

    public Boolean getExpectation() {
        return this.getPropertyBoolean(Schema.ConceptProperty.IS_EXPECTED);
    }

    public Boolean isMaterialise() {
        return this.getPropertyBoolean(Schema.ConceptProperty.IS_MATERIALISED);
    }

    public Rule addHypothesis(Type type) {
        this.putEdge((Concept)type, Schema.EdgeLabel.HYPOTHESIS);
        return (Rule)this.getThis();
    }

    public Rule addConclusion(Type type) {
        this.putEdge((Concept)type, Schema.EdgeLabel.CONCLUSION);
        return (Rule)this.getThis();
    }

    public Collection<Type> getHypothesisTypes() {
        HashSet<Type> types = new HashSet<Type>();
        this.getOutgoingNeighbours(Schema.EdgeLabel.HYPOTHESIS).forEach(concept -> types.add(concept.asType()));
        return types;
    }

    public Collection<Type> getConclusionTypes() {
        HashSet<Type> types = new HashSet<Type>();
        this.getOutgoingNeighbours(Schema.EdgeLabel.CONCLUSION).forEach(concept -> types.add(concept.asType()));
        return types;
    }
}

