/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graph.internal;

import ai.grakn.concept.Concept;
import ai.grakn.concept.Instance;
import ai.grakn.concept.RelationType;
import ai.grakn.concept.ResourceType;
import ai.grakn.concept.RoleType;
import ai.grakn.concept.Rule;
import ai.grakn.concept.Type;
import ai.grakn.exception.ConceptException;
import ai.grakn.graph.internal.AbstractGraknGraph;
import ai.grakn.graph.internal.ConceptImpl;
import ai.grakn.graph.internal.EdgeImpl;
import ai.grakn.graph.internal.InstanceImpl;
import ai.grakn.graph.internal.ResourceTypeImpl;
import ai.grakn.util.ErrorMessage;
import ai.grakn.util.Schema;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Vertex;

class TypeImpl<T extends Type, V extends Instance>
extends ConceptImpl<T, Type>
implements Type {
    TypeImpl(AbstractGraknGraph graknGraph, Vertex v, Optional<T> superType, Optional<Boolean> isImplicit) {
        super(graknGraph, v);
        superType.ifPresent(this::superType);
        isImplicit.ifPresent(i -> this.setImmutableProperty(Schema.ConceptProperty.IS_IMPLICIT, i, this.getProperty(Schema.ConceptProperty.IS_IMPLICIT), Function.identity()));
    }

    protected V addInstance(Schema.BaseType instanceBaseType, BiFunction<Vertex, T, V> producer) {
        Vertex instanceVertex = this.getGraknGraph().addVertex(instanceBaseType);
        return (V)((Instance)producer.apply(instanceVertex, (Vertex)this.getThis()));
    }

    public Collection<RoleType> playsRoles() {
        HashSet allRoleTypes = new HashSet();
        this.getSuperSet().forEach(type -> allRoleTypes.addAll(((TypeImpl)type).getOutgoingNeighbours(Schema.EdgeLabel.PLAYS_ROLE)));
        return this.filterImplicitStructures(allRoleTypes);
    }

    private <X extends Concept> Set<X> filterImplicitStructures(Set<X> types) {
        if (!this.getGraknGraph().implicitConceptsVisible() && !types.isEmpty() && ((Concept)types.iterator().next()).isType()) {
            return types.stream().filter(t -> t.asType().isImplicit() == false).collect(Collectors.toSet());
        }
        return types;
    }

    @Override
    public void innerDelete() {
        boolean hasSubs = this.getVertex().edges(Direction.IN, new String[]{Schema.EdgeLabel.SUB.getLabel()}).hasNext();
        boolean hasInstances = this.getVertex().edges(Direction.IN, new String[]{Schema.EdgeLabel.ISA.getLabel()}).hasNext();
        if (hasSubs || hasInstances) {
            throw new ConceptException(ErrorMessage.CANNOT_DELETE.getMessage(new Object[]{this.getName()}));
        }
        this.deleteNode();
    }

    public T superType() {
        Type concept = (Type)this.getOutgoingNeighbour(Schema.EdgeLabel.SUB);
        if (concept == null) {
            return null;
        }
        return (T)concept;
    }

    Set<T> getSuperSet() {
        HashSet<T> superSet = new HashSet<T>();
        superSet.add(this.getThis());
        for (Object superParent = this.superType(); superParent != null && !Schema.MetaSchema.CONCEPT.getName().equals(superParent.getName()); superParent = superParent.superType()) {
            if (superSet.contains(superParent)) {
                throw new ConceptException(ErrorMessage.LOOP_DETECTED.getMessage(new Object[]{this.toString(), Schema.EdgeLabel.SUB.getLabel()}));
            }
            superSet.add(superParent);
        }
        return superSet;
    }

    private Set<T> nextSubLevel(TypeImpl<?, ?> root) {
        HashSet<TypeImpl<Object, Object>> results = new HashSet<TypeImpl<Object, Object>>();
        results.add(root);
        Collection<TypeImpl<Type, Instance>> children = super.getSubConceptTypes();
        for (TypeImpl<Type, Instance> child : children) {
            results.addAll(this.nextSubLevel(child));
        }
        return results;
    }

    public Collection<T> subTypes() {
        return this.filterImplicitStructures(this.nextSubLevel(this));
    }

    private Collection<TypeImpl<Type, Instance>> getSubConceptTypes() {
        HashSet<TypeImpl<Type, Instance>> subSet = new HashSet<TypeImpl<Type, Instance>>();
        this.getIncomingNeighbours(Schema.EdgeLabel.SUB).forEach(subSet::add);
        return subSet;
    }

    public Collection<V> instances() {
        HashSet instances = new HashSet();
        GraphTraversal traversal = this.getGraknGraph().getTinkerPopGraph().traversal().V(new Object[0]).has(Schema.ConceptProperty.NAME.name(), (Object)this.getName()).union(new Traversal[]{__.identity(), __.repeat((Traversal)__.in((String[])new String[]{Schema.EdgeLabel.SUB.getLabel()})).emit()}).unfold().in(new String[]{Schema.EdgeLabel.ISA.getLabel()});
        traversal.forEachRemaining(vertex -> {
            ConceptImpl concept = (ConceptImpl)this.getGraknGraph().getElementFactory().buildConcept((Vertex)vertex);
            if (!concept.isCasting()) {
                instances.add((Instance)concept);
            }
        });
        return this.filterImplicitStructures(instances);
    }

    public Boolean isAbstract() {
        return this.getPropertyBoolean(Schema.ConceptProperty.IS_ABSTRACT);
    }

    public Boolean isImplicit() {
        return this.getPropertyBoolean(Schema.ConceptProperty.IS_IMPLICIT);
    }

    public Collection<Rule> getRulesOfHypothesis() {
        HashSet<Rule> rules = new HashSet<Rule>();
        this.getIncomingNeighbours(Schema.EdgeLabel.HYPOTHESIS).forEach(concept -> rules.add(concept.asRule()));
        return rules;
    }

    public Collection<Rule> getRulesOfConclusion() {
        HashSet<Rule> rules = new HashSet<Rule>();
        this.getIncomingNeighbours(Schema.EdgeLabel.CONCLUSION).forEach(concept -> rules.add(concept.asRule()));
        return rules;
    }

    public T superType(T superType) {
        this.checkTypeMutation();
        T currentSuperType = this.superType();
        if (currentSuperType == null || !currentSuperType.equals(superType) && !Schema.MetaSchema.isMetaName((String)superType.getName())) {
            this.deleteEdges(Direction.OUT, Schema.EdgeLabel.SUB);
            this.deleteEdges(Direction.OUT, Schema.EdgeLabel.ISA);
            this.putEdge((Concept)superType, Schema.EdgeLabel.SUB);
            this.checkForLoop(Schema.EdgeLabel.SUB);
            this.instances().forEach(concept -> {
                if (concept.isInstance()) {
                    ((InstanceImpl)concept).castings().forEach(instance -> this.getGraknGraph().getConceptLog().putConcept((ConceptImpl)instance));
                }
            });
        }
        return (T)((Type)this.getThis());
    }

    public T subType(T type) {
        ((TypeImpl)type).superType(this);
        return (T)((Type)this.getThis());
    }

    private void checkForLoop(Schema.EdgeLabel edge) {
        HashSet<T> foundTypes = new HashSet<T>();
        Object currentSuperType = this.superType();
        while (currentSuperType != null) {
            foundTypes.add(currentSuperType);
            if (!foundTypes.contains(currentSuperType = currentSuperType.superType())) continue;
            throw new ConceptException(ErrorMessage.LOOP_DETECTED.getMessage(new Object[]{this.toString(), edge.getLabel()}));
        }
    }

    T playsRole(RoleType roleType, boolean required) {
        this.checkTypeMutation();
        EdgeImpl edge = this.putEdge((Concept)roleType, Schema.EdgeLabel.PLAYS_ROLE);
        if (required) {
            edge.setProperty(Schema.EdgeProperty.REQUIRED, true);
        }
        return (T)((Type)this.getThis());
    }

    public T playsRole(RoleType roleType) {
        return this.playsRole(roleType, false);
    }

    public T deletePlaysRole(RoleType roleType) {
        this.checkTypeMutation();
        this.deleteEdgeTo(Schema.EdgeLabel.PLAYS_ROLE, (Concept)roleType);
        this.instances().forEach(concept -> {
            if (concept.isInstance()) {
                ((InstanceImpl)concept).castings().forEach(casting -> this.getGraknGraph().getConceptLog().putConcept((ConceptImpl)casting));
            }
        });
        return (T)((Type)this.getThis());
    }

    @Override
    public String toString() {
        String message = super.toString();
        message = message + " - Name [" + this.getName() + "] - Abstract [" + this.isAbstract() + "] ";
        return message;
    }

    public T setAbstract(Boolean isAbstract) {
        this.checkTypeMutation();
        this.setProperty(Schema.ConceptProperty.IS_ABSTRACT, isAbstract);
        if (isAbstract.booleanValue()) {
            this.getGraknGraph().getConceptLog().putConcept(this);
        }
        return (T)((Type)this.getThis());
    }

    protected void checkTypeMutation() {
        this.getGraknGraph().checkOntologyMutation();
        for (Schema.MetaSchema metaSchema : Schema.MetaSchema.values()) {
            if (!metaSchema.getName().equals(this.getName())) continue;
            throw new ConceptException(ErrorMessage.META_TYPE_IMMUTABLE.getMessage(new Object[]{metaSchema.getName()}));
        }
    }

    public RelationType hasResource(ResourceType resourceType, boolean required) {
        String resourceTypeName = resourceType.getName();
        RoleType ownerRole = this.getGraknGraph().putRoleTypeImplicit(Schema.Resource.HAS_RESOURCE_OWNER.getName(resourceTypeName));
        RoleType valueRole = this.getGraknGraph().putRoleTypeImplicit(Schema.Resource.HAS_RESOURCE_VALUE.getName(resourceTypeName));
        RelationType relationType = this.getGraknGraph().putRelationTypeImplicit(Schema.Resource.HAS_RESOURCE.getName(resourceTypeName)).hasRole(ownerRole).hasRole(valueRole);
        ResourceType resourceTypeSuper = resourceType.superType();
        if (resourceTypeSuper != null) {
            String superName = resourceTypeSuper.getName();
            if (!Schema.MetaSchema.RESOURCE.getName().equals(superName)) {
                RoleType ownerRoleSuper = this.getGraknGraph().putRoleTypeImplicit(Schema.Resource.HAS_RESOURCE_OWNER.getName(superName));
                RoleType valueRoleSuper = this.getGraknGraph().putRoleTypeImplicit(Schema.Resource.HAS_RESOURCE_VALUE.getName(superName));
                RelationType relationTypeSuper = this.getGraknGraph().putRelationTypeImplicit(Schema.Resource.HAS_RESOURCE.getName(superName)).hasRole(ownerRoleSuper).hasRole(valueRoleSuper);
                ownerRole.superType(ownerRoleSuper);
                valueRole.superType(valueRoleSuper);
                relationType.superType(relationTypeSuper);
                ((ResourceTypeImpl)resourceTypeSuper).playsRole(valueRoleSuper);
            }
        }
        this.playsRole(ownerRole, required);
        ((ResourceTypeImpl)resourceType).playsRole(valueRole, required);
        return relationType;
    }

    public String getName() {
        return (String)this.getProperty(Schema.ConceptProperty.NAME);
    }

    public RelationType hasResource(ResourceType resourceType) {
        return this.hasResource(resourceType, false);
    }

    public RelationType key(ResourceType resourceType) {
        return this.hasResource(resourceType, true);
    }
}

