/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graph.internal;

import ai.grakn.concept.Instance;
import ai.grakn.concept.RelationType;
import ai.grakn.concept.RoleType;
import ai.grakn.concept.Type;
import ai.grakn.exception.ConceptNotUniqueException;
import ai.grakn.graph.internal.CastingImpl;
import ai.grakn.graph.internal.EdgeImpl;
import ai.grakn.graph.internal.InstanceImpl;
import ai.grakn.graph.internal.RelationImpl;
import ai.grakn.graph.internal.RelationTypeImpl;
import ai.grakn.graph.internal.TypeImpl;
import ai.grakn.util.ErrorMessage;
import ai.grakn.util.Schema;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.structure.Direction;

class ValidateGlobalRules {
    private ValidateGlobalRules() {
        throw new UnsupportedOperationException();
    }

    static Optional<String> validatePlaysRoleStructure(CastingImpl casting) {
        InstanceImpl rolePlayer = casting.getRolePlayer();
        RoleType roleType = casting.getRole();
        boolean satisfiesPlaysRole = false;
        for (TypeImpl currentConcept = (TypeImpl)rolePlayer.type(); currentConcept != null; currentConcept = (TypeImpl)currentConcept.superType()) {
            Set<EdgeImpl> edges = currentConcept.getEdgesOfType(Direction.OUT, Schema.EdgeLabel.PLAYS_ROLE);
            for (EdgeImpl edge : edges) {
                if (!edge.getTarget().asType().getName().equals(roleType.getName())) continue;
                satisfiesPlaysRole = true;
                Boolean required = edge.getPropertyBoolean(Schema.EdgeProperty.REQUIRED);
                if (!required.booleanValue() || rolePlayer.relations(roleType).size() == 1) continue;
                return Optional.of(ErrorMessage.VALIDATION_REQUIRED_RELATION.getMessage(new Object[]{rolePlayer.getId(), roleType.getName(), rolePlayer.relations(roleType).size()}));
            }
        }
        if (satisfiesPlaysRole) {
            return Optional.empty();
        }
        return Optional.of(ErrorMessage.VALIDATION_CASTING.getMessage(new Object[]{rolePlayer.type().getName(), rolePlayer.getId(), casting.getRole().getName()}));
    }

    static Optional<String> validateHasSingleIncomingHasRoleEdge(RoleType roleType) {
        if (roleType.isAbstract().booleanValue()) {
            return Optional.empty();
        }
        if (roleType.relationTypes().isEmpty()) {
            return Optional.of(ErrorMessage.VALIDATION_ROLE_TYPE_MISSING_RELATION_TYPE.getMessage(new Object[]{roleType.getName()}));
        }
        return Optional.empty();
    }

    static Optional<String> validateHasMinimumRoles(RelationType relationType) {
        if (relationType.isAbstract().booleanValue() || relationType.hasRoles().size() >= 2) {
            return Optional.empty();
        }
        return Optional.of(ErrorMessage.VALIDATION_RELATION_TYPE.getMessage(new Object[]{relationType.getName()}));
    }

    static Optional<String> validateRelationshipStructure(RelationImpl relation) {
        RelationType relationType = (RelationType)relation.type();
        Set<CastingImpl> castings = relation.getMappingCasting();
        Collection roleTypes = relationType.hasRoles();
        if (castings.size() > roleTypes.size()) {
            return Optional.of(ErrorMessage.VALIDATION_RELATION_MORE_CASTING_THAN_ROLES.getMessage(new Object[]{relation.getId(), castings.size(), relationType.getName(), roleTypes.size()}));
        }
        for (CastingImpl casting : castings) {
            boolean notFound = true;
            for (RelationType innerRelationType : casting.getRole().relationTypes()) {
                if (!innerRelationType.getName().equals(relationType.getName())) continue;
                notFound = false;
                break;
            }
            if (!notFound) continue;
            return Optional.of(ErrorMessage.VALIDATION_RELATION_CASTING_LOOP_FAIL.getMessage(new Object[]{relation.getId(), casting.getRole().getName(), relationType.getName()}));
        }
        return Optional.empty();
    }

    static Optional<String> validateIsAbstractHasNoIncomingIsaEdges(TypeImpl conceptType) {
        if (conceptType.isAbstract().booleanValue() && conceptType.getVertex().edges(Direction.IN, new String[]{Schema.EdgeLabel.ISA.getLabel()}).hasNext()) {
            return Optional.of(ErrorMessage.VALIDATION_IS_ABSTRACT.getMessage(new Object[]{conceptType.getName()}));
        }
        return Optional.empty();
    }

    static Set<String> validateRelationTypesToRolesSchema(RelationTypeImpl relationType) {
        RelationTypeImpl superRelationType = (RelationTypeImpl)relationType.superType();
        if (Schema.MetaSchema.isMetaName((String)superRelationType.getName())) {
            return Collections.emptySet();
        }
        HashSet<String> errorMessages = new HashSet<String>();
        Collection<RoleType> superHasRoles = superRelationType.hasRoles();
        Collection<RoleType> hasRoles = relationType.hasRoles();
        Set hasRolesNames = hasRoles.stream().map(Type::getName).collect(Collectors.toSet());
        if (!superRelationType.isAbstract().booleanValue()) {
            HashSet allSuperRolesPlayed = new HashSet();
            superRelationType.getSuperSet().forEach(rel -> rel.hasRoles().forEach(roleType -> allSuperRolesPlayed.add(roleType.getName())));
            for (RoleType hasRole : hasRoles) {
                RoleType superRoleType = hasRole.superType();
                if (superRoleType != null && allSuperRolesPlayed.contains(superRoleType.getName())) continue;
                errorMessages.add(ErrorMessage.VALIDATION_RELATION_TYPES_ROLES_SCHEMA.getMessage(new Object[]{hasRole.getName(), relationType.getName(), "super", "super", superRelationType.getName()}));
            }
        }
        for (RoleType superHasRole : superHasRoles) {
            boolean subRoleNotFoundInHasRoles = true;
            for (RoleType subRoleType : superHasRole.subTypes()) {
                if (!hasRolesNames.contains(subRoleType.getName())) continue;
                subRoleNotFoundInHasRoles = false;
                break;
            }
            if (!subRoleNotFoundInHasRoles) continue;
            errorMessages.add(ErrorMessage.VALIDATION_RELATION_TYPES_ROLES_SCHEMA.getMessage(new Object[]{superHasRole.getName(), superRelationType.getName(), "sub", "sub", relationType.getName()}));
        }
        return errorMessages;
    }

    static Optional<String> validateInstancePlaysAllRequiredRoles(Instance instance) {
        for (TypeImpl currentConcept = (TypeImpl)instance.type(); currentConcept != null; currentConcept = (TypeImpl)currentConcept.superType()) {
            Set<EdgeImpl> edges = currentConcept.getEdgesOfType(Direction.OUT, Schema.EdgeLabel.PLAYS_ROLE);
            for (EdgeImpl edge : edges) {
                Boolean required = edge.getPropertyBoolean(Schema.EdgeProperty.REQUIRED);
                if (!required.booleanValue()) continue;
                RoleType roleType = edge.getTarget().asRoleType();
                if (!instance.relations(new RoleType[]{roleType}).isEmpty()) continue;
                return Optional.of(ErrorMessage.VALIDATION_INSTANCE.getMessage(new Object[]{instance.getId()}));
            }
        }
        return Optional.empty();
    }

    static Optional<String> validateRelationIsUnique(RelationImpl relation) {
        try {
            relation.setHash();
            return Optional.empty();
        }
        catch (ConceptNotUniqueException e) {
            return Optional.of(ErrorMessage.VALIDATION_RELATION_DUPLICATE.getMessage(new Object[]{relation}));
        }
    }
}

