/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graph.internal;

import ai.grakn.graph.internal.AbstractGraknGraph;
import ai.grakn.graph.internal.CastingImpl;
import ai.grakn.graph.internal.ConceptImpl;
import ai.grakn.graph.internal.InstanceImpl;
import ai.grakn.graph.internal.RelationImpl;
import ai.grakn.graph.internal.RelationTypeImpl;
import ai.grakn.graph.internal.RoleTypeImpl;
import ai.grakn.graph.internal.TypeImpl;
import ai.grakn.graph.internal.ValidateGlobalRules;
import ai.grakn.util.Schema;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

class Validator {
    private final AbstractGraknGraph graknGraph;
    private final List<String> errorsFound = new ArrayList<String>();

    public Validator(AbstractGraknGraph graknGraph) {
        this.graknGraph = graknGraph;
    }

    public List<String> getErrorsFound() {
        return this.errorsFound;
    }

    public boolean validate() {
        boolean originalValue = this.graknGraph.implicitConceptsVisible();
        this.graknGraph.showImplicitConcepts(true);
        HashSet<ConceptImpl> validationList = new HashSet<ConceptImpl>(this.graknGraph.getConceptLog().getModifiedConcepts());
        for (ConceptImpl nextToValidate : validationList) {
            if (!nextToValidate.isAlive()) continue;
            if (nextToValidate.isInstance() && !nextToValidate.isCasting()) {
                this.validateInstance((InstanceImpl)nextToValidate);
                if (!nextToValidate.isRelation()) continue;
                this.validateRelation((RelationImpl)nextToValidate);
                continue;
            }
            if (nextToValidate.isCasting()) {
                this.validateCasting((CastingImpl)nextToValidate);
                continue;
            }
            if (!nextToValidate.isType() || Schema.MetaSchema.isMetaName((String)nextToValidate.asType().getName())) continue;
            this.validateType((TypeImpl)nextToValidate);
            if (nextToValidate.isRoleType()) {
                this.validateRoleType((RoleTypeImpl)nextToValidate);
                continue;
            }
            if (!nextToValidate.isRelationType()) continue;
            this.validateRelationType((RelationTypeImpl)nextToValidate);
        }
        this.graknGraph.showImplicitConcepts(originalValue);
        return this.errorsFound.size() == 0;
    }

    private void validateRelation(RelationImpl relation) {
        ValidateGlobalRules.validateRelationshipStructure(relation).ifPresent(this.errorsFound::add);
        ValidateGlobalRules.validateRelationIsUnique(relation).ifPresent(this.errorsFound::add);
    }

    private void validateCasting(CastingImpl casting) {
        ValidateGlobalRules.validatePlaysRoleStructure(casting).ifPresent(this.errorsFound::add);
    }

    private void validateType(TypeImpl conceptType) {
        ValidateGlobalRules.validateIsAbstractHasNoIncomingIsaEdges(conceptType).ifPresent(this.errorsFound::add);
    }

    private void validateRoleType(RoleTypeImpl roleType) {
        ValidateGlobalRules.validateHasSingleIncomingHasRoleEdge(roleType).ifPresent(this.errorsFound::add);
    }

    private void validateRelationType(RelationTypeImpl relationType) {
        ValidateGlobalRules.validateHasMinimumRoles(relationType).ifPresent(this.errorsFound::add);
        this.errorsFound.addAll(ValidateGlobalRules.validateRelationTypesToRolesSchema(relationType));
    }

    private void validateInstance(InstanceImpl instance) {
        ValidateGlobalRules.validateInstancePlaysAllRequiredRoles(instance).ifPresent(this.errorsFound::add);
    }
}

