/*
 * Grakn - A Distributed Semantic Database
 * Copyright (C) 2016-2018 Grakn Labs Limited
 *
 * Grakn is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Grakn is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Grakn. If not, see <http://www.gnu.org/licenses/gpl.txt>.
 */

package ai.grakn.graql.internal.shell.animalia.chordata.mammalia.artiodactyla.hippopotamidae;

/**
 * The common hippopotamus (Hippopotamus amphibius), or hippo, is a large, mostly herbivorous mammal in sub-Saharan
 * Africa, and one of only two extant species in the family Hippopotamidae, the other being the pygmy hippopotamus
 * (Choeropsis liberiensis or Hexaprotodon liberiensis). The name comes from the ancient Greek for "river horse"
 * (ἱπποπόταμος). After the elephant and rhinoceros, the common hippopotamus is the third-largest type of land mammal
 * and the heaviest extant artiodactyl. Despite their physical resemblance to pigs and other terrestrial even-toed
 * ungulates, the closest living relatives of the Hippopotamidae are cetaceans (whales, porpoises, etc.) from which
 * they diverged about 55 million years ago. The common ancestor of whales and hippos split from other even-toed
 * ungulates around 60 million years ago. The earliest known hippopotamus fossils, belonging to the genus Kenyapotamus
 * in Africa, date to around 16 million years ago.
 *
 * @author Felix Chapman, Wikipedia
 */
public interface Hippopotamus {

    void submerge();

    @SuppressWarnings("unused")
    boolean isHungryHungry();
}
