/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql;

import ai.grakn.client.BatchExecutorClient;
import ai.grakn.client.Client;
import ai.grakn.client.GraknClient;
import ai.grakn.util.SimpleURI;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.Future;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.client.WebSocketClient;

class GraqlClient {
    private static final int DEFAULT_MAX_RETRY = 1;
    private static final long TIMEOUT = 3600000L;
    private WebSocketClient client = null;

    GraqlClient() {
    }

    Future<Session> connect(Object websocket, URI uri) {
        this.client = new WebSocketClient();
        this.client.getPolicy().setIdleTimeout(3600000L);
        try {
            this.client.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            return this.client.connect(websocket, uri);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        if (this.client == null) {
            throw new IllegalStateException("Closed client before connecting");
        }
        try {
            this.client.stop();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public BatchExecutorClient loaderClient(SimpleURI uri) {
        return BatchExecutorClient.newBuilder().threadPoolCoreSize(Runtime.getRuntime().availableProcessors() * 8).taskClient(GraknClient.of((SimpleURI)uri)).maxRetries(1).build();
    }

    public boolean serverIsRunning(SimpleURI uri) {
        return Client.serverIsRunning((SimpleURI)uri);
    }
}

