/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql;

import ai.grakn.Grakn;
import ai.grakn.Keyspace;
import ai.grakn.client.BatchExecutorClient;
import ai.grakn.graql.Graql;
import ai.grakn.graql.GraqlClient;
import ai.grakn.graql.JsonSession;
import ai.grakn.graql.WebSocketPing;
import ai.grakn.graql.internal.shell.ErrorMessage;
import ai.grakn.graql.internal.shell.GraqlCompleter;
import ai.grakn.graql.internal.shell.ShellCommandCompleter;
import ai.grakn.graql.internal.shell.animalia.chordata.mammalia.artiodactyla.hippopotamidae.HippopotamusFactory;
import ai.grakn.util.CommonUtil;
import ai.grakn.util.Schema;
import ai.grakn.util.SimpleURI;
import com.google.common.base.Splitter;
import com.google.common.base.StandardSystemProperty;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.ConnectException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.ws.rs.core.UriBuilder;
import jline.console.ConsoleReader;
import jline.console.completer.AggregateCompleter;
import jline.console.completer.Completer;
import jline.console.history.FileHistory;
import jline.console.history.History;
import mjson.Json;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.Charsets;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import rx.Observable;

public class GraqlShell {
    private static final String LICENSE_PROMPT = "\nGrakn  Copyright (C) 2018  Grakn Labs Limited \nThis is free software, and you are welcome to redistribute it \nunder certain conditions; type 'license' for details.\n";
    private static final String LICENSE_LOCATION = "LICENSE.txt";
    public static final String DEFAULT_KEYSPACE = "grakn";
    private static final String DEFAULT_OUTPUT_FORMAT = "graql";
    private static final String PROMPT = ">>> ";
    private static final String EDIT_COMMAND = "edit";
    private static final String COMMIT_COMMAND = "commit";
    private static final String ROLLBACK_COMMAND = "rollback";
    private static final String LOAD_COMMAND = "load";
    private static final String DISPLAY_COMMAND = "display";
    private static final String CLEAR_COMMAND = "clear";
    private static final String EXIT_COMMAND = "exit";
    private static final String LICENSE_COMMAND = "license";
    private static final String CLEAN_COMMAND = "clean";
    private static final String HI_POP_COMMAND = Schema.ImplicitType.HAS.name().substring(0, 1) + Integer.class.getSimpleName().substring(0, 1) + Strings.repeat((String)Schema.BaseType.TYPE.name().substring(2, 3), (int)2) + Object.class.getSimpleName().substring(0, 1);
    private static final int QUERY_CHUNK_SIZE = 50000;
    public static final ImmutableList<String> COMMANDS = ImmutableList.of((Object)"edit", (Object)"commit", (Object)"rollback", (Object)"load", (Object)"display", (Object)"clear", (Object)"exit", (Object)"license", (Object)"clean");
    private static final String TEMP_FILENAME = "/graql-tmp.gql";
    private static final String HISTORY_FILENAME = StandardSystemProperty.USER_HOME.value() + "/.graql-history";
    private static final String DEFAULT_EDITOR = "vim";
    private final File tempFile = new File(StandardSystemProperty.JAVA_IO_TMPDIR.value() + "/graql-tmp.gql");
    private ConsoleReader console;
    private final String historyFilename;
    private JsonSession session;
    private final GraqlCompleter graqlCompleter = new GraqlCompleter();
    private boolean errorOccurred = false;

    public static void main(String[] args) {
        int exitCode = GraqlShell.runShell(args, "1.1.0", HISTORY_FILENAME);
        System.exit(exitCode);
    }

    public static int runShell(String[] args, String version, String historyFilename) {
        boolean success = GraqlShell.runShell(args, version, historyFilename, new GraqlClient());
        return success ? 0 : 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean runShell(String[] args, String version, String historyFilename, GraqlClient client) {
        boolean infer;
        CommandLine cmd;
        Options options = new Options();
        options.addOption("k", "keyspace", true, "keyspace of the graph");
        options.addOption("e", "execute", true, "query to execute");
        options.addOption("f", "file", true, "graql file path to execute");
        options.addOption("r", "uri", true, "uri to factory to engine");
        options.addOption("b", "batch", true, "graql file path to batch load");
        options.addOption("s", "size", true, "the size of the batches (must be used with -b)");
        options.addOption("a", "active", true, "the number of active tasks (must be used with -b)");
        options.addOption("o", "output", true, "output format for results");
        options.addOption("n", "no_infer", false, "do not perform inference on results");
        options.addOption("h", "help", false, "print usage message");
        options.addOption("v", "version", false, "print version");
        DefaultParser parser = new DefaultParser();
        try {
            cmd = parser.parse(options, args);
        }
        catch (ParseException e) {
            System.err.println(e.getMessage());
            return false;
        }
        Optional<List<String>> queries = Optional.ofNullable(cmd.getOptionValue("e")).map(xva$0 -> Lists.newArrayList((Object[])new String[]{xva$0}));
        if (queries.isPresent()) {
            for (String query : queries.get()) {
                if (query.contains("$") || !query.trim().startsWith("match")) continue;
                System.err.println(ErrorMessage.NO_VARIABLE_IN_QUERY.getMessage(new Object[0]));
                break;
            }
        }
        String[] filePaths = cmd.getOptionValues("f");
        if (cmd.hasOption("h") || !cmd.getArgList().isEmpty()) {
            GraqlShell.printUsage(options, null);
            return true;
        }
        if (cmd.hasOption("v")) {
            System.out.println(version);
            return true;
        }
        Keyspace keyspace = Keyspace.of((String)cmd.getOptionValue("k", DEFAULT_KEYSPACE));
        SimpleURI location = Optional.ofNullable(cmd.getOptionValue("r")).map(SimpleURI::new).orElse(Grakn.DEFAULT_URI);
        String outputFormat = cmd.getOptionValue("o", DEFAULT_OUTPUT_FORMAT);
        if (!client.serverIsRunning(location)) {
            System.err.println(ErrorMessage.COULD_NOT_CONNECT.getMessage(new Object[0]));
            return false;
        }
        boolean bl = infer = !cmd.hasOption("n");
        if (cmd.hasOption("b")) {
            try {
                GraqlShell.sendBatchRequest(client.loaderClient(location), cmd.getOptionValue("b"), keyspace);
            }
            catch (NumberFormatException e) {
                GraqlShell.printUsage(options, "Cannot cast argument to an integer " + e.getMessage());
                return false;
            }
            catch (Exception e) {
                System.out.println("Batch failed \n" + CommonUtil.simplifyExceptionMessage((Throwable)e));
                return false;
            }
            return true;
        }
        if (cmd.hasOption("a") || cmd.hasOption("s")) {
            GraqlShell.printUsage(options, "The active or size option has been specified without batch.");
            return false;
        }
        try {
            if (filePaths != null) {
                queries = Optional.of(GraqlShell.loadQueries(filePaths));
            }
            URI uri = UriBuilder.fromUri((URI)location.toURI()).scheme("ws").path("/shell/remote").build(new Object[0]);
            GraqlShell shell = new GraqlShell(historyFilename, keyspace, client, uri, outputFormat, infer);
            shell.start(queries);
            boolean bl2 = !shell.errorOccurred;
            return bl2;
        }
        catch (ConnectException e) {
            System.err.println(ErrorMessage.COULD_NOT_CONNECT.getMessage(new Object[0]));
            boolean bl3 = false;
            return bl3;
        }
        catch (Throwable e) {
            System.err.println(ExceptionUtils.getFullStackTrace((Throwable)e));
            boolean bl4 = false;
            return bl4;
        }
        finally {
            client.close();
        }
    }

    private static void printUsage(Options options, @Nullable String footer) {
        HelpFormatter helpFormatter = new HelpFormatter();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)System.out, Charset.defaultCharset());
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(outputStreamWriter));
        int width = helpFormatter.getWidth();
        int leftPadding = helpFormatter.getLeftPadding();
        int descPadding = helpFormatter.getDescPadding();
        helpFormatter.printHelp(printWriter, width, "graql console", null, options, leftPadding, descPadding, footer);
        printWriter.flush();
    }

    private static List<String> loadQueries(String[] filePaths) throws IOException {
        ArrayList queries = Lists.newArrayList();
        for (String filePath : filePaths) {
            queries.add(GraqlShell.loadQuery(filePath));
        }
        return queries;
    }

    private static String loadQuery(String filePath) throws IOException {
        List<String> lines = Files.readAllLines(Paths.get(filePath, new String[0]), StandardCharsets.UTF_8);
        return lines.stream().collect(Collectors.joining("\n"));
    }

    private static void sendBatchRequest(BatchExecutorClient batchExecutorClient, String graqlPath, Keyspace keyspace) throws IOException {
        AtomicInteger queriesExecuted = new AtomicInteger(0);
        FileInputStream inputStream = new FileInputStream(Paths.get(graqlPath, new String[0]).toFile());
        try (InputStreamReader queryReader = new InputStreamReader((InputStream)inputStream, Charsets.UTF_8);){
            Graql.parser().parseList((Reader)queryReader).forEach(query -> {
                Observable observable = batchExecutorClient.add(query, keyspace, false);
                observable.subscribe(queryResponse -> queriesExecuted.incrementAndGet(), System.err::println);
            });
        }
        batchExecutorClient.close();
        System.out.println("Statements executed: " + queriesExecuted.get());
    }

    GraqlShell(String historyFilename, Keyspace keyspace, GraqlClient client, URI uri, String outputFormat, boolean infer) throws Throwable {
        this.historyFilename = historyFilename;
        this.console = new ConsoleReader(System.in, (OutputStream)System.out);
        this.session = new JsonSession(client, uri);
        Json initJson = Json.object((Object[])new Object[]{"action", "init", "keyspace", keyspace.getValue(), "outputFormat", outputFormat, "infer", infer});
        this.session.sendJson(initJson);
        this.handleMessagesFromServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start(Optional<List<String>> queryStrings) throws IOException {
        try {
            if (!this.session.isOpen()) {
                this.errorOccurred = true;
                return;
            }
            Thread thread = new Thread(() -> WebSocketPing.ping(this.session), "graql-shell-ping");
            thread.setDaemon(true);
            thread.start();
            if (queryStrings.isPresent()) {
                for (String queryString : queryStrings.get()) {
                    this.executeQuery(queryString);
                    this.commit();
                }
            } else {
                this.executeRepl();
            }
        }
        finally {
            this.console.flush();
        }
    }

    void executeRepl() throws IOException {
        String queryString;
        boolean success;
        this.console.print((CharSequence)LICENSE_PROMPT);
        this.console.setExpandEvents(false);
        this.console.setPrompt(PROMPT);
        if (!this.tempFile.exists() && !(success = this.tempFile.createNewFile())) {
            this.print(ErrorMessage.COULD_NOT_CREATE_TEMP_FILE.getMessage(new Object[0]));
        }
        this.setupHistory();
        this.console.addCompleter((Completer)new AggregateCompleter(new Completer[]{this.graqlCompleter, new ShellCommandCompleter()}));
        Pattern commandPattern = Pattern.compile("\\s*(.*?)\\s*;?");
        block22: while ((queryString = this.console.readLine()) != null) {
            Matcher matcher = commandPattern.matcher(queryString);
            if (matcher.matches()) {
                switch (matcher.group(1)) {
                    case "edit": {
                        this.executeQuery(this.runEditor());
                        continue block22;
                    }
                    case "commit": {
                        this.commit();
                        continue block22;
                    }
                    case "rollback": {
                        this.rollback();
                        continue block22;
                    }
                    case "clean": {
                        this.clean();
                        continue block22;
                    }
                    case "clear": {
                        this.console.clearScreen();
                        continue block22;
                    }
                    case "license": {
                        this.printLicense();
                        continue block22;
                    }
                    case "exit": {
                        return;
                    }
                    case "": {
                        continue block22;
                    }
                }
            }
            if (queryString.equals(HI_POP_COMMAND)) {
                HippopotamusFactory.increasePop(this.console);
                continue;
            }
            if (queryString.startsWith("load ")) {
                String path = queryString.substring(LOAD_COMMAND.length() + 1);
                path = StringEscapeUtils.unescapeJavaScript((String)path);
                try {
                    queryString = GraqlShell.loadQuery(path);
                }
                catch (IOException e) {
                    System.err.println(e.toString());
                    this.errorOccurred = true;
                    continue;
                }
            }
            if (queryString.startsWith("display ")) {
                int endIndex = queryString.endsWith(";") ? queryString.length() - 1 : queryString.length();
                String[] arguments = queryString.substring(DISPLAY_COMMAND.length() + 1, endIndex).split(",");
                Set<String> resources = Stream.of(arguments).map(String::trim).collect(Collectors.toSet());
                this.setDisplayOptions(resources);
                continue;
            }
            this.executeQuery(queryString);
        }
    }

    private boolean setupHistory() throws IOException {
        File historyFile = new File(this.historyFilename);
        boolean fileCreated = historyFile.createNewFile();
        FileHistory history = new FileHistory(historyFile);
        this.console.setHistory((History)history);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                history.flush();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }));
        return fileCreated;
    }

    private void printLicense() {
        StringBuilder result = new StringBuilder("");
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        InputStream is = classloader.getResourceAsStream(LICENSE_LOCATION);
        Scanner scanner = new Scanner(is, StandardCharsets.UTF_8.name());
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            result.append(line).append("\n");
        }
        result.append("\n");
        scanner.close();
        this.print(result.toString());
    }

    private boolean executeQuery(String queryString) throws IOException {
        Iterable splitQuery = Splitter.fixedLength((int)50000).split((CharSequence)queryString);
        for (String queryChunk : splitQuery) {
            Json jsonObject = Json.object((Object[])new Object[]{"action", "query", "query", queryChunk});
            this.session.sendJson(jsonObject);
        }
        this.session.sendJson(Json.object((Object[])new Object[]{"action", "end"}));
        this.handleMessagesFromServer();
        this.console.flush();
        return true;
    }

    private void handleMessagesFromServer() {
        this.session.getMessagesUntilEnd().forEach(this::handleMessage);
    }

    private void handleMessage(Json message) {
        switch (message.at("action").asString()) {
            case "query": {
                String result = message.at("result").asString();
                this.print(result);
                break;
            }
            case "types": {
                Set<String> types = message.at("types").asJsonList().stream().map(Json::asString).collect(Collectors.toSet());
                this.graqlCompleter.setTypes(types);
                break;
            }
            case "error": {
                System.err.print(message.at("error").asString());
                this.errorOccurred = true;
                break;
            }
            case "ping": {
                break;
            }
            default: {
                throw new RuntimeException("Unrecognized message: " + message);
            }
        }
    }

    private void setDisplayOptions(Set<String> displayOptions) throws IOException {
        this.session.sendJson(Json.object((Object[])new Object[]{"action", DISPLAY_COMMAND, DISPLAY_COMMAND, displayOptions}));
    }

    private void commit() throws IOException {
        this.session.sendJson(Json.object((Object[])new Object[]{"action", COMMIT_COMMAND}));
        this.handleMessagesFromServer();
    }

    private void rollback() throws IOException {
        this.session.sendJson(Json.object((Object[])new Object[]{"action", ROLLBACK_COMMAND}));
    }

    private void clean() throws IOException {
        this.console.println((CharSequence)"Are you sure? This will clean ALL data in the current keyspace and immediately commit.");
        this.console.println((CharSequence)"Type 'confirm' to continue.");
        String line = this.console.readLine();
        if (line != null && line.equals("confirm")) {
            this.console.println((CharSequence)"Cleaning...");
            this.session.sendJson(Json.object((Object[])new Object[]{"action", CLEAN_COMMAND}));
        } else {
            this.console.println((CharSequence)"Cancelling clean.");
        }
    }

    private String runEditor() throws IOException {
        Map<String, String> env = System.getenv();
        String editor = Optional.ofNullable(env.get("EDITOR")).orElse(DEFAULT_EDITOR);
        ProcessBuilder builder = new ProcessBuilder("/bin/bash", "-c", editor + " </dev/tty >/dev/tty " + this.tempFile.getAbsolutePath());
        try {
            builder.start().waitFor();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return String.join((CharSequence)"\n", Files.readAllLines(this.tempFile.toPath()));
    }

    private void print(String string) {
        try {
            this.console.print((CharSequence)string);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

