/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql;

import ai.grakn.graql.GraqlClient;
import java.io.IOException;
import java.net.URI;
import java.util.Spliterators;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import mjson.Json;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketException;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;

@WebSocket
public class JsonSession {
    private final Session session;
    private static final long DEFAULT_TIMEOUT = Long.MAX_VALUE;
    private final ExecutorService executor = Executors.newSingleThreadExecutor(runnable -> {
        Thread thread = Executors.defaultThreadFactory().newThread(runnable);
        thread.setDaemon(true);
        thread.setName("json-session");
        return thread;
    });
    private final BlockingQueue<Json> messages = new LinkedBlockingQueue<Json>();
    private final long timeout;

    JsonSession(GraqlClient client, URI uri) {
        this(client, uri, Long.MAX_VALUE);
    }

    JsonSession(GraqlClient client, URI uri, long timeout) {
        this.timeout = timeout;
        try {
            this.session = client.connect(this, uri).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    boolean isOpen() {
        return this.session.isOpen();
    }

    Stream<Json> getMessagesUntilEnd() {
        Spliterators.AbstractSpliterator<Json> spliterator = new Spliterators.AbstractSpliterator<Json>(Long.MAX_VALUE, 1024){

            @Override
            public boolean tryAdvance(Consumer<? super Json> action) {
                Json message = JsonSession.this.getMessage();
                if (message == null) {
                    System.err.println("Timeout while contacting engine");
                }
                if (message == null || message.is("action", (Object)"end")) {
                    return false;
                }
                action.accept((Json)message);
                return true;
            }
        };
        return StreamSupport.stream(spliterator, false);
    }

    private Json getMessage() {
        try {
            return this.messages.poll(this.timeout, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    void sendJson(Json json) throws WebSocketException, IOException {
        try {
            this.executor.submit(() -> {
                try {
                    this.session.getRemote().sendString(json.toString());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            Throwable inner = e.getCause();
            Throwable cause = inner.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            assert (inner instanceof RuntimeException);
            throw (RuntimeException)inner;
        }
    }

    @OnWebSocketClose
    public void onClose(int statusCode, String reason) throws IOException, ExecutionException, InterruptedException {
        if (statusCode != 1000 && statusCode != 1001) {
            System.err.println("Websocket closed, code: " + statusCode + ", reason: " + reason);
        }
        this.messages.add(Json.object((Object[])new Object[]{"action", "end"}));
    }

    @OnWebSocketMessage
    public void onMessage(String msg) {
        Json json = Json.read((String)msg);
        this.messages.add(json);
    }
}

