/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.shell.animalia.chordata.mammalia.artiodactyla.hippopotamidae;

import ai.grakn.graql.internal.shell.animalia.chordata.mammalia.artiodactyla.hippopotamidae.Hippopotamus;
import ai.grakn.graql.internal.shell.animalia.chordata.mammalia.artiodactyla.hippopotamidae.LargeHippopotamusImpl;
import ai.grakn.graql.internal.shell.animalia.chordata.mammalia.artiodactyla.hippopotamidae.SmallHippopotamusImpl;
import ai.grakn.graql.internal.shell.animalia.chordata.mammalia.artiodactyla.hippopotamidae.TitanicHippopotamusImpl;
import java.io.IOException;
import jline.console.ConsoleReader;
import org.apache.commons.lang.StringUtils;

public class HippopotamusFactory {
    private int size = 10;

    public static HippopotamusFactory builder() {
        return new HippopotamusFactory();
    }

    public HippopotamusFactory size(int size) {
        this.size = size;
        return this;
    }

    public Hippopotamus build() {
        if (this.size < 5) {
            return new SmallHippopotamusImpl();
        }
        if (this.size < Integer.MAX_VALUE) {
            return new LargeHippopotamusImpl();
        }
        return new TitanicHippopotamusImpl();
    }

    public static void increasePop(ConsoleReader console) {
        HippopotamusFactory builder = HippopotamusFactory.builder();
        if (System.getenv("HIPPO_SIZE") != null) {
            int hippoSize = Integer.parseInt(System.getenv("HIPPO_SIZE"));
            builder.size(hippoSize);
        }
        Hippopotamus hippo = builder.build();
        try {
            for (double i = 0.0; i < Math.PI; i += 0.1) {
                console.println((CharSequence)hippo.toString().replaceAll("^|\n", "\n" + StringUtils.repeat((String)" ", (int)((int)(Math.sin(i) * 100.0)))));
                console.flush();
                Thread.sleep(100L);
            }
        }
        catch (IOException | InterruptedException e) {
            System.err.println("Supercalafrajilistichippopotamusexception");
        }
        hippo.submerge();
        console.setPrompt(hippo.toString());
    }
}

