/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.analytics;

import ai.grakn.graql.internal.analytics.BulkResourceMutate;
import ai.grakn.graql.internal.analytics.GraknVertexProgram;
import ai.grakn.graql.internal.analytics.Utility;
import ai.grakn.util.ErrorMessage;
import ai.grakn.util.Schema;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.process.computer.Memory;
import org.apache.tinkerpop.gremlin.process.computer.MessageScope;
import org.apache.tinkerpop.gremlin.process.computer.Messenger;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public class ConnectedComponentVertexProgram
extends GraknVertexProgram<String> {
    private static final int MAX_ITERATION = 100;
    private static final String MIN_STRING = "0";
    private static final String IS_ACTIVE_CASTING = "connectedComponentVertexProgram.isActiveCasting";
    public static final String CLUSTER_LABEL = "connectedComponentVertexProgram.clusterLabel";
    private static final String VOTE_TO_HALT = "connectedComponentVertexProgram.voteToHalt";
    private static final String IS_LAST_ITERATION = "connectedComponentVertexProgram.isLastIteration";
    private static final Set<String> ELEMENT_COMPUTE_KEYS = Sets.newHashSet((Object[])new String[]{"connectedComponentVertexProgram.isActiveCasting", "connectedComponentVertexProgram.clusterLabel"});
    private static final Set<String> MEMORY_COMPUTE_KEYS = Sets.newHashSet((Object[])new String[]{"connectedComponentVertexProgram.voteToHalt", "connectedComponentVertexProgram.isLastIteration"});
    private static final String MESSAGE_FROM_ROLE_PLAYER = "R";
    private static final String MESSAGE_FROM_ASSERTION = "A";
    private static final String PERSIST = "connectedComponentVertexProgram.persist";
    private static final String KEYSPACE = "connectedComponentVertexProgram.keyspace";
    private static final String WITHOUT_HAS_RESOURCE = "connectedComponentVertexProgram.without";
    private static final String CLUSTER_NAME = "connectedComponentVertexProgram.clusterName";
    private BulkResourceMutate<String> bulkResourceMutate;
    private Set<String> withoutHasResource = new HashSet<String>();
    private Set<String> selectedLabels = new HashSet<String>();

    public ConnectedComponentVertexProgram() {
    }

    public ConnectedComponentVertexProgram(Set<String> selectedTypes) {
        this.selectedTypes = selectedTypes;
        this.persistentProperties.put(PERSIST, false);
    }

    public ConnectedComponentVertexProgram(Set<String> selectedTypes, Set<String> withoutHasResource, String keyspace, String clusterName) {
        this.selectedTypes = selectedTypes;
        this.withoutHasResource = withoutHasResource;
        this.persistentProperties.put(PERSIST, true);
        this.persistentProperties.put(KEYSPACE, keyspace);
        this.persistentProperties.put(CLUSTER_NAME, clusterName);
        System.out.println("withoutHasResource = " + withoutHasResource);
    }

    public ConnectedComponentVertexProgram(Set<String> selectedTypes, Set<String> withoutHasResource, String keyspace, String clusterName, Set<String> selectedLabels) {
        this(selectedTypes, withoutHasResource, keyspace, clusterName);
        this.selectedLabels = selectedLabels;
    }

    @Override
    public void storeState(Configuration configuration) {
        super.storeState(configuration);
        this.withoutHasResource.forEach(type -> configuration.addProperty("connectedComponentVertexProgram.without." + type, type));
        this.selectedLabels.forEach(label -> configuration.addProperty("connectedComponentVertexProgram.clusterLabel." + label, label));
    }

    @Override
    public void loadState(Graph graph, Configuration configuration) {
        super.loadState(graph, configuration);
        configuration.subset(WITHOUT_HAS_RESOURCE).getKeys().forEachRemaining(key -> this.withoutHasResource.add((String)configuration.getProperty("connectedComponentVertexProgram.without." + key)));
        configuration.subset(CLUSTER_LABEL).getKeys().forEachRemaining(key -> this.selectedLabels.add((String)configuration.getProperty("connectedComponentVertexProgram.clusterLabel." + key)));
    }

    public Set<String> getElementComputeKeys() {
        return ELEMENT_COMPUTE_KEYS;
    }

    public Set<String> getMemoryComputeKeys() {
        return MEMORY_COMPUTE_KEYS;
    }

    @Override
    public void setup(Memory memory) {
        LOGGER.debug("ConnectedComponentVertexProgram Started !!!!!!!!");
        memory.set(VOTE_TO_HALT, (Object)true);
        memory.set(IS_LAST_ITERATION, (Object)false);
    }

    @Override
    public void safeExecute(Vertex vertex, Messenger<String> messenger, Memory memory) {
        switch (memory.getIteration()) {
            case 0: {
                if (!this.selectedTypes.contains(Utility.getVertexType(vertex))) break;
                String type = vertex.label();
                if (type.equals(Schema.BaseType.ENTITY.name()) || type.equals(Schema.BaseType.RESOURCE.name())) {
                    messenger.sendMessage((MessageScope)messageScopeIn, (Object)MESSAGE_FROM_ROLE_PLAYER);
                    break;
                }
                if (!type.equals(Schema.BaseType.RELATION.name())) break;
                messenger.sendMessage((MessageScope)messageScopeIn, (Object)MESSAGE_FROM_ROLE_PLAYER);
                messenger.sendMessage((MessageScope)messageScopeOut, (Object)MESSAGE_FROM_ASSERTION);
                break;
            }
            case 1: {
                if (vertex.label().equals(Schema.BaseType.CASTING.name())) {
                    HashSet messageSet = new HashSet();
                    boolean hasBothMessages = false;
                    Iterator iterator = messenger.receiveMessages();
                    while (iterator.hasNext()) {
                        messageSet.add(iterator.next());
                        if (messageSet.size() != 2) continue;
                        hasBothMessages = true;
                        break;
                    }
                    vertex.property(IS_ACTIVE_CASTING, (Object)hasBothMessages);
                    break;
                }
                if (!this.selectedTypes.contains(Utility.getVertexType(vertex))) break;
                String id = vertex.id().toString();
                vertex.property(CLUSTER_LABEL, (Object)id);
                messenger.sendMessage((MessageScope)messageScopeIn, (Object)id);
                messenger.sendMessage((MessageScope)messageScopeOut, (Object)id);
                break;
            }
            case 2: {
                if (!vertex.label().equals(Schema.BaseType.CASTING.name()) || !((Boolean)vertex.value(IS_ACTIVE_CASTING)).booleanValue()) break;
                String max = (String)IteratorUtils.reduce((Iterator)messenger.receiveMessages(), (Object)MIN_STRING, (a, b) -> a.compareTo((String)b) > 0 ? a : b);
                vertex.property(CLUSTER_LABEL, (Object)max);
                messenger.sendMessage((MessageScope)messageScopeIn, (Object)max);
                messenger.sendMessage((MessageScope)messageScopeOut, (Object)max);
                break;
            }
            default: {
                if (((Boolean)memory.get(IS_LAST_ITERATION)).booleanValue()) {
                    if (!this.withoutHasResource.contains(Utility.getVertexType(vertex)) || !this.selectedLabels.isEmpty() && !this.selectedLabels.contains(vertex.value(CLUSTER_LABEL))) break;
                    this.bulkResourceMutate.putValue(vertex, (String)vertex.value(CLUSTER_LABEL));
                    break;
                }
                if (memory.getIteration() % 2 == 1) {
                    if (!this.selectedTypes.contains(Utility.getVertexType(vertex))) break;
                    this.update(vertex, messenger, memory);
                    break;
                }
                if (!vertex.label().equals(Schema.BaseType.CASTING.name()) || !((Boolean)vertex.value(IS_ACTIVE_CASTING)).booleanValue()) break;
                this.update(vertex, messenger, memory);
            }
        }
    }

    private void update(Vertex vertex, Messenger<String> messenger, Memory memory) {
        String currentMax = (String)vertex.value(CLUSTER_LABEL);
        String max = (String)IteratorUtils.reduce((Iterator)messenger.receiveMessages(), (Object)currentMax, (a, b) -> a.compareTo((String)b) > 0 ? a : b);
        if (max.compareTo(currentMax) > 0) {
            vertex.property(CLUSTER_LABEL, (Object)max);
            messenger.sendMessage((MessageScope)messageScopeIn, (Object)max);
            messenger.sendMessage((MessageScope)messageScopeOut, (Object)max);
            memory.and(VOTE_TO_HALT, false);
        }
    }

    public boolean terminate(Memory memory) {
        LOGGER.debug("Finished Iteration " + memory.getIteration());
        if (memory.getIteration() < 3) {
            return false;
        }
        if (((Boolean)memory.get(IS_LAST_ITERATION)).booleanValue()) {
            return true;
        }
        boolean voteToHalt = (Boolean)memory.get(VOTE_TO_HALT);
        if (voteToHalt) {
            if (!((Boolean)this.persistentProperties.get(PERSIST)).booleanValue()) {
                return true;
            }
            LOGGER.debug("Persisting Resources ...");
            memory.set(IS_LAST_ITERATION, (Object)true);
            return false;
        }
        if (memory.getIteration() == 100) {
            LOGGER.debug("Reached Max Iteration: 100 !!!!!!!!");
            throw new IllegalStateException(ErrorMessage.MAX_ITERATION_REACHED.getMessage(new Object[]{this.getClass().toString()}));
        }
        memory.or(VOTE_TO_HALT, true);
        return false;
    }

    public void workerIterationStart(Memory memory) {
        if (((Boolean)this.persistentProperties.get(PERSIST)).booleanValue() && ((Boolean)memory.get(IS_LAST_ITERATION)).booleanValue()) {
            LOGGER.debug("Iteration " + memory.getIteration() + ", workerIterationStart");
            this.bulkResourceMutate = new BulkResourceMutate((String)this.persistentProperties.get(KEYSPACE), (String)this.persistentProperties.get(CLUSTER_NAME));
        }
    }

    public void workerIterationEnd(Memory memory) {
        if (((Boolean)this.persistentProperties.get(PERSIST)).booleanValue() && ((Boolean)memory.get(IS_LAST_ITERATION)).booleanValue()) {
            LOGGER.debug("Iteration " + memory.getIteration() + ", workerIterationEnd");
            this.bulkResourceMutate.flush();
        }
    }
}

